/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.FieldNames;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.DomainObjectFactoryImpl;
import com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDouble;
import org.bson.BsonValue;
import org.bson.Document;

public class DoubleVectorFixMongoHandlerImpl
implements FixMongoHandler<DoubleVectorFix> {
    private final MongoObjectFactoryImpl mof;
    private final DomainObjectFactoryImpl dof;

    public DoubleVectorFixMongoHandlerImpl(MongoObjectFactory mof, DomainObjectFactory dof) {
        this.mof = (MongoObjectFactoryImpl)mof;
        this.dof = (DomainObjectFactoryImpl)dof;
    }

    public Document transformForth(DoubleVectorFix fix) throws IllegalArgumentException {
        Document result = new Document();
        this.mof.storeTimed((Timed)fix, result);
        result.put(FieldNames.FIX.name(), (Object)this.toDBObject(fix.get()));
        return result;
    }

    public DoubleVectorFix transformBack(Document dbObject) {
        TimePoint timePoint = this.dof.loadTimePoint(dbObject);
        return new DoubleVectorFixImpl(timePoint, this.fromDBObject(dbObject.get((Object)FieldNames.FIX.name())));
    }

    private BsonArray toDBObject(Double[] data) {
        BsonArray result = new BsonArray();
        Double[] doubleArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Double value = doubleArray[n2];
            result.add((BsonValue)(value == null ? new BsonDouble(0.0) : new BsonDouble(value.doubleValue())));
            ++n2;
        }
        return result;
    }

    private Double[] fromDBObject(Object dbObject) {
        List dbValues = (List)dbObject;
        Double[] result = new Double[dbValues.size()];
        int i = 0;
        while (i < dbValues.size()) {
            result[i] = dbValues.get(i) == null ? null : Double.valueOf(((Number)dbValues.get(i)).doubleValue());
            ++i;
        }
        return result;
    }
}

