/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.AwsSessionCredentialsWithExpiry;
import com.sap.sailing.landscape.LandscapeService;
import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.gateway.impl.AwsApplicationProcessJsonSerializer;
import com.sap.sailing.landscape.gateway.impl.AwsApplicationReplicaSetJsonSerializer;
import com.sap.sailing.landscape.gateway.impl.HostJsonSerializer;
import com.sap.sailing.landscape.gateway.jaxrs.AbstractLandscapeResource;
import com.sap.sailing.landscape.procedures.SailingAnalyticsHostSupplier;
import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sailing.server.gateway.serialization.impl.CompareServersResultJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DataImportProgressJsonSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.MongoUriParser;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.mongodb.MongoEndpoint;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import software.amazon.awssdk.services.ec2.model.InstanceType;

@Path(value="/landscape")
public class SailingLandscapeResource
extends AbstractLandscapeResource {
    private static final Logger logger = Logger.getLogger(SailingLandscapeResource.class.getName());
    private static final String REGION_FORM_PARAM = "regionId";
    private static final String SHARED_MASTER_INSTANCE_FORM_PARAM = "sharedMasterInstance";
    private static final String REPLICA_SET_NAME_FORM_PARAM = "replicaSetName";
    private static final String DEDICATED_INSTANCE_TYPE_FORM_PARAM = "dedicatedInstanceType";
    private static final String SHARED_INSTANCE_TYPE_FORM_PARAM = "sharedInstanceType";
    private static final String INSTANCE_ID = "instanceId";
    private static final String INSTANCE_TYPE_FORM_PARAM = "instanceType";
    private static final String DYNAMIC_LOAD_BALANCER_MAPPING_FORM_PARAM = "dynamicLoadBalancerMapping";
    private static final String RELEASE_NAME_FORM_PARAM = "releaseName";
    private static final String KEY_NAME_FORM_PARAM = "keyName";
    private static final String PRIVATE_KEY_ENCRYPTION_PASSPHRASE_FORM_PARAM = "privateKeyEncryptionPassphrase";
    private static final String MASTER_REPLICATION_BEARER_TOKEN_FORM_PARAM = "masterReplicationBearerToken";
    private static final String REPLICA_REPLICATION_BEARER_TOKEN_FORM_PARAM = "replicaReplicationBearerToken";
    private static final String DOMAIN_NAME_FORM_PARAM = "domainName";
    private static final String MEMORY_IN_MEGABYTES_FORM_PARAM = "memoryInMegabytes";
    private static final String MEMORY_TOTAL_SIZE_FACTOR_FORM_PARAM = "memoryTotalSizeFactor";
    private static final String MINIMUM_AUTO_SCALING_GROUP_SIZE_FORM_PARAM = "minimumAutoScalingGroupSize";
    private static final String MAXIMUM_AUTO_SCALING_GROUP_SIZE_FORM_PARAM = "maximumAutoScalingGroupSize";
    private static final String TIMEOUT_IN_MILLISECONDS_FORM_PARAM = "timeoutInMilliseconds";
    private static final String REMOVE_APPLICATION_REPLICA_SET_FORM_PARAM = "removeApplicationReplicaSet";
    private static final String MAX_NUMBER_OF_COMPARE_SERVER_ATTEMPTS_FORM_PARAM = "maxNumberOfCompareserverAttempts";
    private static final String DURATION_TO_WAIT_BEFORE_COMPARE_SERVERS_IN_MILLISECONDS_FORM_PARAM = "durationToWaitBeforeCompareServersInMilliseconds";
    private static final String MDI_PROGRESS = "mdiProgress";
    private static final String COMPARE_SERVERS_RESULT = "compareServersResult";
    private static final String ARCHIVE_MONGODB_RESULT = "archiveMongoDBResult";
    private static final String BEARER_TOKEN_FOR_REPLICA_SET_TO_ARCHIVE_FORM_PARAM = "bearerTokenForReplicaSetToArchive";
    private static final String BEARER_TOKEN_FOR_ARCHIVE_FORM_PARAM = "bearerTokenForArchive";
    private static final String MONGO_URI_TO_ARCHIVE_DB_TO_FORM_PARAM = "mongoUriToArchiveDbTo";
    private static final String AWS_KEY_ID_FORM_PARAM = "awsKeyId";
    private static final String AWS_KEY_SECRET_FORM_PARAM = "awsKeySecret";
    private static final String AWS_MFA_TOKEN_FORM_PARAM = "awsMfaToken";
    private static final String AWS_SESSION_TOKEN_FORM_PARAM = "awsSessionToken";
    private static final String SESSION_TOKEN_EXPIRY_UNIX_TIME_MILLIS = "sessionTokenExpiryMillis";
    private static final String SESSION_TOKEN_EXPIRY_ISO = "sessionTokenExpiryISO";
    private static final String RESPONSE_STATUS = "status";
    private static final String RESPONSE_ERROR_MESSAGE = "message";
    private static final String RESPONSE_RELEASE = "release";
    private static final String HOST_ID_FORM_PARAM = "hostId";
    private static final String NEW_HOST_ID = "newHostId";
    private static final String MASTER_PROCESSES_MOVED = "masterProcessesMoved";
    private static final String REPLICA_PROCESSES_MOVED = "replicaProcessesMoved";
    private static final String REPLICA_SET_NAME = "replicaSetName";
    private static final String PORT = "port";
    private static final String IGTIMI_RIOT_PORT = "igtimiRiotPort";
    @Context
    UriInfo uriInfo;

    @Path(value="/createmfasessioncredentials")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createMfaSessionCredentials(@FormParam(value="awsKeyId") String awsKeyId, @FormParam(value="awsKeySecret") String awsKeySecret, @FormParam(value="awsMfaToken") String mfaToken) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            this.getLandscapeService().createMfaSessionCredentials(awsKeyId, awsKeySecret, mfaToken);
            response = Response.ok().build();
        }
        catch (Exception e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return response;
    }

    @Path(value="/createsessioncredentials")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createSessionCredentials(@FormParam(value="awsKeyId") String awsKeyId, @FormParam(value="awsKeySecret") String awsKeySecret, @FormParam(value="awsSessionToken") String sessionToken) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            this.getLandscapeService().createSessionCredentials(awsKeyId, awsKeySecret, sessionToken);
            response = Response.ok().build();
        }
        catch (Exception e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return response;
    }

    @Path(value="/getsessioncredentials")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getSessionCredentials() {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            AwsSessionCredentialsWithExpiry sessionCredentials = this.getLandscapeService().getSessionCredentials();
            if (sessionCredentials == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No session credentials found for user " + this.getSecurityService().getCurrentUser().getName())).build();
            } else {
                JSONObject result = new JSONObject();
                result.put((Object)SESSION_TOKEN_EXPIRY_UNIX_TIME_MILLIS, (Object)sessionCredentials.getExpiration().asMillis());
                result.put((Object)SESSION_TOKEN_EXPIRY_ISO, (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(sessionCredentials.getExpiration().asDate()));
                response = Response.ok().entity((Object)this.streamingOutput(result)).build();
            }
        }
        catch (Exception e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return response;
    }

    @Path(value="/clearsessioncredentials")
    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response clearSessionCredentials() {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            this.getLandscapeService().clearSessionCredentials();
            response = Response.ok().build();
        }
        catch (Exception e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        return response;
    }

    @Path(value="/createapplicationreplicaset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createApplicationReplicaSet(@FormParam(value="regionId") String regionId, @FormParam(value="sharedMasterInstance") @DefaultValue(value="false") boolean sharedMasterInstance, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="dedicatedInstanceType") String dedicatedInstanceType, @FormParam(value="sharedInstanceType") String sharedInstanceTypeOrNull, @FormParam(value="dynamicLoadBalancerMapping") @DefaultValue(value="false") boolean dynamicLoadBalancerMapping, @FormParam(value="releaseName") String releaseNameOrNullForLatestMaster, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="masterReplicationBearerToken") String masterReplicationBearerToken, @FormParam(value="replicaReplicationBearerToken") String replicaReplicationBearerToken, @FormParam(value="domainName") String domainName, @FormParam(value="memoryInMegabytes") Integer optionalMemoryInMegabytesOrNull, @FormParam(value="memoryTotalSizeFactor") Integer optionalMemoryTotalSizeFactorOrNull, @FormParam(value="minimumAutoScalingGroupSize") Integer optionalMinimumAutoScalingGroupSize, @FormParam(value="maximumAutoScalingGroupSize") Integer optionalMaximumAutoScalingGroupSize, @FormParam(value="igtimiRiotPort") Integer optionalIgtimiRiotPort) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            Release release = this.getLandscapeService().getRelease(releaseNameOrNullForLatestMaster);
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().createApplicationReplicaSet(regionId, replicaSetName, sharedMasterInstance, sharedInstanceTypeOrNull, dedicatedInstanceType, dynamicLoadBalancerMapping, release.getName(), optionalKeyName, privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes(), masterReplicationBearerToken, replicaReplicationBearerToken, domainName, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort, Optional.ofNullable(optionalMinimumAutoScalingGroupSize), Optional.ofNullable(optionalMaximumAutoScalingGroupSize));
            JSONObject result = new AwsApplicationReplicaSetJsonSerializer(release.getName()).serialize((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)replicaSet);
            response = Response.ok((Object)this.streamingOutput(result)).build();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception trying to create application replica set " + replicaSetName + " on behalf of user " + this.getSecurityService().getCurrentUser(), e);
            response = this.badRequest(e.getMessage());
        }
        return response;
    }

    @Path(value="/upgradeapplicationreplicaset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response upgradeApplicationReplicaSet(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="releaseName") String releaseNameOrNullForLatestMaster, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="replicaReplicationBearerToken") String replicaReplicationBearerToken, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds) {
        Response.ResponseBuilder responseBuilder;
        this.checkLandscapeManageAwsPermission();
        JSONObject result = new JSONObject();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            AwsApplicationReplicaSet upgradedReplicaSet = this.getLandscapeService().upgradeApplicationReplicaSet(region, replicaSet, releaseNameOrNullForLatestMaster, optionalKeyName, passphraseForPrivateKeyDecryption, replicaReplicationBearerToken);
            responseBuilder = Response.ok();
            result.put((Object)RESPONSE_STATUS, (Object)"OK");
            result.put((Object)RESPONSE_RELEASE, (Object)upgradedReplicaSet.getVersion(Optional.ofNullable(optionalTimeoutInMilliseconds).map(Duration::ofMillis), Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption).getName());
        }
        catch (Exception e) {
            result.put((Object)RESPONSE_STATUS, (Object)"ERROR");
            result.put((Object)RESPONSE_ERROR_MESSAGE, (Object)e.getMessage());
            responseBuilder = Response.serverError();
        }
        return responseBuilder.entity((Object)this.streamingOutput(result)).build();
    }

    @Path(value="/movetoarchiveserver")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response moveToArchiveServer(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="bearerTokenForReplicaSetToArchive") String bearerTokenOrNullForApplicationReplicaSetToArchive, @FormParam(value="bearerTokenForArchive") String bearerTokenOrNullForArchive, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="durationToWaitBeforeCompareServersInMilliseconds") @DefaultValue(value="300000") long durationToWaitBeforeCompareServersInMillis, @FormParam(value="maxNumberOfCompareserverAttempts") @DefaultValue(value="5") int maxNumberOfCompareServerAttempts, @FormParam(value="removeApplicationReplicaSet") @DefaultValue(value="true") boolean removeApplicationReplicaSet, @FormParam(value="mongoUriToArchiveDbTo") String mongoUriToArchiveDbTo) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        if (removeApplicationReplicaSet) {
            this.getSecurityService().checkCurrentUserDeletePermission(SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{replicaSetName})));
        }
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        AwsLandscape landscape = this.getLandscapeService().getLandscape();
        MongoUriParser mongoUriParser = new MongoUriParser(landscape, (Region)region);
        try {
            MongoEndpoint moveDatabaseHere = mongoUriToArchiveDbTo == null ? null : mongoUriParser.parseMongoUri(mongoUriToArchiveDbTo).getEndpoint();
            AwsApplicationReplicaSet applicationReplicaSetToArchive = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (applicationReplicaSetToArchive == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                Util.Triple mdiProgressAndCompareServersResult = this.getLandscapeService().archiveReplicaSet(regionId, applicationReplicaSetToArchive, bearerTokenOrNullForApplicationReplicaSetToArchive, bearerTokenOrNullForArchive, Duration.ofMillis((long)durationToWaitBeforeCompareServersInMillis), maxNumberOfCompareServerAttempts, removeApplicationReplicaSet, moveDatabaseHere, optionalKeyName, passphraseForPrivateKeyDecryption);
                JSONObject result = new JSONObject();
                result.put((Object)MDI_PROGRESS, mdiProgressAndCompareServersResult.getA() == null ? null : new DataImportProgressJsonSerializer().serialize((DataImportProgress)mdiProgressAndCompareServersResult.getA()));
                result.put((Object)COMPARE_SERVERS_RESULT, mdiProgressAndCompareServersResult.getB() == null ? null : new CompareServersResultJsonSerializer().serialize((CompareServersResult)mdiProgressAndCompareServersResult.getB()));
                result.put((Object)ARCHIVE_MONGODB_RESULT, mdiProgressAndCompareServersResult.getC());
                response = Response.ok((Object)this.streamingOutput(result)).build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/moveallapplicationprocessesawayfrom")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response moveAllApplicationProcessesAwayFrom(@FormParam(value="regionId") String regionId, @FormParam(value="instanceId") String fromInstanceWithId, @FormParam(value="instanceType") String optionalInstanceType, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        try {
            AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
            SailingAnalyticsHost fromHost = (SailingAnalyticsHost)this.getLandscapeService().getLandscape().getHostByInstanceId((Region)region, fromInstanceWithId, (HostSupplier)new SailingAnalyticsHostSupplier());
            byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
            Util.Triple result = this.getLandscapeService().moveAllApplicationProcessesAwayFrom(fromHost, Optional.ofNullable(optionalInstanceType == null ? null : InstanceType.valueOf((String)optionalInstanceType)), optionalKeyName, passphraseForPrivateKeyDecryption);
            JSONObject jsonResult = new JSONObject();
            jsonResult.put((Object)NEW_HOST_ID, (Object)((SailingAnalyticsHost)result.getA()).getId());
            JSONArray masterProcessesMoved = this.getProcessesAndTheirReplicaSetNamesAsJSONArray((Map)result.getB());
            jsonResult.put((Object)MASTER_PROCESSES_MOVED, (Object)masterProcessesMoved);
            JSONArray replicaProcessesMoved = this.getProcessesAndTheirReplicaSetNamesAsJSONArray((Map)result.getC());
            jsonResult.put((Object)REPLICA_PROCESSES_MOVED, (Object)replicaProcessesMoved);
            response = Response.ok((Object)this.streamingOutput(jsonResult)).build();
        }
        catch (Exception e) {
            String msg = "Error trying to move processes away from instance with ID " + fromInstanceWithId + " in region " + regionId + ": " + e.getMessage();
            logger.log(Level.SEVERE, msg, e);
            response = this.badRequest(msg);
        }
        return response;
    }

    private JSONArray getProcessesAndTheirReplicaSetNamesAsJSONArray(Map<String, SailingAnalyticsProcess<String>> processesKeyedByTheirApplicationReplicaSetName) {
        JSONArray result = new JSONArray();
        for (Map.Entry<String, SailingAnalyticsProcess<String>> e : processesKeyedByTheirApplicationReplicaSetName.entrySet()) {
            JSONObject processJson = new JSONObject();
            processJson.put((Object)"replicaSetName", (Object)e.getKey());
            processJson.put((Object)PORT, (Object)e.getValue().getPort());
        }
        return result;
    }

    @Path(value="/removeapplicationreplicaset")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response removeApplicationReplicaSet(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="mongoUriToArchiveDbTo") String mongoUriToArchiveDbTo) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        this.getSecurityService().checkCurrentUserDeletePermission(SecuredSecurityTypes.SERVER.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{replicaSetName})));
        AwsLandscape landscape = this.getLandscapeService().getLandscape();
        AwsRegion region = new AwsRegion(regionId, landscape);
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet applicationReplicaSetToRemove = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (applicationReplicaSetToRemove == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                MongoUriParser mongoUriParser = new MongoUriParser(landscape, (Region)region);
                MongoEndpoint moveDatabaseHere = mongoUriToArchiveDbTo == null ? null : mongoUriParser.parseMongoUri(mongoUriToArchiveDbTo).getEndpoint();
                this.getLandscapeService().removeApplicationReplicaSet(regionId, applicationReplicaSetToRemove, moveDatabaseHere, optionalKeyName, passphraseForPrivateKeyDecryption);
                response = Response.ok().build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/deployreplicatoexistinghost")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response deployReplicaToExistingHost(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="hostId") String hostId, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="replicaReplicationBearerToken") String replicaReplicationBearerToken, @FormParam(value="memoryInMegabytes") Integer optionalMemoryInMegabytesOrNull, @FormParam(value="memoryTotalSizeFactor") Integer optionalMemoryTotalSizeFactorOrNull, @FormParam(value="igtimiRiotPort") Integer optionalIgtimiRiotPort) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                SailingAnalyticsHost hostToDeployTo;
                LandscapeService landscapeService = this.getLandscapeService();
                if (landscapeService.isEligibleForDeployment(hostToDeployTo = (SailingAnalyticsHost)landscapeService.getLandscape().getHostByInstanceId((Region)region, hostId, (HostSupplier)new SailingAnalyticsHostSupplier()), replicaSet.getServerName(), replicaSet.getPort(), optionalIgtimiRiotPort, optionalTimeoutInMilliseconds == null ? Optional.empty() : Optional.of(Duration.ofMillis((long)optionalTimeoutInMilliseconds)), optionalKeyName, passphraseForPrivateKeyDecryption)) {
                    SailingAnalyticsProcess process = this.getLandscapeService().deployReplicaToExistingHost(replicaSet, hostToDeployTo, optionalKeyName, passphraseForPrivateKeyDecryption, replicaReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, optionalIgtimiRiotPort);
                    response = Response.ok().entity((Object)this.streamingOutput(new AwsApplicationProcessJsonSerializer().serialize(process))).build();
                } else {
                    response = this.badRequest("Host " + hostToDeployTo + " is not eligible for deploying a process of application replica set " + replicaSetName + ". Check port and directory.");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/gethostseligibleforreplicasetprocessdeployment")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getHostsEligibleForReplicaSetProcessDeployment(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                JSONArray result = new JSONArray();
                for (SailingAnalyticsHost host : this.getLandscapeService().getEligibleSharedHostsForReplicaSet(region, replicaSet, optionalKeyName, passphraseForPrivateKeyDecryption)) {
                    result.add((Object)new HostJsonSerializer().serialize(host));
                }
                response = Response.ok().entity((Object)this.streamingOutput(result)).build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/usededicatedautoscalingreplicasinsteadofshared")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response useDedicatedAutoScalingReplicasInsteadOfShared(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                AwsApplicationReplicaSet result = this.getLandscapeService().useDedicatedAutoScalingReplicasInsteadOfShared(replicaSet, optionalKeyName, passphraseForPrivateKeyDecryption);
                response = Response.ok().entity((Object)this.streamingOutput(new AwsApplicationReplicaSetJsonSerializer(result.getVersion(optionalTimeoutInMilliseconds == null ? Landscape.WAIT_FOR_PROCESS_TIMEOUT : Optional.of(Duration.ofMillis((long)optionalTimeoutInMilliseconds)), Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption).getName()).serialize((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)result))).build();
            }
        }
        catch (Exception e) {
            String message = "Error trying to use dedicated auto-scaling replicas only for replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage();
            logger.log(Level.SEVERE, message, e);
            response = this.badRequest(message);
        }
        return response;
    }

    @Path(value="/usesinglesharedinsteadofdedicatedautoscalingreplica")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response useSingleSharedInsteadOfDedicatedAutoScalingReplica(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="sharedInstanceType") String sharedInstanceTypeOrNull, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="replicaReplicationBearerToken") String replicaReplicationBearerToken, @FormParam(value="memoryInMegabytes") Integer optionalMemoryInMegabytesOrNull, @FormParam(value="memoryTotalSizeFactor") Integer optionalMemoryTotalSizeFactorOrNull) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                AwsApplicationReplicaSet result = this.getLandscapeService().useSingleSharedInsteadOfDedicatedAutoScalingReplica(replicaSet, optionalKeyName, passphraseForPrivateKeyDecryption, replicaReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull, Optional.ofNullable(sharedInstanceTypeOrNull).map(sharedInstanceTypeName -> InstanceType.valueOf((String)sharedInstanceTypeName)));
                response = Response.ok().entity((Object)this.streamingOutput(new AwsApplicationReplicaSetJsonSerializer(result.getVersion(optionalTimeoutInMilliseconds == null ? Landscape.WAIT_FOR_PROCESS_TIMEOUT : Optional.of(Duration.ofMillis((long)optionalTimeoutInMilliseconds)), Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption).getName()).serialize((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)result))).build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/movemastertootherinstance")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response moveMasterToOtherInstance(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="sharedMasterInstance") @DefaultValue(value="false") Boolean useSharedInstance, @FormParam(value="timeoutInMilliseconds") Long optionalTimeoutInMilliseconds, @FormParam(value="instanceType") String optionalInstanceType, @FormParam(value="hostId") String optionalIdOfHostToDeployTo, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="masterReplicationBearerToken") String masterReplicationBearerToken, @FormParam(value="replicaReplicationBearerToken") String replicaReplicationBearerToken, @FormParam(value="memoryInMegabytes") Integer optionalMemoryInMegabytesOrNull, @FormParam(value="memoryTotalSizeFactor") Integer optionalMemoryTotalSizeFactorOrNull) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, optionalTimeoutInMilliseconds, optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                Optional<SailingAnalyticsHost> optionalPreferredInstanceToDeployTo = Optional.ofNullable(optionalIdOfHostToDeployTo).map(instanceId -> (SailingAnalyticsHost)this.getLandscapeService().getLandscape().getHostByInstanceId((Region)region, instanceId, (HostSupplier)new SailingAnalyticsHostSupplier()));
                AwsApplicationReplicaSet result = this.getLandscapeService().moveMasterToOtherInstance(replicaSet, useSharedInstance.booleanValue(), Optional.ofNullable(optionalInstanceType).map(instanceTypeName -> InstanceType.valueOf((String)instanceTypeName)), optionalPreferredInstanceToDeployTo, optionalKeyName, passphraseForPrivateKeyDecryption, masterReplicationBearerToken, replicaReplicationBearerToken, optionalMemoryInMegabytesOrNull, optionalMemoryTotalSizeFactorOrNull);
                response = Response.ok().entity((Object)this.streamingOutput(new AwsApplicationReplicaSetJsonSerializer(result.getVersion(optionalTimeoutInMilliseconds == null ? Landscape.WAIT_FOR_PROCESS_TIMEOUT : Optional.of(Duration.ofMillis((long)optionalTimeoutInMilliseconds)), Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption).getName()).serialize((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)result))).build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }

    @Path(value="/changeautoscalingreplicasinstancetype")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response changeAutoScalingReplicasInstanceType(@FormParam(value="regionId") String regionId, @FormParam(value="replicaSetName") String replicaSetName, @FormParam(value="keyName") String optionalKeyName, @FormParam(value="privateKeyEncryptionPassphrase") String privateKeyEncryptionPassphrase, @FormParam(value="instanceType") String instanceType) {
        Response response;
        this.checkLandscapeManageAwsPermission();
        AwsRegion region = new AwsRegion(regionId, this.getLandscapeService().getLandscape());
        byte[] passphraseForPrivateKeyDecryption = privateKeyEncryptionPassphrase == null ? null : privateKeyEncryptionPassphrase.getBytes();
        try {
            AwsApplicationReplicaSet replicaSet = this.getLandscapeService().getApplicationReplicaSet(region, replicaSetName, Long.valueOf(((Duration)Landscape.WAIT_FOR_PROCESS_TIMEOUT.get()).asMillis()), optionalKeyName, passphraseForPrivateKeyDecryption);
            if (replicaSet == null) {
                response = this.badRequest("Application replica set with name " + replicaSetName + " not found in region " + regionId);
            } else {
                AwsApplicationReplicaSet result = this.getLandscapeService().changeAutoScalingReplicasInstanceType(replicaSet, InstanceType.valueOf((String)instanceType), Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption);
                response = Response.ok().entity((Object)this.streamingOutput(new AwsApplicationReplicaSetJsonSerializer(result.getVersion(Landscape.WAIT_FOR_PROCESS_TIMEOUT, Optional.ofNullable(optionalKeyName), passphraseForPrivateKeyDecryption).getName()).serialize((AwsApplicationReplicaSet<String, SailingAnalyticsMetrics, SailingAnalyticsProcess<String>>)result))).build();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage(), e);
            response = this.badRequest("Error trying to archive replica set " + replicaSetName + " in region " + regionId + ": " + e.getMessage());
        }
        return response;
    }
}

