/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Boat;
import com.sap.sailing.kiworesultimport.BoatResultInRace;
import com.sap.sailing.kiworesultimport.RaceSummary;
import com.sap.sailing.kiworesultimport.RegattaSummary;
import com.sap.sailing.kiworesultimport.ResultList;
import com.sap.sailing.kiworesultimport.Start;
import com.sap.sailing.kiworesultimport.StartReport;
import com.sap.sailing.kiworesultimport.ZipFile;
import com.sap.sailing.kiworesultimport.impl.RaceSummaryImpl;
import com.sap.sailing.kiworesultimport.impl.RegattaSummaryImpl;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ZipFileImpl
implements ZipFile {
    private final Iterable<StartReport> startReports;
    private final Map<Util.Triple<String, Integer, String>, Start> startsByBoatclassAndRaceNumberAndFleetName;
    private final Iterable<ResultList> resultLists;
    private final Map<String, RegattaSummary> regattaSummaryByBoatClass = new HashMap<String, RegattaSummary>();

    public ZipFileImpl(Iterable<StartReport> startReports, Iterable<ResultList> resultLists) {
        HashMap<String, ResultList> latestResultListForBoatClass = new HashMap<String, ResultList>();
        HashMap fleetNamesPerBoatClassAndRaceNumber = new HashMap();
        this.startReports = startReports;
        this.startsByBoatclassAndRaceNumberAndFleetName = new HashMap<Util.Triple<String, Integer, String>, Start>();
        this.resultLists = resultLists;
        for (StartReport startReport : startReports) {
            for (Start start : startReport.getStarts()) {
                HashSet<String> fleetsForTheBoatClassAndRace;
                this.startsByBoatclassAndRaceNumberAndFleetName.put((Util.Triple<String, Integer, String>)new Util.Triple((Object)start.getBoatClass(), (Object)start.getRaceNumber(), (Object)start.getFleetName()), start);
                HashMap<Integer, HashSet<String>> fleetsForBoatClass = (HashMap<Integer, HashSet<String>>)fleetNamesPerBoatClassAndRaceNumber.get(start.getBoatClass());
                if (fleetsForBoatClass == null) {
                    fleetsForBoatClass = new HashMap<Integer, HashSet<String>>();
                    fleetNamesPerBoatClassAndRaceNumber.put(start.getBoatClass(), fleetsForBoatClass);
                }
                if ((fleetsForTheBoatClassAndRace = (HashSet<String>)fleetsForBoatClass.get(start.getRaceNumber())) == null) {
                    fleetsForTheBoatClassAndRace = new HashSet<String>();
                    fleetsForBoatClass.put(start.getRaceNumber(), fleetsForTheBoatClassAndRace);
                }
                fleetsForTheBoatClassAndRace.add(start.getFleetName());
            }
        }
        for (ResultList resultList : resultLists) {
            ResultList latestSoFar = (ResultList)latestResultListForBoatClass.get(resultList.getBoatClassName());
            if (latestSoFar != null && latestSoFar.getTimePointPublished().compareTo((Object)resultList.getTimePointPublished()) >= 0) continue;
            latestResultListForBoatClass.put(resultList.getBoatClassName(), resultList);
        }
        for (Map.Entry entry : latestResultListForBoatClass.entrySet()) {
            ResultList resultList = (ResultList)entry.getValue();
            ArrayList<RaceSummary> raceSummaries = new ArrayList<RaceSummary>();
            for (Integer raceNumber : resultList.getRaceNumbers()) {
                HashMap<Boat, BoatResultInRace> resultsPerBoat = new HashMap<Boat, BoatResultInRace>();
                for (Boat boat : resultList.getBoats()) {
                    resultsPerBoat.put(boat, boat.getResultsInRace(raceNumber));
                }
                raceSummaries.add(new RaceSummaryImpl((String)entry.getKey(), resultsPerBoat, (Iterable)((Map)fleetNamesPerBoatClassAndRaceNumber.get(entry.getKey())).get(raceNumber), raceNumber));
            }
            RegattaSummaryImpl regattaSummary = new RegattaSummaryImpl(((ResultList)entry.getValue()).getEvent(), raceSummaries, (String)entry.getKey(), resultList.getBoats(), resultList.getTimePointPublished());
            this.regattaSummaryByBoatClass.put(regattaSummary.getBoatClassName(), regattaSummary);
        }
    }

    @Override
    public Iterable<StartReport> getStartReports() {
        return this.startReports;
    }

    @Override
    public Iterable<ResultList> getResultLists() {
        return this.resultLists;
    }

    @Override
    public RegattaSummary getRegattaSummary(String boatClassName) {
        return this.regattaSummaryByBoatClass.get(boatClassName);
    }

    @Override
    public Iterable<String> getBoatClassNames() {
        return this.regattaSummaryByBoatClass.keySet();
    }

    @Override
    public Iterable<RegattaSummary> getRegattaSummaries() {
        return this.regattaSummaryByBoatClass.values();
    }
}

