/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.declination.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.TimePoint;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class DeclinationImporter {
    private static final Logger logger = Logger.getLogger(DeclinationImporter.class.getName());

    public abstract Declination importRecord(Position var1, TimePoint var2) throws IOException, ParserConfigurationException, SAXException;

    public Declination getDeclination(Position position, TimePoint timePoint, long timeoutForOnlineFetchInMilliseconds) throws IOException, ParseException {
        ScheduledExecutorService executorService = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor(1, "DeclinationImporterThreadPoolExecutor");
        try {
            return executorService.submit(() -> this.importRecord(position, timePoint)).get(timeoutForOnlineFetchInMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            logger.log(Level.INFO, "Timeout while getting declination.", e);
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, "InterruptedException while getting declination", e);
        }
        catch (ExecutionException e) {
            logger.log(Level.INFO, "Exception while trying to load magnetic declination online", e);
        }
        return null;
    }
}

