/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.server.gateway.serialization.impl.AbstractTrackedRaceDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorAndBoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.SingleCalculationPerSubjectCache;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MarkPassingsJsonSerializer
extends AbstractTrackedRaceDataJsonSerializer {
    public static final String ZERO_BASED_WAYPOINT_INDEX = "zeroBasedWaypointIndex";
    public static final String WAYPOINT_NAME = "waypointName";
    public static final String BYWAYPOINT = "bywaypoint";
    public static final String MARKPASSINGS = "markpassings";
    public static final String TRACKED_RANK_AT_MARK_PASSING = "trackedRankAtMarkPassing";
    public static final String ONE_BASED_PASSING_ORDER = "oneBasedPassingOrder";
    public static final String POINTS_BASED_ON_PASSING_ORDER = "pointsBasedOnPassingOrder";
    public static final String NET_POINTS_BASED_ON_PASSING_ORDER = "netPointsBasedOnPassingOrder";
    public static final String MAX_POINTS_REASON = "maxPointsReason";
    private static SimpleDateFormat TIMEPOINT_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static SingleCalculationPerSubjectCache<Util.Pair<Leaderboard, TrackedRace>, JSONObject> ongoingLiveCalculationsByRaceAndRequestingUsername = new SingleCalculationPerSubjectCache(MarkPassingsJsonSerializer::serializeForLiveTimePointToJSON, Duration.ONE_MINUTE.times(10L));
    private final TimePoint timePoint;
    private final Leaderboard leaderboard;

    public MarkPassingsJsonSerializer(Leaderboard leaderboard, TimePoint timePoint) {
        this.leaderboard = leaderboard;
        this.timePoint = timePoint;
    }

    public JSONObject serialize(TrackedRace trackedRace) {
        JSONObject result = this.timePoint == null ? (JSONObject)ongoingLiveCalculationsByRaceAndRequestingUsername.get((Object)new Util.Pair((Object)this.leaderboard, (Object)trackedRace)) : MarkPassingsJsonSerializer.serializeToJSON(this.leaderboard, trackedRace, this.timePoint);
        return result;
    }

    private static JSONObject serializeForLiveTimePointToJSON(Util.Pair<Leaderboard, TrackedRace> leaderboardAndTrackedRace) {
        TimePoint timePointForRanksAtMarks = MillisecondsTimePoint.now().minus(((TrackedRace)leaderboardAndTrackedRace.getB()).getDelayToLiveInMillis());
        return MarkPassingsJsonSerializer.serializeToJSON((Leaderboard)leaderboardAndTrackedRace.getA(), (TrackedRace)leaderboardAndTrackedRace.getB(), timePointForRanksAtMarks);
    }

    private static JSONObject serializeToJSON(Leaderboard leaderboard, TrackedRace trackedRace, TimePoint timePoint) {
        Course course = trackedRace.getRace().getCourse();
        TimePoint timePointForRanksAtMarks = timePoint != null ? timePoint : MillisecondsTimePoint.now().minus(trackedRace.getDelayToLiveInMillis());
        JSONObject result = new JSONObject();
        CompetitorAndBoatJsonSerializer competitorWithBoatSerializer = CompetitorAndBoatJsonSerializer.create((boolean)false);
        CompetitorJsonSerializer competitorSerializer = CompetitorJsonSerializer.create();
        JSONArray byCompetitorJson = new JSONArray();
        result.put((Object)"bycompetitor", (Object)byCompetitorJson);
        HashMap orderOfMarkPassings = new HashMap();
        trackedRace.getRace().getCourse().lockForRead();
        try {
            for (Waypoint waypoint : course.getWaypoints()) {
                Iterable markPassingsInOrder = trackedRace.getMarkPassingsInOrder(waypoint);
                trackedRace.lockForRead(markPassingsInOrder);
                try {
                    int markPassingCounter = 1;
                    for (MarkPassing markPassing : markPassingsInOrder) {
                        orderOfMarkPassings.computeIfAbsent(waypoint, wp -> new HashMap()).put(markPassing.getCompetitor(), markPassingCounter++);
                    }
                }
                finally {
                    trackedRace.unlockAfterRead(markPassingsInOrder);
                }
            }
        }
        finally {
            trackedRace.getRace().getCourse().unlockAfterRead();
        }
        HashMap<TrackedLeg, LinkedHashMap> legRanks = new HashMap<TrackedLeg, LinkedHashMap>();
        LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(timePointForRanksAtMarks);
        for (Map.Entry competitorAndBoatEntry : trackedRace.getRace().getCompetitorsAndTheirBoats().entrySet()) {
            Competitor competitor = (Competitor)competitorAndBoatEntry.getKey();
            Boat boat = (Boat)competitorAndBoatEntry.getValue();
            JSONObject forCompetitorJson = new JSONObject();
            byCompetitorJson.add((Object)forCompetitorJson);
            forCompetitorJson.put((Object)"competitor", (Object)competitorWithBoatSerializer.serialize(new Util.Pair((Object)competitor, (Object)boat)));
            NavigableSet markPassingsForCompetitor = trackedRace.getMarkPassings(competitor);
            JSONArray markPassingsForCompetitorJson = new JSONArray();
            forCompetitorJson.put((Object)MARKPASSINGS, (Object)markPassingsForCompetitorJson);
            boolean leaderboardValidAndSubjectMaySeePremiumInformation = leaderboard != null && SecurityUtils.getSubject().isPermitted(SecuredDomainType.LEADERBOARD.getStringPermissionForObject((HasPermissions.Action)SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, (WithQualifiedObjectIdentifier)leaderboard));
            trackedRace.lockForRead((Iterable)markPassingsForCompetitor);
            try {
                for (MarkPassing markPassing : markPassingsForCompetitor) {
                    Util.Pair raceColumnAndFleet;
                    Integer rank;
                    JSONObject markPassingJson = new JSONObject();
                    markPassingsForCompetitorJson.add((Object)markPassingJson);
                    MarkPassingsJsonSerializer.addWaypoint(course, markPassing.getWaypoint(), markPassingJson);
                    MarkPassingsJsonSerializer.addMarkPassingTime(markPassing, markPassingJson);
                    int zeroBasedIndexOfWaypoint = course.getIndexOfWaypoint(markPassing.getWaypoint());
                    Integer passingOrder = orderOfMarkPassings.getOrDefault(markPassing.getWaypoint(), Collections.emptyMap()).getOrDefault(competitor, 0);
                    if (zeroBasedIndexOfWaypoint == 0) {
                        rank = passingOrder;
                    } else {
                        TrackedLeg trackedLeg = trackedRace.getTrackedLeg(course.getLeg(zeroBasedIndexOfWaypoint - 1));
                        rank = (Integer)legRanks.computeIfAbsent(trackedLeg, arg_0 -> MarkPassingsJsonSerializer.lambda$2(timePointForRanksAtMarks, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache, arg_0)).get(competitor);
                    }
                    markPassingJson.put((Object)TRACKED_RANK_AT_MARK_PASSING, (Object)rank);
                    markPassingJson.put((Object)ONE_BASED_PASSING_ORDER, (Object)passingOrder);
                    if (!leaderboardValidAndSubjectMaySeePremiumInformation || (raceColumnAndFleet = leaderboard.getRaceColumnAndFleet(trackedRace)) == null) continue;
                    Double totalPoints = leaderboard.getScoreCorrection().getCorrectedScore(() -> passingOrder, competitor, (RaceColumn)raceColumnAndFleet.getA(), leaderboard, markPassing.getTimePoint(), leaderboard.getNumberOfCompetitorsInLeaderboardFetcher(), leaderboard.getScoringScheme(), (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache).getCorrectedScore();
                    Function<RaceColumn, Double> totalPointsSupplier = raceColumn -> {
                        Double totalPointsForRaceColumn = raceColumn == raceColumnAndFleet.getA() ? totalPoints : leaderboard.getTotalPoints(competitor, raceColumn, markPassing.getTimePoint());
                        return totalPointsForRaceColumn;
                    };
                    Set discardedRaceColumns = leaderboard.getResultDiscardingRule().getDiscardedRaceColumns(competitor, leaderboard, leaderboard.getRaceColumns(), markPassing.getTimePoint(), leaderboard.getScoringScheme(), totalPointsSupplier, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache);
                    Double netPoints = leaderboard.getNetPoints(competitor, (RaceColumn)raceColumnAndFleet.getA(), markPassing.getTimePoint(), discardedRaceColumns, () -> totalPoints);
                    markPassingJson.put((Object)POINTS_BASED_ON_PASSING_ORDER, (Object)totalPoints);
                    markPassingJson.put((Object)NET_POINTS_BASED_ON_PASSING_ORDER, (Object)netPoints);
                    markPassingJson.put((Object)MAX_POINTS_REASON, (Object)leaderboard.getMaxPointsReason(competitor, (RaceColumn)raceColumnAndFleet.getA(), markPassing.getTimePoint()));
                }
            }
            finally {
                trackedRace.unlockAfterRead((Iterable)markPassingsForCompetitor);
            }
        }
        JSONArray byWaypointJson = new JSONArray();
        result.put((Object)BYWAYPOINT, (Object)byWaypointJson);
        for (Waypoint waypoint : course.getWaypoints()) {
            JSONObject jsonForWaypoint = new JSONObject();
            byWaypointJson.add((Object)jsonForWaypoint);
            MarkPassingsJsonSerializer.addWaypoint(course, waypoint, jsonForWaypoint);
            Iterable markPassingsForWaypoint = trackedRace.getMarkPassingsInOrder(waypoint);
            trackedRace.lockForRead(markPassingsForWaypoint);
            try {
                JSONArray markPassingsForWaypointJson = new JSONArray();
                jsonForWaypoint.put((Object)MARKPASSINGS, (Object)markPassingsForWaypointJson);
                for (MarkPassing markPassing : markPassingsForWaypoint) {
                    JSONObject markPassingJson = new JSONObject();
                    markPassingsForWaypointJson.add((Object)markPassingJson);
                    markPassingJson.put((Object)"competitor", (Object)competitorSerializer.serialize(markPassing.getCompetitor()));
                    MarkPassingsJsonSerializer.addMarkPassingTime(markPassing, markPassingJson);
                }
            }
            finally {
                trackedRace.unlockAfterRead(markPassingsForWaypoint);
            }
        }
        return result;
    }

    private static void addMarkPassingTime(MarkPassing markPassing, JSONObject markPassingJson) {
        markPassingJson.put((Object)"timeasmillis", (Object)markPassing.getTimePoint().asMillis());
        markPassingJson.put((Object)"timeasiso", (Object)TIMEPOINT_FORMATTER.format(markPassing.getTimePoint().asDate()));
    }

    private static void addWaypoint(Course course, Waypoint waypoint, JSONObject jsonToAddTo) {
        jsonToAddTo.put((Object)WAYPOINT_NAME, (Object)waypoint.getName());
        jsonToAddTo.put((Object)ZERO_BASED_WAYPOINT_INDEX, (Object)course.getIndexOfWaypoint(waypoint));
    }

    private static /* synthetic */ LinkedHashMap lambda$2(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache windLegTypeAndLegBearingAndORCPerformanceCurveCache, TrackedLeg tl) {
        return tl.getRanks(timePoint, windLegTypeAndLegBearingAndORCPerformanceCurveCache);
    }
}

