/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactGPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.CompactPositionHelper;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VeryCompactGPSFixImpl
extends AbstractCompactGPSFixImpl {
    private static final long serialVersionUID = 3943572107870245437L;
    private static final Logger logger = Logger.getLogger(VeryCompactGPSFixImpl.class.getName());
    private final int latDegScaled;
    private final int lngDegScaled;
    private short cachedEstimatedSpeedBearingInDegreesScaled;
    private short cachedEstimatedSpeedInKnotsScaled;

    public VeryCompactGPSFixImpl(Position position, TimePoint timePoint) {
        super(timePoint);
        this.latDegScaled = CompactPositionHelper.getLatDegScaled(position);
        this.lngDegScaled = CompactPositionHelper.getLngDegScaled(position);
    }

    public VeryCompactGPSFixImpl(GPSFix gpsFix) {
        this(gpsFix.getPosition(), gpsFix.getTimePoint());
    }

    @Override
    public Position getPosition() {
        return new CompactPosition();
    }

    @Override
    public SpeedWithBearing getCachedEstimatedSpeed() {
        assert (this.isEstimatedSpeedCached());
        return new VeryCompactEstimatedSpeed();
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        try {
            this.cachedEstimatedSpeedInKnotsScaled = CompactPositionHelper.getKnotSpeedScaled(estimatedSpeed);
            this.cachedEstimatedSpeedBearingInDegreesScaled = CompactPositionHelper.getDegreeBearingScaled(estimatedSpeed.getBearing());
            super.cacheEstimatedSpeed(estimatedSpeed);
        }
        catch (CompactionNotPossibleException e) {
            logger.log(Level.FINER, "Cannot cache estimated speed " + estimatedSpeed + " in compact fix:", e);
        }
    }

    public class CompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return CompactPositionHelper.getLatDeg(VeryCompactGPSFixImpl.this.latDegScaled);
        }

        @Override
        public double getLngDeg() {
            return CompactPositionHelper.getLngDeg(VeryCompactGPSFixImpl.this.lngDegScaled);
        }
    }

    private class VeryCompactEstimatedSpeed
    extends AbstractSpeedWithAbstractBearingImpl {
        private static final long serialVersionUID = -5871855443391817248L;

        private VeryCompactEstimatedSpeed() {
        }

        @Override
        public Bearing getBearing() {
            return new VeryCompactEstimatedSpeedBearing();
        }

        @Override
        public double getKnots() {
            return CompactPositionHelper.getKnotSpeed(VeryCompactGPSFixImpl.this.cachedEstimatedSpeedInKnotsScaled);
        }
    }

    private class VeryCompactEstimatedSpeedBearing
    extends AbstractBearing {
        private static final long serialVersionUID = 8549231429037883121L;

        private VeryCompactEstimatedSpeedBearing() {
        }

        public double getDegrees() {
            return CompactPositionHelper.getDegreeBearing(VeryCompactGPSFixImpl.this.cachedEstimatedSpeedBearingInDegreesScaled);
        }
    }
}

