/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.racelog;

public enum RaceLogRaceStatus {
    UNKNOWN(0),
    UNSCHEDULED(1),
    PRESCHEDULED(2),
    SCHEDULED(3),
    STARTPHASE(4),
    RUNNING(5),
    FINISHING(6),
    FINISHED(7);

    private int orderNumber;

    private RaceLogRaceStatus(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public boolean isAbortingFlagFromPreviousPassValid() {
        return this == UNSCHEDULED || this == PRESCHEDULED;
    }

    public static boolean isPreRunning(RaceLogRaceStatus status) {
        return status != null && (status.equals((Object)SCHEDULED) || status.equals((Object)STARTPHASE));
    }

    public static boolean isActive(RaceLogRaceStatus status) {
        return status != null && (status.equals((Object)PRESCHEDULED) || status.equals((Object)SCHEDULED) || status.equals((Object)STARTPHASE) || status.equals((Object)RUNNING) || status.equals((Object)FINISHING));
    }

    public static boolean isRunningOrFinished(RaceLogRaceStatus status) {
        return status != null && (status.equals((Object)STARTPHASE) || status.equals((Object)RUNNING) || status.equals((Object)FINISHING) || status.equals((Object)FINISHED));
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }
}

