/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.ColorMap;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.HSVColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ColorMapImpl<T>
implements ColorMap<T> {
    private final HashMap<T, Color> idColor;
    private int colorCounter;
    private HSVColor[] baseColors = this.insertBaseColors();
    private static final double MIN_COLOR_DISTANCE = 0.5;
    private static final float STEP = 0.1f;
    private static int stepsMade = 0;
    private static int mode = 0;
    private static int factor = 0;
    private List<HSVColor> blockedColors;

    public ColorMapImpl(Color ... initialBlockedColors) {
        this.idColor = new HashMap();
        this.blockedColors = new ArrayList<HSVColor>();
        Color[] colorArray = initialBlockedColors;
        int n = initialBlockedColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color initialBlockedColor = colorArray[n2];
            this.blockedColors.add(ColorMapImpl.convertFromColorToHSV(initialBlockedColor));
            ++n2;
        }
    }

    private HSVColor[] insertBaseColors() {
        HSVColor[] result = new HSVColor[]{new HSVColor(0.0f, 1.0f, 1.0f), new HSVColor(30.0f, 1.0f, 1.0f), new HSVColor(45.0f, 1.0f, 1.0f), new HSVColor(120.0f, 1.0f, 1.0f), new HSVColor(160.0f, 1.0f, 1.0f), new HSVColor(190.0f, 1.0f, 1.0f), new HSVColor(240.0f, 1.0f, 1.0f), new HSVColor(270.0f, 1.0f, 1.0f), new HSVColor(285.0f, 1.0f, 1.0f), new HSVColor(300.0f, 1.0f, 1.0f), new HSVColor(330.0f, 1.0f, 1.0f)};
        return result;
    }

    @Override
    public Color getColorByID(T object) {
        Color result;
        Color color = this.idColor.get(object);
        if (color == null) {
            HSVColor newColor;
            while (this.isContainColor(this.blockedColors, newColor = this.generateColor(this.colorCounter++))) {
            }
            this.idColor.put(object, (Color)newColor);
            result = newColor;
        } else {
            result = color;
        }
        return result;
    }

    private boolean isColorsClose(HSVColor blockedColor, HSVColor newColor) {
        double distanceBrightness;
        double distanceSaturation;
        double distanceHue = Math.abs(blockedColor.getHue() - newColor.getHue());
        double distance = Math.sqrt((distanceHue = Math.min(distanceHue, 360.0 - distanceHue) / 180.0) * distanceHue + (distanceSaturation = (double)Math.abs(blockedColor.getSaturation() - newColor.getSaturation())) * distanceSaturation + (distanceBrightness = (double)Math.abs(blockedColor.getBrightness() - newColor.getBrightness())) * distanceBrightness);
        return distance < 0.5;
    }

    private boolean isContainColor(List<HSVColor> colors, HSVColor color) {
        for (HSVColor colorFromColors : colors) {
            if (!this.isColorsClose(colorFromColors, color)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addBlockedColor(Color color) {
        boolean result = color != null && !this.blockedColors.contains(color) ? this.blockedColors.add(ColorMapImpl.convertFromColorToHSV(color)) : false;
        return result;
    }

    @Override
    public boolean removeBlockedColor(Color color) {
        boolean result = false;
        if (color != null) {
            result = this.blockedColors.remove(ColorMapImpl.convertFromColorToHSV(color));
        }
        return result;
    }

    @Override
    public void clearBlockedColors() {
        this.blockedColors.clear();
    }

    private static HSVColor convertFromColorToHSV(Color color) {
        Util.Triple hsvColor = color.getAsHSV();
        return new HSVColor(((Float)hsvColor.getA()).floatValue(), ((Float)hsvColor.getB()).floatValue(), ((Float)hsvColor.getC()).floatValue());
    }

    private HSVColor generateColor(int index) {
        int baseColorsCount = this.baseColors.length;
        int currentColorIndex = index % baseColorsCount;
        float saturationDecrease = 0.1f;
        float brightnessDecrease = 0.1f;
        switch (mode) {
            case 0: {
                saturationDecrease = brightnessDecrease *= (float)stepsMade;
                break;
            }
            case 1: {
                saturationDecrease *= (float)factor;
                brightnessDecrease *= (float)stepsMade;
                break;
            }
            case 2: {
                brightnessDecrease *= (float)factor;
                saturationDecrease *= (float)stepsMade;
                break;
            }
        }
        if ((index + 1) % baseColorsCount == 0) {
            ++factor;
            switch (mode) {
                case 0: {
                    ++stepsMade;
                    mode = 1;
                    factor = 0;
                    break;
                }
                case 1: {
                    if (factor != stepsMade) break;
                    mode = 2;
                    factor = 0;
                    break;
                }
                case 2: {
                    if (factor != stepsMade) break;
                    mode = 0;
                    break;
                }
            }
        }
        HSVColor hsvColor = this.baseColors[currentColorIndex];
        return new HSVColor(hsvColor.getHue(), hsvColor.getSaturation() - saturationDecrease, hsvColor.getBrightness() - brightnessDecrease);
    }
}

