/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;

public class LazyDividedScaledPosition
extends AbstractPosition {
    private static final long serialVersionUID = -4755705843467806809L;
    private final ScalablePosition scalablePosition;
    private final double divisor;
    private Position position;

    public LazyDividedScaledPosition(ScalablePosition scalablePosition, double divisor) {
        this.scalablePosition = scalablePosition;
        this.divisor = divisor;
        this.position = null;
    }

    @Override
    public synchronized double getLatRad() {
        if (this.position == null) {
            this.resolve();
        }
        return this.position.getLatRad();
    }

    @Override
    public synchronized double getLngRad() {
        if (this.position == null) {
            this.resolve();
        }
        return this.position.getLngRad();
    }

    private synchronized void resolve() {
        this.position = this.scalablePosition.divide(this.divisor);
    }
}

