/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Distance;
import java.io.Serializable;
import java.util.Comparator;

public interface Placemark
extends Serializable {
    public String getName();

    public String getCountryCode();

    public Position getPosition();

    public long getPopulation();

    public Distance distanceFrom(Position var1);

    public Distance distanceFrom(double var1, double var3);

    public String getCountryName();

    public static class ByDistance
    implements Comparator<Placemark> {
        private Position position;

        public ByDistance(Position position) {
            this.position = position;
        }

        @Override
        public int compare(Placemark p1, Placemark p2) {
            Distance d1 = p1.distanceFrom(this.position);
            Distance d2 = p2.distanceFrom(this.position);
            return d1.compareTo((Object)d2);
        }
    }

    public static class ByPopulation
    implements Comparator<Placemark> {
        @Override
        public int compare(Placemark p1, Placemark p2) {
            return p1.getPopulation() > p2.getPopulation() ? 1 : (p1.getPopulation() < p2.getPopulation() ? -1 : 0);
        }
    }

    public static class ByPopulationDistanceRatio
    implements Comparator<Placemark> {
        private Position position;
        private double populationFactor = 1.0;
        private double distanceFactor = 1.0;

        public ByPopulationDistanceRatio(Position position) {
            this.position = position;
        }

        @Override
        public int compare(Placemark p1, Placemark p2) {
            double r2;
            double r1 = (double)p1.getPopulation() * this.populationFactor / (p1.distanceFrom(this.position).getKilometers() * this.distanceFactor);
            return r1 > (r2 = (double)p2.getPopulation() * this.populationFactor / (p2.distanceFrom(this.position).getKilometers() * this.distanceFactor)) ? 1 : (r1 < r2 ? -1 : 0);
        }
    }
}

