/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingI18n;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingInvitationMailBuilder;
import com.sap.sse.qrcode.QRCodeGenerationUtil;
import java.io.DataInputStream;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class LegacyRaceLogTrackingInvitationMailBuilder
extends RaceLogTrackingInvitationMailBuilder {
    private static final Logger LOG = Logger.getLogger(LegacyRaceLogTrackingInvitationMailBuilder.class.getName());
    private static final String IOS_DEEP_LINK_PREFIX = "comsapsailingtracker://";

    LegacyRaceLogTrackingInvitationMailBuilder(Locale locale) {
        super(locale);
    }

    LegacyRaceLogTrackingInvitationMailBuilder addQrCodeImage(String url) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DataInputStream imageIs = new DataInputStream(QRCodeGenerationUtil.create((String)url, (int)250));){
                byte[] targetArray = new byte[imageIs.available()];
                imageIs.readFully(targetArray);
                this.insertImage(targetArray, "qr", url);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error while generating QR code for invitation mail", e);
        }
        return this;
    }

    LegacyRaceLogTrackingInvitationMailBuilder addOpenInAppTextAndLinks(String targetUrl, String iOSAppUrl, String androidAppUrl) {
        boolean hasAndroidAppUrl;
        boolean hasIOSAppUrl = iOSAppUrl != null && !iOSAppUrl.isEmpty();
        boolean bl = hasAndroidAppUrl = androidAppUrl != null && !androidAppUrl.isEmpty();
        if (hasIOSAppUrl || hasAndroidAppUrl) {
            this.html.append("<p>").append(RaceLogTrackingI18n.alternativelyVisitThisLink(this.locale)).append("</p>");
        }
        this.html.append("<table border=\"0\" cellspacing=\"20px\" cellpadding=\"0px\">");
        this.html.append("<tr>");
        if (hasIOSAppUrl) {
            this.html.append("<td>");
            this.addHtmlLink(IOS_DEEP_LINK_PREFIX + targetUrl, RaceLogTrackingI18n::iOSUsers);
            this.html.append("</td>");
            this.addTextLink(IOS_DEEP_LINK_PREFIX + targetUrl, RaceLogTrackingI18n::iOSUsers);
        }
        if (hasAndroidAppUrl) {
            this.html.append("<td>");
            this.addHtmlLink(targetUrl, RaceLogTrackingI18n::androidUsers);
            this.html.append("</td>");
            this.addTextLink(targetUrl, RaceLogTrackingI18n::androidUsers);
        }
        this.html.append("</tr>");
        this.html.append("</table>");
        return this;
    }

    LegacyRaceLogTrackingInvitationMailBuilder addInstallAppTextAndLinks(String iOSAppUrl, String androidAppUrl) {
        boolean hasAndroidAppUrl;
        boolean hasIOSAppUrl = iOSAppUrl != null && !iOSAppUrl.isEmpty();
        boolean bl = hasAndroidAppUrl = androidAppUrl != null && !androidAppUrl.isEmpty();
        if (hasIOSAppUrl || hasAndroidAppUrl) {
            this.html.append("<p>").append(RaceLogTrackingI18n.appStoreInstallText(this.locale)).append("</p>");
            this.text.append(RaceLogTrackingI18n.appStoreInstallText(this.locale));
            this.text.append("\r\n");
        }
        this.html.append("<table border=\"0\" cellspacing=\"20px\" cellpadding=\"0px\">");
        this.html.append("<tr>");
        if (hasIOSAppUrl) {
            this.html.append("<td>");
            this.addHtmlLink(iOSAppUrl, RaceLogTrackingI18n::appIos);
            this.html.append("</td>");
            this.addTextLink(iOSAppUrl, RaceLogTrackingI18n::appIos);
        }
        if (hasAndroidAppUrl) {
            this.html.append("<td>");
            this.addHtmlLink(androidAppUrl, RaceLogTrackingI18n::appAndroid);
            this.html.append("</td>");
            this.addTextLink(androidAppUrl, RaceLogTrackingI18n::appAndroid);
        }
        this.html.append("</tr>");
        this.html.append("</table>");
        return this;
    }

    @Override
    protected void addIntroductoryText(String appName, String invitee) {
        String introText = RaceLogTrackingI18n.scanQRCodeOrVisitUrlToRegisterAs(this.locale, appName);
        this.html.append("<p>").append(introText).append(" <b>").append(invitee).append("</b></p>");
        this.text.append(introText).append(" ").append(invitee).append("\r\n").append("\r\n");
    }

    private void addHtmlLink(String url, Function<Locale, String> textFactory) {
        String anchor = "<a href=\"" + url + "\" style=\"color:#fff; text-decoration:none;\">";
        this.html.append(anchor);
        this.html.append("<table width=\"100%\" style=\"background-color: #337ab7; color:#fff;\"><tr>");
        this.html.append("<td style=\"padding: 15px; text-align: center; color:#fff;\">");
        this.html.append(anchor);
        this.html.append(textFactory.apply(this.locale));
        this.html.append("</a>");
        this.html.append("</td>");
        this.html.append("</tr></table>");
        this.html.append("</a>");
    }

    @Override
    public RaceLogTrackingInvitationMailBuilder addSailInsightDeeplink(String url, String iosAppUrl, String androidAppUrl) {
        this.addQrCodeImage(url).addOpenInAppTextAndLinks(url, iosAppUrl, androidAppUrl).addInstallAppTextAndLinks(iosAppUrl, androidAppUrl);
        return this;
    }

    @Override
    public RaceLogTrackingInvitationMailBuilder addBuoyPingerDeeplink(String url, String legacyIOSAppUrl, String legacyAndroidAppUrl) {
        this.addQrCodeImage(url).addOpenInAppTextAndLinks(url, legacyIOSAppUrl, legacyAndroidAppUrl).addInstallAppTextAndLinks(legacyIOSAppUrl, legacyAndroidAppUrl);
        return this;
    }
}

