/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FunctionDTO
implements Serializable,
Comparable<FunctionDTO> {
    private static final long serialVersionUID = 4587389541910498505L;
    private final boolean isDimension;
    private final String functionName;
    private final String sourceTypeName;
    private final String returnTypeName;
    private final List<String> parameterTypeNames;
    private final int ordinal;
    private String displayName;
    private transient DisplayNameProvider displayNameProvider;

    public FunctionDTO(boolean isDimension, String functionName, String sourceTypeName, String returnTypeName, List<String> parameterTypeNames, DisplayNameProvider displayNameProvider, int ordinal) {
        this(isDimension, functionName, sourceTypeName, returnTypeName, parameterTypeNames, (String)null, ordinal);
        this.displayNameProvider = displayNameProvider;
    }

    public FunctionDTO(boolean isDimension, String functionName, String sourceTypeName, String returnTypeName, List<String> parameterTypeNames, String displayName, int ordinal) {
        this.isDimension = isDimension;
        this.functionName = functionName;
        this.sourceTypeName = sourceTypeName;
        this.returnTypeName = returnTypeName;
        this.parameterTypeNames = new ArrayList<String>(parameterTypeNames);
        this.displayName = displayName;
        this.ordinal = ordinal;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public List<String> getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getDisplayName() {
        if (this.displayName == null && this.displayNameProvider != null) {
            this.displayName = this.displayNameProvider.getDisplayName();
        }
        return this.displayName;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(FunctionDTO f) {
        return Integer.compare(this.getOrdinal(), f.getOrdinal());
    }

    public String toString() {
        return String.valueOf(this.isDimension() ? "Dimension " : "Function ") + this.getSourceTypeName() + "." + this.getFunctionName() + " : " + this.getReturnTypeName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
        result = 31 * result + (this.isDimension ? 1231 : 1237);
        result = 31 * result + (this.parameterTypeNames == null ? 0 : this.parameterTypeNames.hashCode());
        result = 31 * result + (this.returnTypeName == null ? 0 : this.returnTypeName.hashCode());
        result = 31 * result + (this.sourceTypeName == null ? 0 : this.sourceTypeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDTO other = (FunctionDTO)obj;
        if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
            return false;
        }
        if (this.isDimension != other.isDimension) {
            return false;
        }
        if (this.parameterTypeNames == null ? other.parameterTypeNames != null : !this.parameterTypeNames.equals(other.parameterTypeNames)) {
            return false;
        }
        if (this.returnTypeName == null ? other.returnTypeName != null : !this.returnTypeName.equals(other.returnTypeName)) {
            return false;
        }
        return !(this.sourceTypeName == null ? other.sourceTypeName != null : !this.sourceTypeName.equals(other.sourceTypeName));
    }

    public static interface DisplayNameProvider {
        public String getDisplayName();
    }
}

