/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Person;
import com.sap.sailing.domain.base.Team;
import com.sap.sailing.server.gateway.serialization.impl.NationalityJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PersonJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TeamJsonSerializer
implements JsonSerializer<Team> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SAILORS = "sailors";
    public static final String FIELD_COACH = "coach";
    public static final String FIELD_NATIONALITY = "nationality";
    public static final String FIELD_IMAGE_URI = "imageUri";
    private final JsonSerializer<Person> personJsonSerializer;

    public static TeamJsonSerializer create() {
        return new TeamJsonSerializer(new PersonJsonSerializer(new NationalityJsonSerializer()));
    }

    public TeamJsonSerializer(JsonSerializer<Person> personJsonSerializer) {
        this.personJsonSerializer = personJsonSerializer;
    }

    public JSONObject serialize(Team team) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)team.getName());
        result.put((Object)FIELD_COACH, (Object)this.personJsonSerializer.serialize((Object)team.getCoach()));
        JSONArray jsonSailors = new JSONArray();
        for (Person sailor : team.getSailors()) {
            jsonSailors.add((Object)this.personJsonSerializer.serialize((Object)sailor));
        }
        result.put((Object)FIELD_SAILORS, (Object)jsonSailors);
        if (team.getImage() != null) {
            result.put((Object)FIELD_IMAGE_URI, (Object)team.getImage().toString());
        }
        return result;
    }
}

