/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.impl;

import com.sap.db.jdbc.Driver;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.hanaexport.HanaConnectionFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Logger;

public class HanaConnectionFactoryImpl
implements HanaConnectionFactory {
    private static final Logger logger = Logger.getLogger(HanaConnectionFactoryImpl.class.getName());
    private static final String HANADB_ENDPOINT_PROPERTY_NAME = "sap.hana.endpoint";
    private static final String HANADB_USERNAME_SYSTEM_PROPERTY_NAME = "sap.hana.username";
    private static final String HANADB_PASSWORD_SYSTEM_PROPERTY_NAME = "sap.hana.password";

    public void test() throws SQLException {
        System.out.println("Java version: " + Driver.getJavaVersion());
        System.out.println("Minimum supported Java version and SAP driver version number: " + Driver.getVersionInfo());
        Connection connection = this.getConnection(Optional.empty(), Optional.empty(), Optional.empty());
        if (connection == null) {
            logger.warning("Couldn't get database connection for end point " + System.getProperty(HANADB_ENDPOINT_PROPERTY_NAME));
        } else {
            connection.createStatement().execute("DELETE FROM SAILING.BOAT_CLASS");
            PreparedStatement insertBoatClasses = connection.prepareStatement("INSERT INTO SAILING.BOAT_CLASS (\"id\", \"description\") VALUES (?, ?);");
            BoatClassMasterdata[] boatClassMasterdataArray = BoatClassMasterdata.values();
            int n = boatClassMasterdataArray.length;
            int n2 = 0;
            while (n2 < n) {
                BoatClassMasterdata boatClassMasterdata = boatClassMasterdataArray[n2];
                insertBoatClasses.setString(1, boatClassMasterdata.getDisplayName());
                insertBoatClasses.setString(2, "Type " + boatClassMasterdata.getHullType().name() + ", length " + boatClassMasterdata.getHullLength().getMeters() + "m, beam " + boatClassMasterdata.getHullBeam().getMeters() + "m");
                insertBoatClasses.execute();
                ++n2;
            }
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery("SELECT * FROM SAILING.BOAT_CLASS");
            logger.info("Fetch size: " + resultSet.getFetchSize());
            while (resultSet.next()) {
                logger.info(String.valueOf(resultSet.getString("id")) + " " + resultSet.getString("description"));
            }
        }
    }

    @Override
    public Connection getConnection(Optional<String> dbEndpoint, Optional<String> dbUser, Optional<String> dbPassword) throws SQLException {
        String dbEndpointFromSystemProperty = System.getProperty(HANADB_ENDPOINT_PROPERTY_NAME);
        String dbUserFromSystemProperty = System.getProperty(HANADB_USERNAME_SYSTEM_PROPERTY_NAME);
        String dbPasswordFromSystemProperty = System.getProperty(HANADB_PASSWORD_SYSTEM_PROPERTY_NAME);
        String dbUrl = "jdbc:sap://" + dbEndpoint.orElseGet(() -> {
            if (dbEndpointFromSystemProperty != null) {
                return dbEndpointFromSystemProperty;
            }
            throw new IllegalStateException("Missing DB URL, either as parameter or from system property sap.hana.endpoint");
        });
        return DriverManager.getConnection(dbUrl, dbUser.orElseGet(() -> {
            if (dbUserFromSystemProperty != null) {
                return dbUserFromSystemProperty;
            }
            throw new IllegalStateException("Missing DB user name, either as parameter or from system property sap.hana.username");
        }), dbPassword.orElseGet(() -> {
            if (dbPasswordFromSystemProperty != null) {
                return dbPasswordFromSystemProperty;
            }
            throw new IllegalStateException("Missing DB password, either as parameter or from system property sap.hana.password");
        }));
    }

    public static void main(String[] args) throws SQLException {
        new HanaConnectionFactoryImpl().test();
    }
}

