/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.oceanraceadapter.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OceanRaceGPSFixImporter
implements GPSFixImporter {
    private static final String BEACONS_OBJECT_NAME = "beacons";
    private static final String DATA_ARRAY_NAME = "data";
    private static final String BOAT_NAME_FIELD_NAME = "boat_name";
    private static final String TIMESTAMP_FIELD_NAME = "gpsAtMillis";
    private static final String LATITUDE_FIELD_NAME = "latitude";
    private static final String LONGITUDE_FIELD_NAME = "longitude";
    private static final String SOG_KNOTS_FIELD_NAME = "sogKnots";
    private static final String COG_DEGREES_FIELD_NAME = "cog";
    private static final String SERIAL_FIELD_NAME = "serial";
    private static final String DEVICE_TYPE_FIELD_NAME = "device_type";
    private static final String DEVICE_LOCATION_FIELD_NAME = "device_location";
    private final Map<Util.Pair<String, String>, TrackFileImportDeviceIdentifier> deviceIdentifiersBySerialAndSourceName = new HashMap<Util.Pair<String, String>, TrackFileImportDeviceIdentifier>();

    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws FormatNotSupportedException, IOException, ParseException {
        JSONParser jsonParser = new JSONParser();
        JSONArray boatsArray = (JSONArray)jsonParser.parse((Reader)new InputStreamReader(inputStream));
        for (Object objectForBoat : boatsArray) {
            JSONObject jsonObjectForBoat = (JSONObject)objectForBoat;
            String boatName = jsonObjectForBoat.get((Object)BOAT_NAME_FIELD_NAME).toString();
            JSONArray boatFixes = (JSONArray)((JSONObject)jsonObjectForBoat.get((Object)BEACONS_OBJECT_NAME)).get((Object)DATA_ARRAY_NAME);
            GPSFixMoving lastFix = null;
            for (Object boatFixObject : boatFixes) {
                JSONObject boatFixJsonObject = (JSONObject)boatFixObject;
                GPSFixMoving nextFix = this.parseFix(boatFixJsonObject, lastFix, inferSpeedAndBearing);
                TrackFileImportDeviceIdentifier deviceIdentifier = this.getDeviceIdentifier(sourceName, boatName, boatFixJsonObject);
                callback.addFix((GPSFix)nextFix, deviceIdentifier);
                lastFix = nextFix;
            }
        }
        return true;
    }

    private TrackFileImportDeviceIdentifier getDeviceIdentifier(String sourceName, String boatName, JSONObject boatFixJsonObject) {
        String serial = String.format("%s-%s-%s-%s", boatName, boatFixJsonObject.get((Object)SERIAL_FIELD_NAME).toString(), boatFixJsonObject.get((Object)DEVICE_TYPE_FIELD_NAME).toString(), boatFixJsonObject.get((Object)DEVICE_LOCATION_FIELD_NAME).toString());
        Util.Pair key = new Util.Pair((Object)serial, (Object)sourceName);
        return this.deviceIdentifiersBySerialAndSourceName.computeIfAbsent((Util.Pair<String, String>)key, k -> new TrackFileImportDeviceIdentifierImpl(UUID.randomUUID(), (String)k.getB(), (String)key.getA(), TimePoint.now()));
    }

    private GPSFixMoving parseFix(JSONObject boatFixJsonObject, GPSFixMoving lastFix, boolean inferSpeedAndBearing) {
        TimePoint timePoint = TimePoint.of((long)((Number)boatFixJsonObject.get((Object)TIMESTAMP_FIELD_NAME)).longValue());
        double latDeg = boatFixJsonObject.get((Object)LATITUDE_FIELD_NAME) == null ? 0.0 : Double.valueOf((String)boatFixJsonObject.get((Object)LATITUDE_FIELD_NAME));
        double lngDeg = boatFixJsonObject.get((Object)LONGITUDE_FIELD_NAME) == null ? 0.0 : Double.valueOf((String)boatFixJsonObject.get((Object)LONGITUDE_FIELD_NAME));
        DegreePosition position = new DegreePosition(latDeg, lngDeg);
        String cogAsString = (String)boatFixJsonObject.get((Object)COG_DEGREES_FIELD_NAME);
        String sogAsString = (String)boatFixJsonObject.get((Object)SOG_KNOTS_FIELD_NAME);
        Object cog = cogAsString != null ? new DegreeBearingImpl(Double.valueOf(cogAsString).doubleValue()) : (inferSpeedAndBearing && lastFix != null && lastFix.getPosition() != null ? (lastFix.getTimePoint().before(timePoint) ? lastFix.getPosition().getBearingGreatCircle((Position)position) : position.getBearingGreatCircle(lastFix.getPosition())) : new DegreeBearingImpl(0.0));
        double sogInKnots = sogAsString != null ? Double.valueOf(sogAsString) : (inferSpeedAndBearing && lastFix != null && lastFix.getPosition() != null ? (lastFix.getTimePoint().before(timePoint) ? lastFix.getSpeedAndBearingRequiredToReach((GPSFix)new GPSFixImpl((Position)position, timePoint)).getKnots() : new GPSFixImpl((Position)position, timePoint).getSpeedAndBearingRequiredToReach((GPSFix)lastFix).getKnots()) : 0.0);
        return new GPSFixMovingImpl((Position)position, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(sogInKnots, (Bearing)cog), null);
    }

    public Iterable<String> getSupportedFileExtensions() {
        return Collections.singleton("json");
    }

    public String getType() {
        return "The Ocean Race GPS Fix Importer";
    }
}

