/*
 * Decompiled with CFR 0.152.
 */
package com.sapsailing.xrr.structureimport.eventimport;

import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sapsailing.xrr.structureimport.eventimport.EventResults;
import com.sapsailing.xrr.structureimport.eventimport.RegattaJSON;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class EventParser {
    private static final Logger logger = Logger.getLogger(EventParser.class.getName());

    public EventResults parseEvent(String url) {
        EventResults eventResults = null;
        try {
            InputStreamReader streamReader = this.getStreamReader(url);
            JSONObject jsonRoot = (JSONObject)new JSONParser().parse((Reader)streamReader);
            String id = (String)jsonRoot.get((Object)"Id");
            String name = (String)jsonRoot.get((Object)"Name");
            String xrrUrl = (String)jsonRoot.get((Object)"XrrUrl");
            eventResults = new EventResults(id, name, xrrUrl);
            JSONArray jsonRegattas = (JSONArray)jsonRoot.get((Object)"Regattas");
            for (Object regattaObject : jsonRegattas) {
                RegattaJSON regatta = new RegattaJSON();
                JSONObject jsonRegatta = (JSONObject)regattaObject;
                regatta.setId((String)jsonRegatta.get((Object)"Id"));
                regatta.setName((String)jsonRegatta.get((Object)"Name"));
                regatta.setBoatClass((String)jsonRegatta.get((Object)"ClassName"));
                regatta.setGender((String)jsonRegatta.get((Object)"Gender"));
                regatta.setXrrEntriesUrl((String)jsonRegatta.get((Object)"XrrEntriesUrl"));
                regatta.setXrrPreliminaryUrl((String)jsonRegatta.get((Object)"XrrPreliminaryUrl"));
                regatta.setXrrFinalUrl((String)jsonRegatta.get((Object)"XrrFinalUrl"));
                regatta.setHtmlUrl((String)jsonRegatta.get((Object)"HtmlUrl"));
                eventResults.addRegatta(regatta);
            }
            streamReader.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during parsing event structure", e);
        }
        return eventResults;
    }

    private InputStreamReader getStreamReader(String url) throws UnsupportedEncodingException {
        InputStream is = null;
        URLConnection connection = null;
        try {
            connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(url));
            is = connection.getInputStream();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during connecting to event structure url " + url, e);
        }
        return new InputStreamReader(is, "UTF-8");
    }
}

