/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.manage2sail;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.client.utils.URIBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String MANAGE2SAIL_HOSTNAME = "www.manage2sail.com";
    private static final String ACCESS_TOKEN_PROPERTY_NAME = "manage2sail.accesstoken";
    private static final String ACCESS_TOKEN_URL_QUERY_PARAMETER_NAME = "accesstoken";
    private static Activator INSTANCE;
    private String accessToken;

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this.accessToken = System.getProperty(ACCESS_TOKEN_PROPERTY_NAME);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static Activator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Activator();
        }
        return INSTANCE;
    }

    private String getAccessToken() {
        return this.accessToken;
    }

    public URL addAccessTokenToManage2SailUrl(URL url) throws URISyntaxException, MalformedURLException {
        URIBuilder uriBuilder = new URIBuilder(url.toURI());
        boolean containsAccessTokenQueryParam = uriBuilder.getQueryParams().stream().anyMatch(nameValuePair -> nameValuePair.getName().equals(ACCESS_TOKEN_URL_QUERY_PARAMETER_NAME));
        URL result = url.getHost().equals(this.getManage2SailHostname()) && !containsAccessTokenQueryParam ? uriBuilder.addParameter(ACCESS_TOKEN_URL_QUERY_PARAMETER_NAME, this.getAccessToken()).build().toURL() : url;
        return result;
    }

    public String getManage2SailHostname() {
        return MANAGE2SAIL_HOSTNAME;
    }
}

