/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.graph.impl;

import com.sap.sse.util.graph.CycleCluster;
import com.sap.sse.util.graph.CycleClusters;
import com.sap.sse.util.graph.DirectedEdge;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CycleClustersImpl<T>
implements CycleClusters<T> {
    private final Set<CycleCluster<T>> clusters;

    public CycleClustersImpl(Set<CycleCluster<T>> clusters) {
        this.clusters = new HashSet<CycleCluster<T>>(clusters);
    }

    @Override
    public CycleCluster<T> getCluster(T node) {
        for (CycleCluster<T> cluster : this.clusters) {
            if (!cluster.contains(node)) continue;
            return cluster;
        }
        return null;
    }

    @Override
    public Iterable<CycleCluster<T>> getClusters() {
        return Collections.unmodifiableCollection(this.clusters);
    }

    @Override
    public boolean isEdgeInCycleCluster(DirectedEdge<T> edge) {
        return this.clusters.stream().anyMatch(c -> c.contains(edge.getFrom()) && c.contains(edge.getTo()));
    }

    @Override
    public boolean areDisjoint() {
        for (CycleCluster<T> c1 : this.clusters) {
            for (CycleCluster<T> c2 : this.clusters) {
                if (c1 == c2) continue;
                HashSet<T> set = new HashSet<T>(c1.getClusterNodes());
                set.retainAll(c2.getClusterNodes());
                if (set.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

