/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerFactory {
    private static final Logger logger = Logger.getLogger(ServiceTrackerFactory.class.getName());

    public static <T> ServiceTracker<T, T> createAndOpen(BundleContext context, Class<T> clazz) {
        return ServiceTrackerFactory.createAndOpen(context, clazz, null);
    }

    public static <T> ServiceTracker<T, T> createAndOpen(BundleContext context, Filter filter) {
        return ServiceTrackerFactory.createAndOpen(context, filter, null);
    }

    public static <T> ServiceTracker<T, T> createAndOpen(BundleContext context, Filter filter, ServiceTrackerCustomizer<T, T> customizer) {
        ServiceTracker result;
        if (context == null) {
            logger.info("No BundleContext provided. Returning null.");
            result = null;
        } else {
            result = new ServiceTracker(context, filter, customizer);
            result.open();
        }
        return result;
    }

    public static <T> ServiceTracker<T, T> createAndOpen(BundleContext context, Class<T> clazz, ServiceTrackerCustomizer<T, T> customizer) {
        ServiceTracker result;
        if (context == null) {
            logger.info("No BundleContext provided. Returning null.");
            result = null;
        } else {
            result = new ServiceTracker(context, clazz, customizer);
            result.open();
        }
        return result;
    }

    public static <T> Future<T> createServiceFuture(BundleContext bundleContext, final Class<T> serviceClass) {
        final ServiceTracker tracker = new ServiceTracker(bundleContext, serviceClass, null);
        tracker.open();
        final FutureTask result = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws InterruptedException {
                try {
                    logger.info("Waiting for " + serviceClass.getSimpleName() + " service...");
                    Object service = tracker.waitForService(0L);
                    logger.info("Obtained UserStore service " + service);
                    return service;
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, "Interrupted while waiting for " + serviceClass.getSimpleName() + " service", e);
                    throw e;
                }
            }
        });
        new Thread("ServiceTracker waiting for " + serviceClass.getSimpleName() + " service"){

            @Override
            public void run() {
                try {
                    result.run();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception while waiting for " + serviceClass.getSimpleName() + " service", e);
                }
            }
        }.start();
        return result;
    }
}

