/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.rest;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class GwtLocaleFromHttpRequestUtil {
    public static Optional<String> getLocaleFromHttpRequest(HttpServletRequest httpServletRequest) {
        Optional<String> locale = Optional.empty();
        Map parameterMap = httpServletRequest.getParameterMap();
        if (parameterMap != null && parameterMap.containsKey("locale")) {
            locale = Optional.of(((String[])parameterMap.get("locale"))[0]);
        } else {
            String acceptLanguageHeader;
            if (httpServletRequest.getCookies() != null) {
                Cookie[] cookieArray = httpServletRequest.getCookies();
                int n = cookieArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie cookie = cookieArray[n2];
                    if (cookie.getName().equals("GWT_LOCALE")) {
                        locale = Optional.of(cookie.getValue());
                        break;
                    }
                    ++n2;
                }
            }
            if (!locale.isPresent() && (acceptLanguageHeader = httpServletRequest.getHeader("Accept-Language")) != null) {
                locale = Optional.of(GwtLocaleFromHttpRequestUtil.getFirstFromAcceptLanguage(acceptLanguageHeader));
            }
        }
        return locale;
    }

    private static String getFirstFromAcceptLanguage(String acceptLanguageHeader) {
        if (acceptLanguageHeader == null) {
            return null;
        }
        String[] langs = acceptLanguageHeader.split(",");
        String result = langs.length > 0 ? langs[0].split(";")[0].trim() : null;
        return result;
    }
}

