/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.dto;

import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;

public abstract class NamedSecuredObjectDTO
extends NamedDTO
implements SecuredDTO {
    private static final long serialVersionUID = 2642220699434177353L;
    private SecurityInformationDTO securityInformation;

    @Deprecated
    protected NamedSecuredObjectDTO() {
    }

    protected NamedSecuredObjectDTO(String name) {
        super(name);
        this.securityInformation = new SecurityInformationDTO();
    }

    protected NamedSecuredObjectDTO(String name, SecurityInformationDTO securityInformation) {
        this(name);
        this.securityInformation = securityInformation;
    }

    protected SecurityInformationDTO getSecurityInformation() {
        return this.securityInformation;
    }

    @Override
    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    @Override
    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    @Override
    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    @Override
    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }

    public static NamedSecuredObjectDTO create(String name, final HasPermissions type, final TypeRelativeObjectIdentifier objectId) {
        return new NamedSecuredObjectDTO(name){
            private static final long serialVersionUID = 7803271077711791212L;

            @Override
            public QualifiedObjectIdentifier getIdentifier() {
                return type.getQualifiedObjectIdentifier(objectId);
            }

            @Override
            public HasPermissions getPermissionType() {
                return type;
            }
        };
    }
}

