/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs.exceptions;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringEscapeUtils;

@Provider
public class ExceptionManager
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        return Response.status((int)400).entity((Object)exception.getMessage()).type("text/plain").build();
    }

    public static String invalidDateFormatMsg(String date) {
        return "The date " + StringEscapeUtils.escapeHtml((String)date) + " does not follow the date pattern \"dd-MM-yyyy\".";
    }

    public static String invalidURLFormatMsg(String url) {
        return "The format of the url " + StringEscapeUtils.escapeHtml((String)url) + " is incorrect.";
    }

    public static String parameterRequiredMsg(String param) {
        return "The parameter \"" + StringEscapeUtils.escapeHtml((String)param) + "\" is required.";
    }

    public static String atLeastOneParameterRequiredMsg(String ... params) {
        return "Please provide at least one of the following parameters: " + Arrays.stream(params).collect(Collectors.joining(", "));
    }

    public static String invalidIdFormatMsg(String id) {
        return "The format of the id " + StringEscapeUtils.escapeHtml((String)id) + " is incorrect.";
    }

    public static String objectNotFoundMsg(String name, Object id) {
        return "The " + name + " with id " + id + " was not found.";
    }

    public static String incorrectParameterValue(String value, String correctValues) {
        return "The value \"" + StringEscapeUtils.escapeHtml((String)value) + "\" is not recognized. Correct values are: " + correctValues;
    }

    public static String objectAlreadyExists(String objectTypeName, String objectName) {
        return "The \"" + StringEscapeUtils.escapeHtml((String)objectTypeName) + "\" with name \"" + StringEscapeUtils.escapeHtml((String)objectName) + "\" already exists.";
    }
}

