/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBuilder;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.impl.FixedPositioningImpl;
import com.sap.sailing.domain.coursetemplate.impl.TrackingDeviceBasedPositioningImpl;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneUUIDIdentifierImpl;
import com.sap.sailing.server.gateway.serialization.impl.DeviceIdentifierJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.MarkPropertiesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.impl.PlaceHolderDeviceIdentifierJsonHandler;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.common.Color;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.shared.json.JsonSerializer;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/markproperties")
public class MarkPropertiesResource
extends SharedAbstractSailingServerResource {
    private JsonSerializer<MarkProperties> markPropertiesSerializer;

    private Response getBadMarkPropertiesValidationErrorResponse(String errorText) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    private Response getMarkPropertiesNotFoundErrorResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkProperties(@QueryParam(value="tags") List<String> tags) throws Exception {
        Iterable markPropertiesList = this.getSharedSailingData().getAllMarkProperties(tags);
        JSONArray result = new JSONArray();
        for (MarkProperties markProperties : markPropertiesList) {
            result.add((Object)this.getMarkPropertiesSerializer().serialize((Object)markProperties));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Path(value="{markPropertiesId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkProperties(@PathParam(value="markPropertiesId") String markPropertiesId) throws Exception {
        MarkProperties markProperties = this.getSharedSailingData().getMarkPropertiesById(UUID.fromString(markPropertiesId));
        if (markProperties == null) {
            return this.getMarkPropertiesNotFoundErrorResponse();
        }
        JSONObject serializedMarkProperties = this.getMarkPropertiesSerializer().serialize((Object)markProperties);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createMarkProperties(@FormParam(value="name") String name, @FormParam(value="shortName") String shortName, @FormParam(value="deviceUuid") String deviceUuid, @FormParam(value="color") String rgbColor, @FormParam(value="shape") String shape, @FormParam(value="pattern") String pattern, @FormParam(value="markType") String markType, @FormParam(value="tags") List<String> tags, @FormParam(value="latDeg") Double latDeg, @FormParam(value="lonDeg") Double lonDeg) throws Exception {
        if (name == null || name.isEmpty()) {
            return this.getBadMarkPropertiesValidationErrorResponse("name must be given");
        }
        String effectiveShortName = shortName == null || shortName.isEmpty() ? name : shortName;
        RGBColor color = null;
        if (rgbColor != null && rgbColor.length() > 0) {
            try {
                color = new RGBColor(rgbColor);
            }
            catch (IllegalArgumentException iae) {
                return this.getBadMarkPropertiesValidationErrorResponse(String.format("invalid color %s", iae.getMessage()));
            }
        }
        MarkType type = null;
        if (markType != null && markType.length() > 0) {
            type = MarkType.valueOf((String)markType);
        }
        if (deviceUuid != null && deviceUuid.length() > 0 && (latDeg != null || lonDeg != null)) {
            return this.getBadMarkPropertiesValidationErrorResponse("deviceUuid and fixed positioning cannot be used together");
        }
        if (latDeg != null && lonDeg == null || latDeg == null && lonDeg != null) {
            return this.getBadMarkPropertiesValidationErrorResponse("incomplete positioning");
        }
        MarkPropertiesBuilder markPropertiesBuilder = new MarkPropertiesBuilder(null, name, effectiveShortName, (Color)color, shape, pattern, type);
        MarkProperties createdMarkProperties = this.getSharedSailingData().createMarkProperties((CommonMarkProperties)markPropertiesBuilder.build(), tags, Optional.empty());
        if (deviceUuid != null && deviceUuid.length() > 0) {
            SmartphoneUUIDIdentifierImpl device = new SmartphoneUUIDIdentifierImpl(UUID.fromString(deviceUuid));
            this.getSharedSailingData().setTrackingDeviceIdentifierForMarkProperties(createdMarkProperties, (DeviceIdentifier)device);
        }
        if (latDeg != null && lonDeg != null) {
            DegreePosition fixedPosition = new DegreePosition(latDeg.doubleValue(), lonDeg.doubleValue());
            this.getSharedSailingData().setFixedPositionForMarkProperties(createdMarkProperties, (Position)fixedPosition);
        }
        JSONObject serializedMarkProperties = this.getMarkPropertiesSerializer().serialize((Object)createdMarkProperties);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @PUT
    @Path(value="{markPropertiesId}/positioning")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateMarkPropertiesPositioning(@PathParam(value="markPropertiesId") String markPropertiesId, @FormParam(value="deviceUuid") String deviceUuid, @FormParam(value="latDeg") Double latDeg, @FormParam(value="lonDeg") Double lonDeg) throws Exception {
        MarkProperties markProperties = this.getSharedSailingData().getMarkPropertiesById(UUID.fromString(markPropertiesId));
        if (markProperties == null) {
            return this.getMarkPropertiesNotFoundErrorResponse();
        }
        if (deviceUuid != null && deviceUuid.length() > 0) {
            SmartphoneUUIDIdentifierImpl device = new SmartphoneUUIDIdentifierImpl(UUID.fromString(deviceUuid));
            this.getSharedSailingData().setTrackingDeviceIdentifierForMarkProperties(markProperties, (DeviceIdentifier)device);
        } else if (latDeg != null && lonDeg != null) {
            DegreePosition fixedPosition = new DegreePosition(latDeg.doubleValue(), lonDeg.doubleValue());
            this.getSharedSailingData().setFixedPositionForMarkProperties(markProperties, (Position)fixedPosition);
        } else {
            this.getSharedSailingData().clearPositioningForMarkProperties(markProperties);
        }
        JSONObject serializedMarkProperties = this.getMarkPropertiesSerializer().serialize((Object)markProperties);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @PUT
    @Path(value="{markPropertiesId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response updateMarkProperties(@PathParam(value="markPropertiesId") String markPropertiesId, @FormParam(value="name") String name, @FormParam(value="shortName") String shortName, @FormParam(value="color") String rgbColor, @FormParam(value="shape") String shape, @FormParam(value="pattern") String pattern, @FormParam(value="markType") String markType, @FormParam(value="tags") List<String> tags, @FormParam(value="deviceUuid") String deviceUuid, @FormParam(value="latDeg") Double latDeg, @FormParam(value="lonDeg") Double lonDeg) throws Exception {
        TrackingDeviceBasedPositioningImpl positioningInformation;
        UUID markPropertiesUUID = UUID.fromString(markPropertiesId);
        MarkProperties markProperties = this.getSharedSailingData().getMarkPropertiesById(markPropertiesUUID);
        if (markProperties == null) {
            return this.getMarkPropertiesNotFoundErrorResponse();
        }
        if (name == null || name.isEmpty()) {
            return this.getBadMarkPropertiesValidationErrorResponse("name must be given");
        }
        String effectiveShortName = shortName == null || shortName.isEmpty() ? name : shortName;
        RGBColor color = null;
        if (rgbColor != null && rgbColor.length() > 0) {
            try {
                color = new RGBColor(rgbColor);
            }
            catch (IllegalArgumentException iae) {
                return this.getBadMarkPropertiesValidationErrorResponse(String.format("invalid color %s", iae.getMessage()));
            }
        }
        MarkType type = null;
        if (markType != null && markType.length() > 0) {
            type = MarkType.valueOf((String)markType);
        }
        MarkPropertiesBuilder markPropertiesBuilder = new MarkPropertiesBuilder(null, name, effectiveShortName, (Color)color, shape, pattern, type);
        if (deviceUuid != null && deviceUuid.length() > 0) {
            positioningInformation = new TrackingDeviceBasedPositioningImpl((DeviceIdentifier)new SmartphoneUUIDIdentifierImpl(UUID.fromString(deviceUuid)));
        } else if (latDeg != null && lonDeg != null) {
            DegreePosition fixedPosition = new DegreePosition(latDeg.doubleValue(), lonDeg.doubleValue());
            positioningInformation = new FixedPositioningImpl((Position)fixedPosition);
        } else {
            positioningInformation = null;
        }
        this.getSharedSailingData().updateMarkProperties(markPropertiesUUID, (CommonMarkProperties)markPropertiesBuilder.build(), (Positioning)positioningInformation, tags);
        JSONObject serializedMarkProperties = this.getMarkPropertiesSerializer().serialize((Object)markProperties);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @DELETE
    @Path(value="{markPropertiesId}")
    public Response deleteMarkProperties(@PathParam(value="markPropertiesId") String markPropertiesId) throws Exception {
        MarkProperties markProperties = this.getSharedSailingData().getMarkPropertiesById(UUID.fromString(markPropertiesId));
        if (markProperties == null) {
            return this.getMarkPropertiesNotFoundErrorResponse();
        }
        this.getSharedSailingData().deleteMarkProperties(markProperties);
        return Response.ok().build();
    }

    private synchronized JsonSerializer<MarkProperties> getMarkPropertiesSerializer() {
        if (this.markPropertiesSerializer == null) {
            TypeBasedServiceFinder deviceJsonServiceFinder = this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class);
            deviceJsonServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierJsonHandler());
            this.markPropertiesSerializer = new MarkPropertiesJsonSerializer(new DeviceIdentifierJsonSerializer(deviceJsonServiceFinder));
        }
        return this.markPropertiesSerializer;
    }
}

