/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.nmeaconnector.impl;

import com.sap.sailing.nmeaconnector.BATSentence;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.TalkerId;

public class BATParser
extends SentenceParser
implements BATSentence {
    private static final int WIND_VANE_BATTERY_STATUS = 0;
    private static final int BASE_UNIT_BATTERY_LEVEL = 1;

    public BATParser(String nmea) {
        super(nmea, "BAT");
    }

    public BATParser(TalkerId talker) {
        super(talker, "BAT", 2);
    }

    @Override
    public BATSentence.WindVaneBatteryStatus getWindVaneBatteryStatus() {
        BATSentence.WindVaneBatteryStatus result = null;
        int intValue = this.getIntValue(0);
        BATSentence.WindVaneBatteryStatus[] windVaneBatteryStatusArray = BATSentence.WindVaneBatteryStatus.values();
        int n = windVaneBatteryStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            BATSentence.WindVaneBatteryStatus status = windVaneBatteryStatusArray[n2];
            if (status.getValue() == intValue) {
                result = status;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public int getBaseUnitBatteryLevel() {
        return this.getIntValue(1);
    }

    @Override
    public void setWindVaneBatteryStatus(BATSentence.WindVaneBatteryStatus status) {
        this.setIntValue(0, status.getValue());
    }

    @Override
    public void setBaseUnitBatteryLevel(int level) {
        if (level < 0 || level > 9) {
            throw new IllegalArgumentException("Level must be in the range 0..9 but was " + level);
        }
        this.setIntValue(1, level);
    }
}

