/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.windfinderadapter.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.domain.windfinder.ReviewedSpotsCollection;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinder.WindFinderSpotListener;
import com.sap.sailing.domain.windfinderadapter.impl.WindFinderReportParser;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpotImpl
extends SpotDTO
implements Spot {
    private static final long serialVersionUID = -7793334775486020313L;
    private static final Logger logger = Logger.getLogger(SpotImpl.class.getName());
    private final WindFinderReportParser parser;
    private final ReviewedSpotsCollection collection;
    private final ConcurrentMap<WindFinderSpotListener, Boolean> listeners;
    private TimePoint latestMeasurement;
    private static final Duration POLL_EVERY = Duration.ONE_MINUTE;
    private ScheduledFuture<?> poller;

    public SpotImpl(String name, String id, String keyword, String englishCountryName, Position position, WindFinderReportParser parser, ReviewedSpotsCollection collection) {
        super(name, id, keyword, englishCountryName, position);
        this.parser = parser;
        this.collection = collection;
        this.listeners = new ConcurrentHashMap<WindFinderSpotListener, Boolean>();
    }

    public void addListener(WindFinderSpotListener listener) {
        if (this.listeners.isEmpty()) {
            this.ensurePollerRunning();
        }
        this.listeners.put(listener, true);
    }

    private synchronized void ensurePollerRunning() {
        if (this.poller == null) {
            logger.info("Starting to poll from WindFinder spot " + this.getId() + " as the first listener started listening.");
            this.poller = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(this::poll, 0L, POLL_EVERY.asMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void poll() {
        try {
            Iterable<Wind> windFixes = this.getAllMeasurementsAfter(this.latestMeasurement);
            logger.fine("Received " + Util.size(windFixes) + " wind fixes from WindFinder spot " + this.getId() + ". Notifying " + this.listeners.size() + " listeners.");
            for (Wind wind : windFixes) {
                if (this.latestMeasurement != null && !wind.getTimePoint().after(this.latestMeasurement)) continue;
                this.latestMeasurement = wind.getTimePoint();
            }
            this.notifyListeners(windFixes);
        }
        catch (IOException | java.text.ParseException | ParseException e) {
            logger.log(Level.SEVERE, "Error trying to obtain WindFinder measurements from spot " + this.getId(), e);
        }
    }

    private void notifyListeners(Iterable<Wind> windFixes) {
        for (WindFinderSpotListener listener : this.listeners.keySet()) {
            listener.windDataReceived(windFixes, (Spot)this);
        }
    }

    private synchronized void stopPoller() {
        logger.info("Stopping polling from WindFinder spot " + this.getId() + " as last listener stopped listening.");
        this.poller.cancel(false);
        this.poller = null;
    }

    public void removeListener(WindFinderSpotListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stopPoller();
        }
    }

    public Iterable<Wind> getAllMeasurementsAfter(TimePoint timePoint) throws MalformedURLException, IOException, java.text.ParseException, ParseException {
        ArrayList<Wind> result = new ArrayList<Wind>();
        for (Wind measurement : this.getAllMeasurements()) {
            if (timePoint != null && !measurement.getTimePoint().after(timePoint)) continue;
            result.add(measurement);
        }
        return result;
    }

    public Iterable<Wind> getAllMeasurements() throws IOException, MalformedURLException, java.text.ParseException, ParseException {
        URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)this.getMeasurementsUrl());
        Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
        InputStream response = (InputStream)connection.getContent();
        Iterable<Wind> measurements = this.parser.parse(this.getPosition(), (JSONArray)new JSONParser().parse((Reader)new InputStreamReader(response, charset)));
        return measurements;
    }

    private URL getMeasurementsUrl() throws MalformedURLException {
        return new URL("http://external.windfinder.com/sap/" + this.collection.getId() + "_" + this.getId() + ".json");
    }
}

