/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.igtimiadapter.IgtimiWindListener;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiWindTrackerFactory;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class WindListenerSendingToTrackedRace
implements IgtimiWindListener {
    private final Iterable<DynamicTrackedRace> trackedRaces;
    private final IgtimiWindTrackerFactory windTrackerFactory;
    private final Map<TrackedRace, Integer> numberOfFixesAppliedPerTrackedRace;

    WindListenerSendingToTrackedRace(Iterable<DynamicTrackedRace> trackedRaces, IgtimiWindTrackerFactory windTrackerFactory) {
        this.trackedRaces = trackedRaces;
        this.windTrackerFactory = windTrackerFactory;
        this.numberOfFixesAppliedPerTrackedRace = new HashMap<TrackedRace, Integer>();
        for (TrackedRace trackedRace : trackedRaces) {
            this.numberOfFixesAppliedPerTrackedRace.put(trackedRace, 0);
        }
    }

    @Override
    public void windDataReceived(Wind wind, Set<Fix> fixesUsed, String deviceSerialNumber) {
        for (DynamicTrackedRace trackedRace : this.trackedRaces) {
            if (!trackedRace.recordWind(wind, this.windTrackerFactory.getWindSource(deviceSerialNumber))) continue;
            this.numberOfFixesAppliedPerTrackedRace.put((TrackedRace)trackedRace, this.numberOfFixesAppliedPerTrackedRace.get(trackedRace) + 1);
        }
    }

    public Map<TrackedRace, Integer> getFixesAppliedPerTrackedRace() {
        return this.numberOfFixesAppliedPerTrackedRace;
    }
}

