/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.protocol.HttpContext;

public class RedirectStrategyExtractingAuthorizationCode
implements RedirectStrategy {
    private static final Logger logger = Logger.getLogger(RedirectStrategyExtractingAuthorizationCode.class.getName());
    private final RedirectStrategy wrappedRedirectStrategy;
    private String code;

    public RedirectStrategyExtractingAuthorizationCode(RedirectStrategy wrappedRedirectStrategy) {
        this.wrappedRedirectStrategy = wrappedRedirectStrategy;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        boolean result = this.wrappedRedirectStrategy.isRedirected(request, response, context);
        int statusCode = response.getStatusLine().getStatusCode();
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader != null) {
            switch (statusCode) {
                case 301: 
                case 302: 
                case 307: {
                    try {
                        String codeParameter = this.getCodeFromRedirect(locationHeader);
                        if (codeParameter == null) break;
                        this.code = codeParameter;
                        logger.info("Found authorization code " + this.code + " in redirect URI " + locationHeader.getValue());
                        result = false;
                        break;
                    }
                    catch (URISyntaxException e) {
                        logger.log(Level.INFO, "Exception while trying to obtain code from redirect URI", e);
                    }
                }
            }
        }
        return result;
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        return this.wrappedRedirectStrategy.getRedirect(request, response, context);
    }

    private String getCodeFromRedirect(Header locationHeader) throws URISyntaxException {
        List params = URLEncodedUtils.parse((URI)new URI(locationHeader.getValue()), (Charset)Charset.forName("UTF-8"));
        for (NameValuePair param : params) {
            if (!param.getName().equals("code")) continue;
            return param.getValue();
        }
        return null;
    }
}

