/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiWindTrackerFactory;
import com.sap.sailing.domain.igtimiadapter.impl.WindListenerSendingToTrackedRace;
import com.sap.sailing.domain.igtimiadapter.shared.IgtimiWindReceiver;
import com.sap.sailing.domain.tracking.AbstractWindTracker;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class IgtimiWindTracker
extends AbstractWindTracker
implements WindTracker {
    private static final Logger logger = Logger.getLogger(IgtimiWindTracker.class.getName());
    private static final int TIME_INTERVAL_TO_TRACK_BEFORE_RACE_START_MILLIS = 600000;
    private static final long TIME_INTERVAL_TO_TRACK_AFTER_END_OF_RACE_MILLIS = 3600000L;
    private final Map<LiveDataConnection, Util.Pair<Iterable<String>, IgtimiWindReceiver>> liveConnectionsAndDeviceSerialNumber;
    private final IgtimiWindTrackerFactory windTrackerFactory;
    private boolean stopping;

    protected IgtimiWindTracker(DynamicTrackedRace trackedRace, IgtimiWindTrackerFactory windTrackerFactory, boolean correctByDeclination, SecurityService optionalSecurityService, IgtimiConnectionFactory connectionFactory) throws Exception {
        super(trackedRace);
        this.windTrackerFactory = windTrackerFactory;
        this.liveConnectionsAndDeviceSerialNumber = new HashMap<LiveDataConnection, Util.Pair<Iterable<String>, IgtimiWindReceiver>>();
        Subject currentSubject = SecurityUtils.getSubject();
        new Thread(currentSubject.associateWith(() -> {
            logger.info("Starting up Igtimi wind tracker for race " + trackedRace.getRace().getName());
            IgtimiConnection connection = connectionFactory.getOrCreateConnection(() -> this.getBearerToken(optionalSecurityService, trackedRace));
            IgtimiWindTracker igtimiWindTracker = this;
            synchronized (igtimiWindTracker) {
                try {
                    if (!this.stopping) {
                        LiveDataConnection liveConnection;
                        Iterable<String> devicesWeShouldListenTo = connection.getWindDevices();
                        if (!this.stopping && (liveConnection = connection.getOrCreateLiveConnection(devicesWeShouldListenTo)) != null) {
                            IgtimiWindReceiver windReceiver = new IgtimiWindReceiver((DeclinationService)(correctByDeclination ? DeclinationService.INSTANCE : null));
                            liveConnection.addListener(windReceiver);
                            windReceiver.addListener(new WindListenerSendingToTrackedRace(Collections.singleton(this.getTrackedRace()), windTrackerFactory));
                            this.liveConnectionsAndDeviceSerialNumber.put(liveConnection, (Util.Pair<Iterable<String>, IgtimiWindReceiver>)new Util.Pair(devicesWeShouldListenTo, (Object)windReceiver));
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception trying to start Igtimi wind tracker for race " + this.getTrackedRace().getRace().getName(), e);
                }
            }
        }), "IgtimiWindTracker start-up thread for race " + trackedRace.getRace().getName()).start();
    }

    private String getBearerToken(SecurityService optionalSecurityService, DynamicTrackedRace trackedRace) {
        OwnershipAnnotation ownershipOfRace;
        User user = !SecurityUtils.getSubject().isAuthenticated() ? ((ownershipOfRace = optionalSecurityService.getOwnership(trackedRace.getIdentifier())) == null ? null : (User)((Ownership)ownershipOfRace.getAnnotation()).getUserOwner()) : optionalSecurityService.getCurrentUser();
        return optionalSecurityService.getOrCreateAccessToken(user.getName());
    }

    public static TimePoint getReceivingEndTime(DynamicTrackedRace trackedRace) {
        TimePoint endOfRace = trackedRace.getEndOfRace();
        TimePoint endOfTracking = trackedRace.getEndOfTracking();
        TimePoint endTime = endOfRace == null ? (endOfTracking == null ? null : endOfTracking.plus(3600000L)) : (endOfTracking == null ? endOfRace : Collections.max(Arrays.asList(endOfRace, endOfTracking)));
        return endTime;
    }

    public static TimePoint getReceivingStartTime(DynamicTrackedRace trackedRace) {
        TimePoint startOfTracking;
        ArrayList<TimePoint> startCandidates = new ArrayList<TimePoint>();
        TimePoint startOfRace = trackedRace.getStartOfRace();
        if (startOfRace != null) {
            startCandidates.add(startOfRace);
        }
        if ((startOfTracking = trackedRace.getStartOfTracking()) != null) {
            startCandidates.add(startOfTracking);
        }
        startCandidates.add(MillisecondsTimePoint.now());
        return ((TimePoint)Collections.min(startCandidates)).minus(600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.info("Stopping Igtimi wind tracker for race " + this.getTrackedRace().getRace().getName());
        this.stopping = true;
        IgtimiWindTracker igtimiWindTracker = this;
        synchronized (igtimiWindTracker) {
            this.windTrackerFactory.windTrackerStopped(this.getTrackedRace().getRace(), this);
            for (LiveDataConnection ldc : this.liveConnectionsAndDeviceSerialNumber.keySet()) {
                Util.Pair<Iterable<String>, IgtimiWindReceiver> deviceSerialNumberAndAccountAndReceiver = this.liveConnectionsAndDeviceSerialNumber.get(ldc);
                try {
                    logger.info("Stopping Igtimi live connection " + ldc);
                    ldc.stop();
                    ldc.removeListener((BulkFixReceiver)deviceSerialNumberAndAccountAndReceiver.getB());
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception trying to stop Igtimi live connection for wind receiver for race " + this.getTrackedRace().getRace() + " and device " + deviceSerialNumberAndAccountAndReceiver.getA() + " in account " + deviceSerialNumberAndAccountAndReceiver.getB());
                }
            }
        }
    }
}

