/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.developer;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.ui.client.QueryDefinitionChangedListener;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.developer.QueryDefinitionParser;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentWithoutSettings;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.gwt.shared.TextExporter;

public class QueryDefinitionViewer
extends ComponentWithoutSettings
implements QueryDefinitionChangedListener {
    private static final String codeFormatRadioButtonGroup = "codeFormatRadioButtonGroup";
    private final StringMessages stringMessages;
    private final QueryDefinitionParser queryDefinitionParser;
    private final DockLayoutPanel dockPanel;
    private final TabLayoutPanel contentPanel;
    private final HTML detailsHtml;
    private final HTML codeHtml;
    private final RadioButton useClassGetNameRadioButton;
    private final RadioButton useStringLiteralsRadioButton;
    private final Button copyToClipboardButton;
    private StatisticQueryDefinitionDTO currentDefinition;
    private boolean active;

    public QueryDefinitionViewer(Component<?> parent, ComponentContext<?> context, final StringMessages stringMessages) {
        super(parent, context);
        this.stringMessages = stringMessages;
        this.queryDefinitionParser = new QueryDefinitionParser();
        this.detailsHtml = new HTML();
        this.detailsHtml.setWordWrap(false);
        this.codeHtml = new HTML();
        this.codeHtml.setWordWrap(false);
        ValueChangeHandler<Boolean> typeStrategyChangedHandler = new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                QueryDefinitionViewer.this.updateCode();
            }
        };
        this.useClassGetNameRadioButton = new RadioButton(codeFormatRadioButtonGroup, stringMessages.useClassGetName());
        this.useClassGetNameRadioButton.setTitle(stringMessages.useClassGetNameTooltip());
        this.useClassGetNameRadioButton.setValue(Boolean.valueOf(true));
        this.useClassGetNameRadioButton.addValueChangeHandler((ValueChangeHandler)typeStrategyChangedHandler);
        this.useStringLiteralsRadioButton = new RadioButton(codeFormatRadioButtonGroup, stringMessages.useStringLiterals());
        this.useStringLiteralsRadioButton.setTitle(stringMessages.useStringLiteralsTooltip());
        this.useStringLiteralsRadioButton.addValueChangeHandler((ValueChangeHandler)typeStrategyChangedHandler);
        HorizontalPanel codeControlsPanel = new HorizontalPanel();
        codeControlsPanel.setSpacing(5);
        codeControlsPanel.add((Widget)this.useClassGetNameRadioButton);
        codeControlsPanel.add((Widget)this.useStringLiteralsRadioButton);
        DockLayoutPanel codeDockPanel = new DockLayoutPanel(Style.Unit.PX);
        codeDockPanel.addNorth((Widget)codeControlsPanel, 30.0);
        ScrollPanel codeScrollPanel = new ScrollPanel((Widget)this.codeHtml);
        codeScrollPanel.getElement().addClassName("queryDefinitionViewerContent");
        codeDockPanel.add((Widget)codeScrollPanel);
        this.copyToClipboardButton = new Button(stringMessages.copyToClipboard(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                switch (QueryDefinitionViewer.this.contentPanel.getSelectedIndex()) {
                    case 0: {
                        TextExporter.exportToClipboard((String)QueryDefinitionViewer.this.queryDefinitionParser.parseToDetailsAsText(QueryDefinitionViewer.this.currentDefinition));
                        Notification.notify((String)stringMessages.copiedToClipboard(), (Notification.NotificationType)Notification.NotificationType.INFO);
                        break;
                    }
                    case 1: {
                        TextExporter.exportToClipboard((String)QueryDefinitionViewer.this.queryDefinitionParser.parseToCodeAsText(QueryDefinitionViewer.this.currentDefinition, QueryDefinitionViewer.this.getTypeStrategy()));
                        Notification.notify((String)stringMessages.copiedToClipboard(), (Notification.NotificationType)Notification.NotificationType.INFO);
                    }
                }
            }
        });
        this.copyToClipboardButton.setEnabled(false);
        HorizontalPanel controlsPanel = new HorizontalPanel();
        controlsPanel.setSpacing(5);
        controlsPanel.add((Widget)this.copyToClipboardButton);
        this.contentPanel = new TabLayoutPanel(30.0, Style.Unit.PX);
        ScrollPanel detailsScrollPanel = new ScrollPanel((Widget)this.detailsHtml);
        detailsScrollPanel.getElement().addClassName("queryDefinitionViewerContent");
        this.contentPanel.add((Widget)detailsScrollPanel, stringMessages.details());
        this.contentPanel.add((Widget)codeDockPanel, stringMessages.code());
        this.dockPanel = new DockLayoutPanel(Style.Unit.PX);
        this.dockPanel.addSouth((Widget)controlsPanel, 45.0);
        this.dockPanel.add((Widget)this.contentPanel);
    }

    @Override
    public void queryDefinitionChanged(StatisticQueryDefinitionDTO newQueryDefinition) {
        this.currentDefinition = newQueryDefinition;
        this.copyToClipboardButton.setEnabled(this.currentDefinition != null);
        if (this.active) {
            this.updateDetails();
            this.updateCode();
        }
    }

    private void updateDetails() {
        this.detailsHtml.setHTML(this.queryDefinitionParser.parseToDetailsAsSafeHtml(this.currentDefinition));
    }

    private void updateCode() {
        this.codeHtml.setHTML(this.queryDefinitionParser.parseToCodeAsSafeHtml(this.currentDefinition, this.getTypeStrategy()));
    }

    private QueryDefinitionParser.TypeToCodeStrategy getTypeStrategy() {
        if (this.useClassGetNameRadioButton.getValue().booleanValue()) {
            return QueryDefinitionParser.TypeToCodeStrategy.CLASS_GET_NAME;
        }
        if (this.useStringLiteralsRadioButton.getValue().booleanValue()) {
            return QueryDefinitionParser.TypeToCodeStrategy.STRING_LITERALS;
        }
        return QueryDefinitionParser.TypeToCodeStrategy.CLASS_GET_NAME;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean needsUpdate = !this.active && active;
        this.active = active;
        if (needsUpdate) {
            this.queryDefinitionChanged(this.currentDefinition);
        }
    }

    public String getLocalizedShortName() {
        return this.stringMessages.queryDefinitionViewer();
    }

    public Widget getEntryWidget() {
        return this.dockPanel;
    }

    public boolean isVisible() {
        return this.dockPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.dockPanel.setVisible(visibility);
    }

    public String getDependentCssClassName() {
        return "queryDefinitionViewer";
    }

    public String getId() {
        return "QueryDefinitionViewer";
    }
}

