/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client;

import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.ResultsPresenter;

public interface CompositeResultsPresenter<SettingsType extends Settings>
extends ResultsPresenter<SettingsType> {
    public String getCurrentPresenterId();

    public int getCurrentPresenterIndex();

    public Iterable<String> getPresenterIds();

    public boolean containsPresenter(String var1);

    public int getPresenterIndex(String var1);

    public QueryResultDTO<?> getResult(String var1);

    public StatisticQueryDefinitionDTO getQueryDefinition(String var1);

    public void showResult(String var1, StatisticQueryDefinitionDTO var2, QueryResultDTO<?> var3);

    public void showResults(Iterable<Util.Pair<StatisticQueryDefinitionDTO, QueryResultDTO<?>>> var1);

    public void showError(String var1, StatisticQueryDefinitionDTO var2, String var3);

    public void showError(String var1, StatisticQueryDefinitionDTO var2, String var3, Iterable<String> var4);

    public void showBusyIndicator(String var1);

    public void addCurrentPresenterChangedListener(CurrentPresenterChangedListener var1);

    public void removeCurrentPresenterChangedListener(CurrentPresenterChangedListener var1);

    public void addPresenterRemovedListener(PresenterRemovedListener var1);

    public void removePresenterRemovedListener(PresenterRemovedListener var1);

    @Override
    default public QueryResultDTO<?> getCurrentResult() {
        return this.getResult(this.getCurrentPresenterId());
    }

    @Override
    default public StatisticQueryDefinitionDTO getCurrentQueryDefinition() {
        return this.getQueryDefinition(this.getCurrentPresenterId());
    }

    @Override
    default public void showResult(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        this.showResult(this.getCurrentPresenterId(), queryDefinition, result);
    }

    @Override
    default public void showError(StatisticQueryDefinitionDTO queryDefinition, String error) {
        this.showError(this.getCurrentPresenterId(), queryDefinition, error);
    }

    @Override
    default public void showError(String mainError, Iterable<String> detailedErrors, StatisticQueryDefinitionDTO queryDefinition) {
        this.showError(this.getCurrentPresenterId(), queryDefinition, mainError, detailedErrors);
    }

    @Override
    default public void showBusyIndicator() {
        this.showBusyIndicator(this.getCurrentPresenterId());
    }

    @FunctionalInterface
    public static interface CurrentPresenterChangedListener {
        public void currentPresenterChanged(String var1);
    }

    @FunctionalInterface
    public static interface PresenterRemovedListener {
        public void onPresenterRemoved(String var1, int var2, StatisticQueryDefinitionDTO var3);
    }
}

