/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.login;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.controls.PasswordTextBoxWithWatermark;
import com.sap.sse.gwt.client.controls.TextBoxWithWatermark;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.gwt.shared.ClientConfiguration;
import com.sap.sse.security.ui.client.EntryPointLinkFactory;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.ForgotPasswordDialog;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import com.sap.sse.security.ui.client.shared.oauthlogin.OAuthLogin;
import com.sap.sse.security.ui.login.LoginView;
import com.sap.sse.security.ui.login.LoginViewResources;
import java.util.Collections;

public class LoginView
extends Composite {
    private static LoginViewUiBinder uiBinder = (LoginViewUiBinder)GWT.create(LoginViewUiBinder.class);
    private final UserManagementWriteServiceAsync userManagementWriteService;
    private final UserService userService;
    private final StringMessages stringMessages;
    @UiField
    TextBoxWithWatermark userNameTextBox;
    @UiField
    Label appNameLabel;
    @UiField
    Anchor forgotPasswordAnchor;
    @UiField
    PasswordTextBoxWithWatermark passwordTextBox;
    @UiField
    Button loginButton;
    @UiField
    Anchor signUpAnchor;
    @UiField
    HTMLPanel oAuthPanel;
    @UiField
    ImageElement logoImage;

    public LoginView(UserManagementWriteServiceAsync userManagementWriteService, UserService userService, StringMessages stringMessages, String appName) {
        this.userManagementWriteService = userManagementWriteService;
        this.userService = userService;
        this.stringMessages = stringMessages;
        LoginViewResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.appNameLabel.setText(appName);
        this.userNameTextBox.setWatermark(stringMessages.username());
        this.userNameTextBox.setWatermarkStyleName(LoginViewResources.INSTANCE.css().textInput_watermark());
        this.passwordTextBox.setWatermark(stringMessages.password());
        this.passwordTextBox.setWatermarkStyleName(LoginViewResources.INSTANCE.css().passwordTextInput_watermark());
        this.oAuthPanel.add((Widget)new OAuthLogin(userManagementWriteService));
        this.userNameTextBox.setFocus(true);
        DialogUtils.linkEnterToButton((Button)this.loginButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.userNameTextBox, this.passwordTextBox});
        this.userNameTextBox.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        if (!ClientConfiguration.getInstance().isBrandingActive()) {
            this.logoImage.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    @UiHandler(value={"loginButton"})
    void loginButtonClicked(ClickEvent e) {
        this.userService.login(this.userNameTextBox.getText(), this.passwordTextBox.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"signUpAnchor"})
    void signUpClicked(ClickEvent e) {
        String registrationLink = EntryPointLinkFactory.createRegistrationLink(Collections.emptyMap());
        Window.open((String)registrationLink, (String)"_blank", (String)"");
    }

    @UiHandler(value={"forgotPasswordAnchor"})
    void forgotPasswordClicked(ClickEvent e) {
        new ForgotPasswordDialog(this.stringMessages, this.userManagementWriteService, this.userService.getCurrentUser()).show();
    }

    static /* synthetic */ StringMessages access$0(LoginView loginView) {
        return loginView.stringMessages;
    }
}

