/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.usergroup.roles;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.UserGroupListDataProvider;
import com.sap.sse.security.ui.client.component.usergroup.roles.RoleDefinitionSuggestOracle;
import com.sap.sse.security.ui.client.component.usergroup.roles.RoleDefinitionTableWrapper;
import com.sap.sse.security.ui.client.component.usergroup.roles.UserGroupRoleResources;
import com.sap.sse.security.ui.client.i18n.StringMessages;

public class GroupRoleDefinitionPanel
extends Composite
implements SelectionChangeEvent.Handler,
ChangeHandler,
KeyUpHandler,
UserGroupListDataProvider.UserGroupListDataProviderChangeHandler {
    private final RoleDefinitionTableWrapper roleDefinitionTableWrapper;
    private final MultiSelectionModel<UserGroupDTO> userGroupSelectionModel;
    private final SuggestBox suggestRole;
    private final UserGroupRoleResources userGroupRoleResources = (UserGroupRoleResources)GWT.create(UserGroupRoleResources.class);
    private final RoleDefinitionSuggestOracle oracle;

    public GroupRoleDefinitionPanel(UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources, MultiSelectionModel<UserGroupDTO> userGroupSelectionModel, UserGroupListDataProvider userGroupListDataProvider) {
        this.userGroupSelectionModel = userGroupSelectionModel;
        VerticalPanel mainPanel = new VerticalPanel();
        this.oracle = new RoleDefinitionSuggestOracle(userService.getUserManagementService(), stringMessages);
        this.suggestRole = new SuggestBox((SuggestOracle)this.oracle);
        this.userGroupRoleResources.css().ensureInjected();
        this.suggestRole.addStyleName(this.userGroupRoleResources.css().roleDefinitionSuggest());
        this.suggestRole.getElement().setPropertyString("placeholder", stringMessages.enterRoleName());
        this.suggestRole.ensureDebugId("RoleSuggestion");
        userGroupListDataProvider.addChangeHandler((UserGroupListDataProvider.UserGroupListDataProviderChangeHandler)this);
        this.roleDefinitionTableWrapper = new RoleDefinitionTableWrapper(userService, stringMessages, errorReporter, true, tableResources, () -> this.updateUserGroups(), userGroupSelectionModel);
        Widget buttonPanel = this.createButtonPanel(userService, stringMessages);
        this.userGroupSelectionModel.addSelectionChangeHandler(event -> {
            UserGroupDTO selectedUserGroup = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)userGroupSelectionModel);
            buttonPanel.setVisible(userService.hasPermission((SecuredDTO)selectedUserGroup, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        });
        mainPanel.add(buttonPanel);
        ScrollPanel scrollPanel = new ScrollPanel(this.roleDefinitionTableWrapper.asWidget());
        LabeledAbstractFilterablePanel userGroupfilterBox = this.roleDefinitionTableWrapper.getFilterField();
        userGroupfilterBox.getElement().setPropertyString("placeholder", stringMessages.filterUserGroups());
        mainPanel.add((Widget)userGroupfilterBox);
        mainPanel.add((Widget)scrollPanel);
        this.initWidget((Widget)mainPanel);
        this.ensureDebugId(this.getClass().getSimpleName());
        this.userGroupSelectionModel.addSelectionChangeHandler(e -> this.updateOracle());
    }

    private void updateOracle() {
        UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel);
        if (selectedObject != null) {
            ((RoleDefinitionSuggestOracle)this.suggestRole.getSuggestOracle()).resetAndRemoveExistingRoles(selectedObject.getRoleDefinitionMap().keySet());
        }
    }

    public void refreshSuggest() {
        this.oracle.refresh();
    }

    private Widget createButtonPanel(UserService userService, StringMessages stringMessages) {
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.USER_GROUP);
        UserManagementWriteServiceAsync userManagementService = userService.getUserManagementWriteService();
        Button addButton = buttonPanel.addUpdateAction(stringMessages.addRole(), () -> {
            StrippedRoleDefinitionDTO role;
            UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel);
            if (selectedObject != null && (role = ((RoleDefinitionSuggestOracle)this.suggestRole.getSuggestOracle()).fromString(this.suggestRole.getValue())) != null) {
                userManagementService.putRoleDefintionToUserGroup(selectedObject.getId().toString(), role.getId().toString(), false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        addButton.ensureDebugId("AddGroupUserButton");
        Button removeButton = buttonPanel.addUpdateAction(stringMessages.removeRole(), () -> {
            Util.Pair selectedRole = (Util.Pair)((RefreshableSingleSelectionModel)this.roleDefinitionTableWrapper.getSelectionModel()).getSelectedObject();
            if (selectedRole == null) {
                Window.alert((String)stringMessages.youHaveToSelectAUserGroup());
            } else if (Window.confirm((String)stringMessages.doYouReallyWantToRemoveRole(((StrippedRoleDefinitionDTO)selectedRole.getA()).getName()))) {
                UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel);
                if (selectedObject != null) {
                    userManagementService.removeRoleDefinitionFromUserGroup(selectedObject.getId().toString(), ((StrippedRoleDefinitionDTO)selectedRole.getA()).getId().toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                } else {
                    Window.alert((String)stringMessages.pleaseSelect());
                }
            }
        });
        ((RefreshableSingleSelectionModel)this.roleDefinitionTableWrapper.getSelectionModel()).addSelectionChangeHandler(event -> removeButton.setEnabled(!((RefreshableSingleSelectionModel)this.roleDefinitionTableWrapper.getSelectionModel()).getSelectedSet().isEmpty()));
        removeButton.setEnabled(false);
        buttonPanel.insertWidgetAtPosition((Widget)this.suggestRole, 0);
        return buttonPanel;
    }

    public void updateUserGroups() {
        this.updateOracle();
        this.roleDefinitionTableWrapper.refreshRoleList();
    }

    public void onChange() {
        this.updateUserGroups();
    }

    public void onKeyUp(KeyUpEvent event) {
        this.updateUserGroups();
    }

    public void onChange(ChangeEvent event) {
        this.updateUserGroups();
    }

    public void onSelectionChange(SelectionChangeEvent event) {
        this.updateUserGroups();
    }

    static /* synthetic */ SuggestBox access$0(GroupRoleDefinitionPanel groupRoleDefinitionPanel) {
        return groupRoleDefinitionPanel.suggestRole;
    }
}

