/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.ArrayList;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.GSASentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.GpsFixStatus;

class GSAParser
extends SentenceParser
implements GSASentence {
    private static final int GPS_MODE = 0;
    private static final int FIX_MODE = 1;
    private static final int FIRST_SV = 2;
    private static final int LAST_SV = 13;
    private static final int POSITION_DOP = 14;
    private static final int HORIZONTAL_DOP = 15;
    private static final int VERTICAL_DOP = 16;

    public GSAParser(String nmea) {
        super(nmea, SentenceId.GSA);
    }

    public GSAParser(TalkerId talker) {
        super(talker, SentenceId.GSA, 17);
    }

    @Override
    public GpsFixStatus getFixStatus() {
        return GpsFixStatus.valueOf(this.getIntValue(1));
    }

    @Override
    public double getHorizontalDOP() {
        return this.getDoubleValue(15);
    }

    @Override
    public FaaMode getMode() {
        return FaaMode.valueOf(this.getCharValue(0));
    }

    @Override
    public double getPositionDOP() {
        return this.getDoubleValue(14);
    }

    @Override
    public String[] getSatelliteIds() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 2;
        while (i <= 13) {
            if (this.hasValue(i)) {
                result.add(this.getStringValue(i));
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public double getVerticalDOP() {
        return this.getDoubleValue(16);
    }

    @Override
    public void setFixStatus(GpsFixStatus status) {
        this.setIntValue(1, status.toInt());
    }

    @Override
    public void setHorizontalDOP(double hdop) {
        this.setDoubleValue(15, hdop, 1, 1);
    }

    @Override
    public void setMode(FaaMode mode) {
        this.setCharValue(0, mode.toChar());
    }

    @Override
    public void setPositionDOP(double pdop) {
        this.setDoubleValue(14, pdop, 1, 1);
    }

    @Override
    public void setSatelliteIds(String[] ids) {
        if (ids.length > 12) {
            throw new IllegalArgumentException("List length exceeded (12)");
        }
        int j = 0;
        int i = 2;
        while (i <= 13) {
            String id = j < ids.length ? ids[j++] : "";
            this.setStringValue(i, id);
            ++i;
        }
    }

    @Override
    public void setVerticalDOP(double vdop) {
        this.setDoubleValue(16, vdop, 1, 1);
    }
}

