/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.text.DecimalFormat;
import net.sf.marineapi.ais.message.AISMessage09;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.PositionInfo;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.TimeStamp;

class AISMessage09Parser
extends AISMessageParser
implements AISMessage09 {
    private static final String SEPARATOR = "\n\t";
    private static final int ALTITUDE = 0;
    private static final int SPEEDOVERGROUND = 1;
    private static final int POSITIONACCURACY = 2;
    private static final int LONGITUDE = 3;
    private static final int LATITUDE = 4;
    private static final int COURSEOVERGROUND = 5;
    private static final int TIMESTAMP = 6;
    private static final int REGIONAL = 7;
    private static final int DTE = 8;
    private static final int SPARE = 9;
    private static final int ASSIGNEDMODEFLAG = 10;
    private static final int RAIMFLAG = 11;
    private static final int RADIOSTATUS = 12;
    private static final int[] FROM = new int[]{38, 50, 60, 61, 89, 116, 128, 134, 142, 43, 146, 147, 149};
    private static final int[] TO = new int[]{50, 60, 61, 89, 116, 128, 134, 142, 43, 146, 147, 149, 167};
    private int fAltitude;
    private int fSOG;
    private boolean fPositionAccuracy;
    private double fLongitude;
    private double fLatitude;
    private int fCOG;
    private int fTimeStamp;
    private int fRegional;
    private boolean fDTE;
    private boolean fAssignedModeFlag;
    private boolean fRAIMFlag;
    private int fRadioStatus;

    public AISMessage09Parser(Sixbit content) {
        super(content);
        if (content.length() != 168) {
            throw new IllegalArgumentException("Wrong message length");
        }
        this.fAltitude = content.getInt(FROM[0], TO[0]);
        this.fSOG = content.getInt(FROM[1], TO[1]);
        this.fPositionAccuracy = content.getBoolean(TO[2]);
        this.fLongitude = Longitude28.toDegrees(content.getAs28BitInt(FROM[3], TO[3]));
        if (!PositionInfo.isLongitudeCorrect(this.fLongitude)) {
            this.fViolations.add(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-180.0, 180.0] + {181}"));
        }
        this.fLatitude = Latitude27.toDegrees(content.getAs27BitInt(FROM[4], TO[4]));
        if (!PositionInfo.isLatitudeCorrect(this.fLatitude)) {
            this.fViolations.add(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-90.0, 90.0] + {91}"));
        }
        this.fCOG = content.getInt(FROM[5], TO[5]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.fViolations.add(new AISRuleViolation("CourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTimeStamp = content.getInt(FROM[6], TO[6]);
        this.fRegional = content.getInt(FROM[7], TO[7]);
        this.fDTE = content.getBoolean(TO[8]);
        this.fAssignedModeFlag = content.getBoolean(TO[10]);
        this.fRAIMFlag = content.getBoolean(TO[11]);
        this.fRadioStatus = content.getInt(FROM[12], TO[12]);
    }

    @Override
    public int getAltitude() {
        return this.fAltitude;
    }

    @Override
    public int getSpeedOverGround() {
        return this.fSOG;
    }

    public String getSOGString() {
        String msg = this.fSOG == 1023 ? "no SOG" : (this.fSOG == 1022 ? ">=1022" : new DecimalFormat("##0.0").format((double)this.fSOG / 10.0));
        return msg;
    }

    @Override
    public boolean getPositionAccuracy() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return this.fLongitude;
    }

    @Override
    public double getLatitudeInDegrees() {
        return this.fLatitude;
    }

    @Override
    public int getCourseOverGround() {
        return this.fCOG;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    public int getRegional() {
        return this.fRegional;
    }

    @Override
    public boolean getDTEFlag() {
        return this.fDTE;
    }

    @Override
    public boolean getAssignedModeFlag() {
        return this.fAssignedModeFlag;
    }

    @Override
    public boolean getRAIMFlag() {
        return this.fRAIMFlag;
    }

    @Override
    public int getRadioStatus() {
        return this.fRadioStatus;
    }

    public String toString() {
        String result = "\tAlt:      " + this.fAltitude;
        result = String.valueOf(result) + "\n\tSOG:     " + this.getSOGString();
        result = String.valueOf(result) + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = String.valueOf(result) + "\n\tLat:     " + PositionInfo.longitudeToString(this.fLongitude);
        result = String.valueOf(result) + "\n\tLon:     " + PositionInfo.latitudeToString(this.fLatitude);
        result = String.valueOf(result) + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = String.valueOf(result) + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        result = String.valueOf(result) + "\n\tRegional:     " + this.getRegional();
        result = String.valueOf(result) + "\n\tDTE: " + (this.fDTE ? "yes" : "no");
        result = String.valueOf(result) + "\n\tAssigned Mode Flag: " + (this.fAssignedModeFlag ? "yes" : "no");
        result = String.valueOf(result) + "\n\tRAIM Flag: " + (this.fRAIMFlag ? "yes" : "no");
        result = String.valueOf(result) + "\n\tRadioStatus:     " + this.getRadioStatus();
        return result;
    }
}

