/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISMessage05;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.PositioningDevice;
import net.sf.marineapi.ais.util.ShipType;
import net.sf.marineapi.ais.util.Sixbit;

class AISMessage05Parser
extends AISMessageParser
implements AISMessage05 {
    private static final String SEPARATOR = "\n\t";
    private static final int AISVERSION = 0;
    private static final int IMONUMBER = 1;
    private static final int CALLSIGN = 2;
    private static final int NAME = 3;
    private static final int TYPEOFSHIPANDCARGO = 4;
    private static final int BOW = 5;
    private static final int STERN = 6;
    private static final int PORT = 7;
    private static final int STARBOARD = 8;
    private static final int TYPEOFEPFD = 9;
    private static final int MONTH = 10;
    private static final int DAY = 11;
    private static final int HOUR = 12;
    private static final int MINUTE = 13;
    private static final int DRAUGHT = 14;
    private static final int DESTINATION = 15;
    private static final int[] FROM = new int[]{30, 40, 70, 112, 232, 240, 249, 258, 264, 270, 274, 278, 283, 288, 294, 302};
    private static final int[] TO = new int[]{40, 70, 112, 232, 240, 249, 258, 264, 270, 274, 278, 283, 288, 294, 302, 422};
    private int fAISVersion;
    private int fIMONumber;
    private String fCallSign;
    private String fName;
    private int fShipAndCargoType;
    private int fBow;
    private int fStern;
    private int fPort;
    private int fStarboard;
    private int fTypeOfEPFD;
    private int fETAMinute;
    private int fETAHour;
    private int fETADay;
    private int fETAMonth;
    private int fMaximumDraught;
    private String fDestination;

    public AISMessage05Parser(Sixbit content) {
        super(content);
        if (content.length() != 424) {
            throw new IllegalArgumentException("Wrong message length");
        }
        this.fAISVersion = content.getInt(FROM[0], TO[0]);
        this.fIMONumber = content.getInt(FROM[1], 1);
        this.fCallSign = content.getString(FROM[2], TO[2]);
        this.fName = content.getString(FROM[3], TO[3]);
        this.fShipAndCargoType = content.getInt(FROM[4], TO[4]);
        this.fBow = content.getInt(FROM[5], TO[5]);
        this.fStern = content.getInt(FROM[6], TO[6]);
        this.fPort = content.getInt(FROM[7], TO[7]);
        this.fStarboard = content.getInt(FROM[8], TO[8]);
        this.fTypeOfEPFD = content.getInt(FROM[9], TO[9]);
        this.fETAMonth = content.getInt(FROM[10], TO[10]);
        this.fETADay = content.getInt(FROM[11], TO[11]);
        this.fETAHour = content.getInt(FROM[12], TO[12]);
        this.fETAMinute = content.getInt(FROM[13], TO[13]);
        this.fMaximumDraught = content.getInt(FROM[14], TO[14]);
        this.fDestination = content.getString(FROM[15], TO[15]);
    }

    @Override
    public int getAISVersionIndicator() {
        return this.fAISVersion;
    }

    @Override
    public int getIMONumber() {
        return this.fIMONumber;
    }

    @Override
    public String getCallSign() {
        return this.fCallSign;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getTypeOfShipAndCargoType() {
        return this.fShipAndCargoType;
    }

    @Override
    public int getBow() {
        return this.fBow;
    }

    @Override
    public int getStern() {
        return this.fStern;
    }

    @Override
    public int getPort() {
        return this.fPort;
    }

    @Override
    public int getStarboard() {
        return this.fStarboard;
    }

    @Override
    public int getTypeOfEPFD() {
        return this.fTypeOfEPFD;
    }

    @Override
    public int getETAMonth() {
        return this.fETAMonth;
    }

    @Override
    public int getETADay() {
        return this.fETADay;
    }

    @Override
    public int getETAHour() {
        return this.fETAHour;
    }

    @Override
    public int getETAMinute() {
        return this.fETAMinute;
    }

    @Override
    public int getMaximumDraught() {
        return this.fMaximumDraught;
    }

    @Override
    public String getDestination() {
        return this.fDestination;
    }

    public String toString() {
        String result = "\tIMO:       " + Integer.toString(this.fIMONumber);
        result = String.valueOf(result) + "\n\tCall sign: " + this.fCallSign;
        result = String.valueOf(result) + "\n\tName:      " + this.fName;
        result = String.valueOf(result) + "\n\tType:      " + ShipType.shipTypeToString(this.fShipAndCargoType);
        String dim = "Bow: " + this.fBow + ", Stern: " + this.fStern + ", Port: " + this.fPort + ", Starboard: " + this.fStarboard + " [m]";
        result = String.valueOf(result) + "\n\tDim:       " + dim;
        result = String.valueOf(result) + "\n\tETA:       Month: " + this.fETAMonth + ", D: " + this.fETADay + ", H: " + this.fETAHour + ", M: " + this.fETAMinute;
        result = String.valueOf(result) + "\n\tDraft:     " + Float.toString((float)this.fMaximumDraught / 10.0f);
        result = String.valueOf(result) + "\n\tEPFD:      " + PositioningDevice.toString(this.fTypeOfEPFD);
        result = String.valueOf(result) + "\n\tDest:      " + this.fDestination;
        return result;
    }
}

