/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.sharing;

import com.sap.sse.common.Base64Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.UriInfo;

public class TokenizedHomePlaceUrlBuilder {
    private static final String EVENT_PATH = "/event";
    private static final String SERIES_PATH = "/series";
    private static final String REGATTA_OVERVIEW_PATH = "/regatta/overview";
    private static final String GWT_PREFIX = "/gwt";
    private static final String HOME_HTML = "/Home.html";
    private static final String STARTOFPARAMS = "/:";
    private static final String STARTOFTOKENPATH = "#";
    private static final String EVENT_ID_PARAM = "eventId";
    private static final String REGATTA_ID_PARAM = "regattaId";
    private static final String LEADERBOARD_GROUP_ID_PARAM = "leaderboardGroupId";
    private URL baseUrl;
    private boolean tokenPresent;

    public TokenizedHomePlaceUrlBuilder(UriInfo uri) {
        URI baseUri = uri.getBaseUri();
        String cleanedUri = baseUri.toString().replace(baseUri.getPath(), "");
        try {
            this.baseUrl = new URL(String.valueOf(cleanedUri) + GWT_PREFIX + HOME_HTML);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public String asEventPlaceLink(String eventId) {
        String url = new String(this.baseUrl.toString());
        url = String.valueOf(url) + "#/event";
        url = String.valueOf(url) + this.buildToken(eventId, EVENT_ID_PARAM);
        return url;
    }

    public String asSeriesPlaceLink(String eventId) {
        String url = new String(this.baseUrl.toString());
        url = String.valueOf(url) + "#/series";
        url = String.valueOf(url) + this.buildToken(eventId, LEADERBOARD_GROUP_ID_PARAM);
        return url;
    }

    public String asRegattaPlaceLink(String eventId, String regattaId) {
        String url = new String(this.baseUrl.toString());
        url = String.valueOf(url) + "#/regatta/overview";
        url = String.valueOf(url) + this.buildToken(eventId, EVENT_ID_PARAM);
        url = String.valueOf(url) + this.buildToken(Base64Utils.toBase64((byte[])regattaId.getBytes()), REGATTA_ID_PARAM);
        return url;
    }

    private String buildToken(String tokenId, String tokenKey) {
        String url = new String();
        if (!this.tokenPresent) {
            url = String.valueOf(url) + STARTOFPARAMS;
            this.tokenPresent = true;
        } else {
            url = String.valueOf(url) + "&";
        }
        url = String.valueOf(url) + tokenKey + "=" + tokenId;
        return url;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }
}

