/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.AbstractJsonHttpServlet;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.ControlPointJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.CourseBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.GateJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.MarkJsonSerializer;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.WaypointJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONObject;

public class CourseJsonExportServlet
extends AbstractJsonHttpServlet {
    private static final long serialVersionUID = -6604797426439916738L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject result;
        String leaderboardName = request.getParameter("leaderboard");
        if (leaderboardName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "leaderboard"));
            return;
        }
        String raceColumnName = request.getParameter("race_column");
        if (raceColumnName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "race_column"));
            return;
        }
        String fleetName = request.getParameter("fleet");
        if (fleetName == null) {
            response.sendError(400, String.format("Missing parameter '%s'.", "fleet"));
            return;
        }
        RacingEventService service = this.getService();
        Leaderboard leaderboard = service.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            response.sendError(404, "No such leaderboard found.");
            return;
        }
        SecurityUtils.getSubject().checkPermission(leaderboard.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
        if (raceColumn == null) {
            response.sendError(404, "No such race column found.");
            return;
        }
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null) {
            response.sendError(404, "No such fleet found.");
            return;
        }
        TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
        if (trackedRace != null) {
            SecurityUtils.getSubject().checkPermission(trackedRace.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ));
            Course course = raceColumn.getRaceDefinition(fleet).getCourse();
            CourseBaseJsonSerializer serializer = new CourseBaseJsonSerializer((JsonSerializer)new WaypointJsonSerializer((JsonSerializer)new ControlPointJsonSerializer((JsonSerializer)new MarkJsonSerializer(), (JsonSerializer)new GateJsonSerializer((JsonSerializer)new MarkJsonSerializer()))));
            result = serializer.serialize((CourseBase)course);
        } else {
            result = new JSONObject();
        }
        this.setJsonResponseHeader(response);
        result.writeJSONString((Writer)response.getWriter());
    }
}

