/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.server.gateway.deserialization.impl.CompareServersResultJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.DataImportProgressJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.MasterDataImportResultJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.RemoteSailingServerReferenceJsonDeserializer;
import com.sap.sailing.server.gateway.interfaces.CompareServersResult;
import com.sap.sailing.server.gateway.interfaces.MasterDataImportResult;
import com.sap.sailing.server.gateway.interfaces.SailingServer;
import com.sap.sse.common.Util;
import com.sap.sse.security.util.impl.SecuredServerImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class SailingServerImpl
extends SecuredServerImpl
implements SailingServer {
    private static final Logger logger = Logger.getLogger(SailingServerImpl.class.getName());
    private final String GATEWAY_URL_PREFIX = "sailingserver/api";

    public SailingServerImpl(URL baseUrl, String bearerToken) {
        super(baseUrl, bearerToken);
    }

    public Iterable<UUID> getLeaderboardGroupIds() throws ClientProtocolException, IOException, ParseException {
        URL leaderboardGroupsUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/leaderboardgroups/identifiable");
        HttpGet getLeaderboardGroups = new HttpGet(leaderboardGroupsUrl.toString());
        JSONArray jsonResponse = (JSONArray)this.getJsonParsedResponse((HttpUriRequest)getLeaderboardGroups).getA();
        return Util.map((Iterable)jsonResponse, o -> UUID.fromString(((JSONObject)o).get((Object)"id").toString()));
    }

    public Iterable<String> getLeaderboardNames() throws Exception {
        URL leaderboardsUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/leaderboards");
        HttpGet getLeaderboards = new HttpGet(leaderboardsUrl.toString());
        Util.Pair jsonParsedResponse = this.getJsonParsedResponse((HttpUriRequest)getLeaderboards);
        JSONArray jsonResponse = (JSONArray)jsonParsedResponse.getA();
        if (jsonResponse == null) {
            throw new IllegalAccessError("Error accessing leaderboard names; response status " + jsonParsedResponse.getB());
        }
        return Util.map((Iterable)jsonResponse, o -> o.toString());
    }

    public String getLeaderboardShardingKey(String leaderboardName) throws Exception {
        return ShardingType.LEADERBOARDNAME.encodeShardingInfo(leaderboardName);
    }

    public String getLeaderboardFromShardingKey(String shardingKey) throws Exception {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String leaderboard : this.getLeaderboardNames()) {
            mapping.put(this.getLeaderboardFromShardingKey(leaderboard), leaderboard);
        }
        return (String)mapping.get(shardingKey);
    }

    public Iterable<UUID> getEventIds() throws ClientProtocolException, IOException, ParseException {
        URL eventsUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/events");
        HttpGet getEvents = new HttpGet(eventsUrl.toString());
        JSONArray jsonResponse = (JSONArray)this.getJsonParsedResponse((HttpUriRequest)getEvents).getA();
        return Util.map((Iterable)jsonResponse, o -> UUID.fromString(((JSONObject)o).get((Object)"id").toString()));
    }

    public MasterDataImportResult importMasterData(SailingServer from, Iterable<UUID> leaderboardGroupIds, boolean override, boolean compress, boolean exportWind, boolean exportDeviceConfigs, boolean exportTrackedRacesAndStartTracking, Optional<UUID> progressTrackingUuid) throws ClientProtocolException, IOException, ParseException {
        MasterDataImportResult result;
        URL mdiUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/masterdataimport");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("remoteServerUrl", from.getBaseUrl().toString()));
        params.add(new BasicNameValuePair("remoteServerBearerToken", from.getBearerToken()));
        for (UUID leaderboardGroupId : leaderboardGroupIds) {
            params.add(new BasicNameValuePair("leaderboardgroupUUID[]", leaderboardGroupId.toString()));
        }
        params.add(new BasicNameValuePair("override", Boolean.toString(override)));
        params.add(new BasicNameValuePair("compress", Boolean.toString(compress)));
        params.add(new BasicNameValuePair("exportWind", Boolean.toString(exportWind)));
        params.add(new BasicNameValuePair("exportDeviceConfigs", Boolean.toString(exportDeviceConfigs)));
        params.add(new BasicNameValuePair("exportTrackedRacesAndStartTracking", Boolean.toString(exportTrackedRacesAndStartTracking)));
        progressTrackingUuid.ifPresent(ptid -> {
            boolean bl = params.add(new BasicNameValuePair("progressTrackingUUID", ptid.toString()));
        });
        HttpPost importMasterData = new HttpPost(mdiUrl.toString());
        importMasterData.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
        Util.Pair responseAndStatus = this.getJsonParsedResponse((HttpUriRequest)importMasterData);
        if ((Integer)responseAndStatus.getB() >= 200 && (Integer)responseAndStatus.getB() < 300) {
            logger.info("Received an OK status " + responseAndStatus.getB() + " for MDI from " + from);
            JSONObject jsonResponse = (JSONObject)responseAndStatus.getA();
            result = new MasterDataImportResultJsonDeserializer().deserialize(jsonResponse);
        } else {
            logger.warning("Received a non-OK status " + responseAndStatus.getB() + " for MDI from " + from);
            result = null;
        }
        return result;
    }

    public DataImportProgress getMasterDataImportProgress(UUID progressTrackingUuid) throws ClientProtocolException, IOException, ParseException {
        URL progressUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/masterdataimport/progress?progressTrackingUuid=" + progressTrackingUuid);
        HttpGet getMasterDataImportProgress = new HttpGet(progressUrl.toString());
        JSONObject jsonResponse = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)getMasterDataImportProgress).getA();
        return new DataImportProgressJsonDeserializer().deserialize(jsonResponse);
    }

    public CompareServersResult compareServers(Optional<SailingServer> a, SailingServer b, Optional<Iterable<UUID>> leaderboardGroupIds) throws ClientProtocolException, IOException, ParseException {
        URL compareServersUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/compareservers");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        a.ifPresent(aa -> {
            params.add(new BasicNameValuePair("bearer1", aa.getBearerToken()));
            params.add(new BasicNameValuePair("server1", aa.getBaseUrl().toString()));
        });
        if (b.getBearerToken() != null) {
            params.add(new BasicNameValuePair("bearer2", b.getBearerToken()));
        }
        params.add(new BasicNameValuePair("server2", b.getBaseUrl().toString()));
        leaderboardGroupIds.ifPresent(lgids -> {
            for (UUID leaderboardGroupId : lgids) {
                params.add(new BasicNameValuePair("leaderboardgroupUUID[]", leaderboardGroupId.toString()));
            }
        });
        HttpPost compareServersPostRequest = new HttpPost(compareServersUrl.toString());
        compareServersPostRequest.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
        JSONObject jsonResponse = (JSONObject)this.getJsonParsedResponse((HttpUriRequest)compareServersPostRequest).getA();
        return new CompareServersResultJsonDeserializer().deserialize(jsonResponse);
    }

    public Iterable<RemoteSailingServerReference> getRemoteServerReferences() throws ClientProtocolException, IOException, ParseException {
        URL getRemoteReferencesUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/remoteserverreference");
        HttpGet getRequest = new HttpGet(getRemoteReferencesUrl.toString());
        JSONArray remoteServerReferencesJson = (JSONArray)this.getJsonParsedResponse((HttpUriRequest)getRequest).getA();
        HashSet<RemoteSailingServerReference> result = new HashSet<RemoteSailingServerReference>();
        for (Object o : remoteServerReferencesJson) {
            RemoteSailingServerReference ref = new RemoteSailingServerReferenceJsonDeserializer().deserialize((JSONObject)o);
            result.add(ref);
        }
        return result;
    }

    public RemoteSailingServerReference addRemoteServerReference(SailingServer referencedServer, boolean includeSpecifiedEvents) throws JsonDeserializationException, ClientProtocolException, IOException, ParseException {
        URL addRemoteReferenceUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/remoteserverreference/add");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("remoteServerUrl", referencedServer.getBaseUrl().toString()));
        params.add(new BasicNameValuePair("remoteServerName", referencedServer.getBaseUrl().toString()));
        params.add(new BasicNameValuePair("include", Boolean.toString(includeSpecifiedEvents)));
        HttpPost addRemoteReference = new HttpPost(addRemoteReferenceUrl.toString());
        addRemoteReference.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
        return new RemoteSailingServerReferenceJsonDeserializer().deserialize((JSONObject)this.getJsonParsedResponse((HttpUriRequest)addRemoteReference).getA());
    }

    public RemoteSailingServerReference removeRemoteServerReference(SailingServer referencedServer) throws JsonDeserializationException, ClientProtocolException, IOException, ParseException {
        HttpPost removeRequest = new HttpPost(new URL(this.getBaseUrl(), "sailingserver/api/v1/remoteserverreference/remove").toString());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("remoteServerUrl", referencedServer.getBaseUrl().toString()));
        removeRequest.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
        Util.Pair responseAndStatus = this.getJsonParsedResponse((HttpUriRequest)removeRequest);
        if ((Integer)responseAndStatus.getB() >= 200 && (Integer)responseAndStatus.getB() < 300) {
            return new RemoteSailingServerReferenceJsonDeserializer().deserialize((JSONObject)responseAndStatus.getA());
        }
        throw new IllegalArgumentException("Received " + responseAndStatus.getA() + " from server with status code " + responseAndStatus.getB());
    }

    public RemoteSailingServerReference addRemoteServerEventReferences(SailingServer referencedServer, Iterable<UUID> eventIds) throws Exception {
        RemoteSailingServerReference result;
        String referencedServerBaseUrl = referencedServer.getBaseUrl().toString();
        RemoteSailingServerReference existingRef = this.getExistingRemoteServerReference(referencedServerBaseUrl);
        if (existingRef == null) {
            URL addRemoteReferenceUrl = new URL(this.getBaseUrl(), "sailingserver/api/v1/remoteserverreference/add");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("remoteServerUrl", referencedServerBaseUrl));
            params.add(new BasicNameValuePair("remoteServerName", referencedServerBaseUrl));
            params.add(new BasicNameValuePair("include", Boolean.toString(true)));
            HttpPost addRemoteReference = new HttpPost(addRemoteReferenceUrl.toString());
            addRemoteReference.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
            result = new RemoteSailingServerReferenceJsonDeserializer().deserialize((JSONObject)this.getJsonParsedResponse((HttpUriRequest)addRemoteReference).getA());
        } else if (existingRef.isInclude()) {
            HashSet eventsToAdd = new HashSet();
            Util.addAll(eventIds, eventsToAdd);
            Util.removeAll((Iterable)existingRef.getSelectedEventIds(), eventsToAdd);
            if (!eventsToAdd.isEmpty()) {
                eventsToAdd.addAll(existingRef.getSelectedEventIds());
                existingRef.updateSelectedEventIds(eventsToAdd);
                this.doRemoteServerReferenceUpdate(existingRef);
                result = existingRef;
            } else {
                result = existingRef;
            }
        } else {
            HashSet eventsToUnexclude = new HashSet();
            Util.addAll(eventIds, eventsToUnexclude);
            Util.retainAll((Iterable)existingRef.getSelectedEventIds(), eventsToUnexclude);
            if (!eventsToUnexclude.isEmpty()) {
                HashSet eventsToExclude = new HashSet(existingRef.getSelectedEventIds());
                Util.removeAll(eventIds, eventsToExclude);
                existingRef.updateSelectedEventIds(eventsToExclude);
                result = this.doRemoteServerReferenceUpdate(existingRef);
            } else {
                result = existingRef;
            }
        }
        return result;
    }

    public RemoteSailingServerReference removeRemoteServerEventReferences(SailingServer referencedServer, Iterable<UUID> eventIds) throws Exception {
        RemoteSailingServerReference result;
        RemoteSailingServerReference existingRef = this.getExistingRemoteServerReference(referencedServer.getBaseUrl().toString());
        if (existingRef != null) {
            if (existingRef.isInclude()) {
                HashSet eventIdsToKeep = new HashSet(existingRef.getSelectedEventIds());
                Util.removeAll(eventIds, eventIdsToKeep);
                if (eventIdsToKeep.isEmpty()) {
                    this.removeRemoteServerReference(referencedServer);
                    result = null;
                } else {
                    existingRef.updateSelectedEventIds(eventIdsToKeep);
                    this.doRemoteServerReferenceUpdate(existingRef);
                    result = existingRef;
                }
            } else if (!Util.containsAll((Iterable)existingRef.getSelectedEventIds(), eventIds)) {
                HashSet extendedEventIdsToExclude = new HashSet(existingRef.getSelectedEventIds());
                Util.addAll(eventIds, extendedEventIdsToExclude);
                existingRef.updateSelectedEventIds(extendedEventIdsToExclude);
                this.doRemoteServerReferenceUpdate(existingRef);
                result = existingRef;
            } else {
                result = existingRef;
            }
        } else {
            result = existingRef;
        }
        return result;
    }

    private RemoteSailingServerReference doRemoteServerReferenceUpdate(RemoteSailingServerReference updatedRef) throws IOException, Exception {
        HttpPut updateRequest = new HttpPut(new URL(this.getBaseUrl(), "sailingserver/api/v1/remoteserverreference/update").toString());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("remoteServerName", updatedRef.getName()));
        params.add(new BasicNameValuePair("include", Boolean.toString(updatedRef.isInclude())));
        for (UUID eventId : updatedRef.getSelectedEventIds()) {
            params.add(new BasicNameValuePair("eventIds", eventId.toString()));
        }
        updateRequest.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(params).build());
        return new RemoteSailingServerReferenceJsonDeserializer().deserialize((JSONObject)this.getJsonParsedResponse((HttpUriRequest)updateRequest).getA());
    }

    private RemoteSailingServerReference getExistingRemoteServerReference(String remoteReferenceServerUrl) throws MalformedURLException, Exception {
        URL remoteReferenceServerUrlAsUrl = new URL(remoteReferenceServerUrl);
        URL remoteReferenceServerUrlWithoutTrailingSlash = remoteReferenceServerUrl.endsWith("/") ? new URL(remoteReferenceServerUrl.substring(0, remoteReferenceServerUrl.length() - 1)) : remoteReferenceServerUrlAsUrl;
        for (RemoteSailingServerReference ref : this.getRemoteServerReferences()) {
            if (!ref.getURL().equals(remoteReferenceServerUrlAsUrl) && !ref.getURL().equals(remoteReferenceServerUrlWithoutTrailingSlash)) continue;
            return ref;
        }
        return null;
    }
}

