/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.stat.distribution.AbstractDistribution;

public class LogisticDistribution
extends AbstractDistribution {
    private static final long serialVersionUID = 1L;
    private static final double PI_SQRT3 = Math.PI / smile.math.Math.sqrt(3.0);
    private static final double PI2_3 = 3.289868133696453;
    private double mu;
    private double scale;

    public LogisticDistribution(double mu, double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Invalid scale: " + scale);
        }
        this.mu = mu;
        this.scale = scale;
    }

    @Override
    public int npara() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double var() {
        return 3.289868133696453 * this.scale * this.scale;
    }

    @Override
    public double sd() {
        return PI_SQRT3 * this.scale;
    }

    @Override
    public double entropy() {
        return smile.math.Math.log(this.scale) + 2.0;
    }

    public String toString() {
        return String.format("Logistic Distribution(%.4f, %.4f)", this.mu, this.scale);
    }

    @Override
    public double rand() {
        return this.inverseTransformSampling();
    }

    @Override
    public double p(double x) {
        double e = smile.math.Math.exp(-(x - this.mu) / this.scale);
        return e / (this.scale * (1.0 + e) * (1.0 + e));
    }

    @Override
    public double logp(double x) {
        return smile.math.Math.log(this.p(x));
    }

    @Override
    public double cdf(double x) {
        double e = smile.math.Math.exp(-(x - this.mu) / this.scale);
        return 1.0 / (1.0 + e);
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException();
        }
        return this.mu + this.scale * smile.math.Math.log(p / (1.0 - p));
    }
}

