/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.Math;
import smile.math.SparseArray;
import smile.math.kernel.MercerKernel;

public class SparsePolynomialKernel
implements MercerKernel<SparseArray> {
    private static final long serialVersionUID = 1L;
    private int degree;
    private double scale;
    private double offset;

    public SparsePolynomialKernel(int degree) {
        this(degree, 1.0, 0.0);
    }

    public SparsePolynomialKernel(int degree, double scale, double offset) {
        if (degree <= 0) {
            throw new IllegalArgumentException("Non-positive polynomial degree.");
        }
        if (offset < 0.0) {
            throw new IllegalArgumentException("Negative offset: the kernel does not satisfy Mercer's condition.");
        }
        this.degree = degree;
        this.scale = scale;
        this.offset = offset;
    }

    public String toString() {
        return String.format("Sparse Polynomial Kernel (scale = %.4f, offset = %.4f)", this.scale, this.offset);
    }

    @Override
    public double k(SparseArray x, SparseArray y) {
        double dot = Math.dot(x, y);
        return Math.pow(this.scale * dot + this.offset, (double)this.degree);
    }
}

