/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.Iterator;
import smile.math.SparseArray;
import smile.math.distance.Metric;

public class SparseManhattanDistance
implements Metric<SparseArray> {
    private static final long serialVersionUID = 1L;
    private double[] weight = null;

    public SparseManhattanDistance() {
    }

    public SparseManhattanDistance(double[] weight) {
        for (int i = 0; i < weight.length; ++i) {
            if (!(weight[i] < 0.0)) continue;
            throw new IllegalArgumentException(String.format("Weight has to be nonnegative: %f", weight[i]));
        }
        this.weight = weight;
    }

    public String toString() {
        if (this.weight != null) {
            return "Weighted Manhattan distance";
        }
        return "Manhattan distance";
    }

    @Override
    public double d(SparseArray x, SparseArray y) {
        if (x.isEmpty()) {
            throw new IllegalArgumentException("List x is empty.");
        }
        if (y.isEmpty()) {
            throw new IllegalArgumentException("List y is empty.");
        }
        Iterator<SparseArray.Entry> iterX = x.iterator();
        Iterator<SparseArray.Entry> iterY = y.iterator();
        SparseArray.Entry a = iterX.hasNext() ? iterX.next() : null;
        SparseArray.Entry b = iterY.hasNext() ? iterY.next() : null;
        double dist = 0.0;
        if (this.weight == null) {
            while (a != null && b != null) {
                if (a.i < b.i) {
                    dist += Math.abs(a.x);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    dist += Math.abs(b.x);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                dist += Math.abs(a.x - b.x);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                dist += Math.abs(a.x);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                dist += Math.abs(b.x);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        } else {
            while (a != null && b != null) {
                if (a.i < b.i) {
                    dist += this.weight[a.i] * Math.abs(a.x);
                    a = iterX.hasNext() ? iterX.next() : null;
                    continue;
                }
                if (a.i > b.i) {
                    dist += this.weight[b.i] * Math.abs(b.x);
                    b = iterY.hasNext() ? iterY.next() : null;
                    continue;
                }
                dist += this.weight[a.i] * Math.abs(a.x - b.x);
                a = iterX.hasNext() ? iterX.next() : null;
                b = iterY.hasNext() ? iterY.next() : null;
            }
            while (a != null) {
                dist += this.weight[a.i] * Math.abs(a.x);
                a = iterX.hasNext() ? iterX.next() : null;
            }
            while (b != null) {
                dist += this.weight[b.i] * Math.abs(b.x);
                b = iterY.hasNext() ? iterY.next() : null;
            }
        }
        return Math.sqrt(dist);
    }
}

