/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb.impl.sessionwrapper;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.sap.sse.security.userstore.mongodb.impl.sessionwrapper.MongoCollectionWrapperWithClientSession;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoDatabaseWrapperWithClientSession
implements MongoDatabase {
    private final MongoDatabase delegate;
    private final ClientSession clientSession;

    public MongoDatabaseWrapperWithClientSession(ClientSession clientSession, MongoDatabase delegate) {
        this.delegate = delegate;
        this.clientSession = clientSession;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    public ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.delegate.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return this.wrap(this.delegate.withCodecRegistry(codecRegistry));
    }

    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return this.wrap(this.delegate.withReadPreference(readPreference));
    }

    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return this.wrap(this.delegate.withWriteConcern(writeConcern));
    }

    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return this.wrap(this.delegate.withReadConcern(readConcern));
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        return new MongoCollectionWrapperWithClientSession<Document>(this.clientSession, this.delegate.getCollection(collectionName));
    }

    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new MongoCollectionWrapperWithClientSession(this.clientSession, this.delegate.getCollection(collectionName, documentClass));
    }

    public Document runCommand(Bson command) {
        return this.delegate.runCommand(command);
    }

    public Document runCommand(Bson command, ReadPreference readPreference) {
        return this.delegate.runCommand(command, readPreference);
    }

    public <TResult> TResult runCommand(Bson command, Class<TResult> resultClass) {
        return (TResult)this.delegate.runCommand(command, resultClass);
    }

    public <TResult> TResult runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        return (TResult)this.delegate.runCommand(command, readPreference, resultClass);
    }

    public Document runCommand(ClientSession clientSession, Bson command) {
        return this.delegate.runCommand(clientSession, command);
    }

    public Document runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference) {
        return this.delegate.runCommand(clientSession, command, readPreference);
    }

    public <TResult> TResult runCommand(ClientSession clientSession, Bson command, Class<TResult> resultClass) {
        return (TResult)this.delegate.runCommand(clientSession, command, resultClass);
    }

    public <TResult> TResult runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        return (TResult)this.delegate.runCommand(clientSession, command, readPreference, resultClass);
    }

    public void drop() {
        this.delegate.drop(this.clientSession);
    }

    public void drop(ClientSession clientSession) {
        this.delegate.drop(clientSession);
    }

    public MongoIterable<String> listCollectionNames() {
        return this.delegate.listCollectionNames(this.clientSession);
    }

    public ListCollectionsIterable<Document> listCollections() {
        return this.delegate.listCollections(this.clientSession);
    }

    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return this.delegate.listCollections(this.clientSession, resultClass);
    }

    public MongoIterable<String> listCollectionNames(ClientSession clientSession) {
        return this.delegate.listCollectionNames(clientSession);
    }

    public ListCollectionsIterable<Document> listCollections(ClientSession clientSession) {
        return this.delegate.listCollections(clientSession);
    }

    public <TResult> ListCollectionsIterable<TResult> listCollections(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.listCollections(clientSession, resultClass);
    }

    public void createCollection(String collectionName) {
        this.delegate.createCollection(this.clientSession, collectionName);
    }

    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions) {
        this.delegate.createCollection(this.clientSession, collectionName, createCollectionOptions);
    }

    public void createCollection(ClientSession clientSession, String collectionName) {
        this.delegate.createCollection(clientSession, collectionName);
    }

    public void createCollection(ClientSession clientSession, String collectionName, CreateCollectionOptions createCollectionOptions) {
        this.delegate.createCollection(clientSession, collectionName, createCollectionOptions);
    }

    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        this.delegate.createView(this.clientSession, viewName, viewOn, pipeline);
    }

    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        this.delegate.createView(this.clientSession, viewName, viewOn, pipeline, createViewOptions);
    }

    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline) {
        this.delegate.createView(clientSession, viewName, viewOn, pipeline);
    }

    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        this.delegate.createView(clientSession, viewName, viewOn, pipeline, createViewOptions);
    }

    public ChangeStreamIterable<Document> watch() {
        return this.delegate.watch(this.clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.delegate.watch(this.clientSession, resultClass);
    }

    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.delegate.watch(this.clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(this.clientSession, pipeline, resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, pipeline, resultClass);
    }

    public AggregateIterable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.delegate.aggregate(this.clientSession, pipeline);
    }

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.aggregate(this.clientSession, pipeline, resultClass);
    }

    public AggregateIterable<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.aggregate(clientSession, pipeline);
    }

    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.aggregate(clientSession, pipeline, resultClass);
    }

    private MongoDatabase wrap(MongoDatabase db) {
        return new MongoDatabaseWrapperWithClientSession(this.clientSession, db);
    }
}

