/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import com.sap.sailing.server.impl.TrackedRegattaListenerManagerImpl;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiBasedTrackedRegattaListener
extends TrackedRegattaListenerManagerImpl {
    private ServiceTracker<TrackedRegattaListener, TrackedRegattaListener> serviceTracker;

    public OSGiBasedTrackedRegattaListener(BundleContext context) {
        this.serviceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, TrackedRegattaListener.class);
        this.serviceTracker.open(true);
    }

    public void close() {
        this.serviceTracker.close();
    }

    private void forEachListener(Consumer<TrackedRegattaListener> consumer) {
        ServiceReference[] serviceReferenceArray = this.serviceTracker.getServiceReferences();
        int n = serviceReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            TrackedRegattaListener listener = (TrackedRegattaListener)this.serviceTracker.getService(serviceReference);
            if (listener != null) {
                consumer.accept(listener);
            }
            ++n2;
        }
    }

    @Override
    public void regattaAdded(TrackedRegatta trackedRegatta) {
        super.regattaAdded(trackedRegatta);
        this.forEachListener(listener -> listener.regattaAdded(trackedRegatta));
    }

    @Override
    public void regattaRemoved(TrackedRegatta trackedRegatta) {
        super.regattaRemoved(trackedRegatta);
        this.forEachListener(listener -> listener.regattaRemoved(trackedRegatta));
    }
}

