/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LeaderboardSearchResultBaseRanker<T extends LeaderboardSearchResultBase>
implements Comparator<T> {
    @Override
    public int compare(T o1, T o2) {
        TrackedRegatta trackedR1 = this.getTrackedRegatta(o1);
        TrackedRegatta trackedR2 = this.getTrackedRegatta(o2);
        int result = trackedR1 == null ? (trackedR2 == null ? o1.getLeaderboard().getName().compareTo(o2.getLeaderboard().getName()) : -1) : (trackedR2 == null ? 1 : this.compareByEarliestStartOfATrackedRace(trackedR1, trackedR2));
        return result;
    }

    protected TimePoint getEarliestTrackedRace(TrackedRegatta trackedRegatta) {
        ArrayList<TimePoint> startOfTrackingTimes = new ArrayList<TimePoint>();
        trackedRegatta.lockTrackedRacesForRead();
        try {
            for (TrackedRace trackedRace : trackedRegatta.getTrackedRaces()) {
                if (trackedRace.getStartOfTracking() == null) continue;
                startOfTrackingTimes.add(trackedRace.getStartOfTracking());
            }
        }
        finally {
            trackedRegatta.unlockTrackedRacesAfterRead();
        }
        TimePoint result = startOfTrackingTimes.isEmpty() ? null : (TimePoint)Collections.min(startOfTrackingTimes);
        return result;
    }

    protected int compareByEarliestStartOfATrackedRace(TrackedRegatta trackedR1, TrackedRegatta trackedR2) {
        assert (trackedR1 != null);
        assert (trackedR2 != null);
        TimePoint earliestTrackedRaceInR1 = this.getEarliestTrackedRace(trackedR1);
        TimePoint earliestTrackedRaceInR2 = this.getEarliestTrackedRace(trackedR2);
        return Util.compareToWithNull((Comparable)earliestTrackedRaceInR1, (Comparable)earliestTrackedRaceInR2, (boolean)false);
    }

    protected TrackedRegatta getTrackedRegatta(T o1) {
        return null;
    }
}

