/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.spectator;

import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardContextDefinition;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.client.HasWelcomeWidget;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.panels.WelcomeWidget;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupFullTableResources;
import com.sap.sailing.gwt.ui.spectator.LeaderboardGroupPanel;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class LeaderboardGroupPanel
extends SimplePanel
implements HasWelcomeWidget {
    private static final AnchorTemplates ANCHORTEMPLATE = (AnchorTemplates)GWT.create(AnchorTemplates.class);
    private static final TextWithClassTemplate TEXTTEMPLATE = (TextWithClassTemplate)GWT.create(TextWithClassTemplate.class);
    private static final ColorBoxTemplate COLORBOXTEMPLATE = (ColorBoxTemplate)GWT.create(ColorBoxTemplate.class);
    private static final String STYLE_NAME_PREFIX = "leaderboardGroupPanel-";
    private static final String STYLE_INACTIVE_RACE = "leaderboardGroupPanel-InactiveRace";
    private static final String STYLE_ACTIVE_RACE = "leaderboardGroupPanel-ActiveRace";
    private static final String STYLE_LIVE_RACE = "leaderboardGroupPanel-LiveRace";
    private static final String STYLE_ACTIVE_LEADERBOARD = "leaderboardGroupPanel-ActiveLeaderboard";
    private static final String STYLE_LEGEND = "leaderboardGroupPanel-Legend";
    private static final String STYLE_TABLE_TEXT = "leaderboardGroupPanel-TableText";
    private static final String STYLE_COLORBOX = "leaderboardGroupPanel-ColorBox";
    private static final String STYLE_BOATCLASS = "leaderboardGroupPanel-BoatClass";
    private static final String STYLE_LEGEND_LIVE = "leaderboardGroupPanel-LegendLive";
    private static final String STYLE_LEGEND_TRACKED = "leaderboardGroupPanel-LegendTracked";
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private LeaderboardGroupDTO leaderboardGroup;
    private Map<String, RegattaDTO> regattasByName;
    private final String viewMode;
    private VerticalPanel mainPanel;
    private Widget welcomeWidget = null;
    private final boolean isEmbedded;
    private final boolean showRaceDetails;
    private final boolean canReplayDuringLiveRaces;
    private final boolean showMapControls;
    private final Timer timerForClientServerOffset;

    public LeaderboardGroupPanel(SailingServiceAsync sailingService, StringMessages stringConstants, ErrorReporter errorReporter, String groupId, String groupName, Consumer<String> headerCallback, String viewMode, boolean embedded, boolean showRaceDetails, boolean canReplayDuringLiveRaces, boolean showMapControls) {
        this.isEmbedded = embedded;
        this.showRaceDetails = showRaceDetails;
        this.showMapControls = showMapControls;
        this.canReplayDuringLiveRaces = canReplayDuringLiveRaces;
        this.sailingService = sailingService;
        this.stringMessages = stringConstants;
        this.errorReporter = errorReporter;
        this.viewMode = viewMode;
        this.setWidth("95%");
        this.regattasByName = new HashMap();
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setWidth("100%");
        this.mainPanel.addStyleName("mainPanel");
        this.add((Widget)this.mainPanel);
        this.timerForClientServerOffset = new Timer(Timer.PlayModes.Replay);
        this.loadLeaderboardGroup(groupId, groupName, headerCallback);
    }

    private void loadLeaderboardGroup(String leaderboardGroupId, String leaderboardGroupName, Consumer<String> callback) {
        long clientTimeWhenRequestWasSent = System.currentTimeMillis();
        this.sailingService.getLeaderboardGroupByUuidOrName(leaderboardGroupId != null ? UUID.fromString(leaderboardGroupId) : null, leaderboardGroupName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPageContent() {
        if (!this.isEmbedded) {
            Label groupNameLabel = new Label(String.valueOf(this.leaderboardGroup.getName()) + ":");
            groupNameLabel.setStyleName("leaderboardGroupPanel-GroupName");
            this.mainPanel.add((Widget)groupNameLabel);
            HTML leaderboardGroupDescriptionLabel = new HTML(new SafeHtmlBuilder().appendEscapedLines(this.leaderboardGroup.getDescription()).toSafeHtml());
            leaderboardGroupDescriptionLabel.setStyleName("leaderboardGroupPanel-GroupDescription");
            this.mainPanel.add((Widget)leaderboardGroupDescriptionLabel);
        }
        FlexTable flexTable = new FlexTable();
        Label leaderboardsLabel = new Label(this.stringMessages.leaderboards());
        leaderboardsLabel.addStyleName("leaderboardGroupPanel-LeaderboardsLabel");
        if (this.leaderboardGroup.hasOverallLeaderboard() && !this.isEmbedded) {
            this.mainPanel.add((Widget)leaderboardsLabel);
        } else {
            flexTable.setWidget(0, 0, (Widget)leaderboardsLabel);
        }
        this.mainPanel.add((Widget)flexTable);
        flexTable.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        HorizontalPanel legendPanel = this.createLegendPanel();
        flexTable.setWidget(0, 1, (Widget)legendPanel);
        if (this.leaderboardGroup.hasOverallLeaderboard()) {
            String link = EntryPointWithSettingsLinkFactory.createLeaderboardLink((LeaderboardContextDefinition)new LeaderboardContextDefinition(String.valueOf(this.leaderboardGroup.getName()) + " " + "Overall", this.stringMessages.overallStandings()), (LeaderboardPerspectiveOwnSettings)new LeaderboardPerspectiveOwnSettings(this.showRaceDetails, this.isEmbedded));
            Anchor overallStandingsLink = new Anchor(this.stringMessages.overallStandings(), true, link);
            overallStandingsLink.setStyleName(STYLE_ACTIVE_LEADERBOARD);
            overallStandingsLink.addStyleName("overallStandings");
            flexTable.setWidget(0, 0, (Widget)overallStandingsLink);
        }
        SafeHtmlCell leaderboardNameCell = new SafeHtmlCell();
        2 leaderboardNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        LeaderboardConfigPanel.AnchorCell nameAnchorCell = new LeaderboardConfigPanel.AnchorCell();
        3 overviewColumn = new /* Unavailable Anonymous Inner Class!! */;
        LeaderboardGroupFullTableResources tableResources = (LeaderboardGroupFullTableResources)GWT.create(LeaderboardGroupFullTableResources.class);
        BaseCelltable leaderboardsTable = new BaseCelltable(10000, (CellTable.Resources)tableResources);
        leaderboardsTable.setSelectionModel((SelectionModel)new NoSelectionModel());
        leaderboardsTable.addColumn((Column)leaderboardNameColumn, this.stringMessages.regatta());
        leaderboardsTable.addColumn((Column)overviewColumn, "");
        if (this.showRaceDetails) {
            SafeHtmlCell racesCell = new SafeHtmlCell();
            4 racesColumn = new /* Unavailable Anonymous Inner Class!! */;
            leaderboardsTable.addColumn((Column)racesColumn, this.stringMessages.races());
        }
        if (this.leaderboardGroup.displayLeaderboardsInReverseOrder) {
            leaderboardsTable.setRowData(this.leaderboardGroup.getLeaderboardsInReverseOrder());
        } else {
            leaderboardsTable.setRowData(this.leaderboardGroup.getLeaderboards());
        }
        flexTable.setWidget(1, 0, (Widget)leaderboardsTable);
        flexTable.getFlexCellFormatter().setColSpan(1, 0, 2);
    }

    private HorizontalPanel createLegendPanel() {
        HorizontalPanel legendPanel = new HorizontalPanel();
        legendPanel.setStyleName(STYLE_LEGEND);
        legendPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        legendPanel.setSpacing(5);
        Label legendLabel = new Label(String.valueOf(this.stringMessages.legend()) + ":");
        legendLabel.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        legendPanel.add((Widget)legendLabel);
        Label inactiveRace = new Label(this.stringMessages.untracked());
        inactiveRace.setStyleName(STYLE_INACTIVE_RACE);
        legendPanel.add((Widget)inactiveRace);
        Label activeRace = new Label(this.stringMessages.tracked());
        activeRace.setStyleName(STYLE_LEGEND_TRACKED);
        legendPanel.add((Widget)activeRace);
        Label liveRace = new Label(this.stringMessages.live());
        liveRace.setStyleName(STYLE_LEGEND_LIVE);
        legendPanel.add((Widget)liveRace);
        return legendPanel;
    }

    private SafeHtml leaderboardStrutureToHtml(StrippedLeaderboardDTO leaderboard) {
        SafeHtmlBuilder b = new SafeHtmlBuilder();
        if (leaderboard.type.isRegattaLeaderboard()) {
            RegattaDTO regatta = (RegattaDTO)this.regattasByName.get(leaderboard.regattaName);
            if (regatta != null) {
                int numberOfSeries = Util.size((Iterable)regatta.series);
                Grid seriesGrid = new Grid(numberOfSeries, 2);
                HTMLTable.CellFormatter seriesGridFormatter = seriesGrid.getCellFormatter();
                int seriesRow = 0;
                for (SeriesDTO series : regatta.series) {
                    if (!"Default".equals(series.getName())) {
                        seriesGrid.setHTML(seriesRow, 0, TEXTTEMPLATE.textWithClass(series.getName(), 50, STYLE_TABLE_TEXT));
                    }
                    seriesGridFormatter.setVerticalAlignment(seriesRow, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                    int numberOfFleets = series.getFleets().size();
                    if (numberOfFleets > 1) {
                        Grid fleetsGrid = new Grid(numberOfFleets, 3);
                        HTMLTable.CellFormatter fleetGridsFormatter = fleetsGrid.getCellFormatter();
                        int fleetRow = 0;
                        for (FleetDTO fleet : series.getFleets()) {
                            Color color = fleet.getColor();
                            if (color != null) {
                                SafeStyles bgStyle = new SafeStylesBuilder().trustedBackgroundColor(color.getAsHtml()).toSafeStyles();
                                fleetsGrid.setHTML(fleetRow, 0, COLORBOXTEMPLATE.colorBox(bgStyle, STYLE_COLORBOX));
                                fleetGridsFormatter.setVerticalAlignment(fleetRow, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                            }
                            fleetsGrid.setHTML(fleetRow, 1, TEXTTEMPLATE.textWithClass(fleet.getName(), 50, STYLE_TABLE_TEXT));
                            fleetGridsFormatter.setVerticalAlignment(fleetRow, 1, HasVerticalAlignment.ALIGN_MIDDLE);
                            List raceColumnsOfSeries = this.getRacesOfFleet(leaderboard, series, fleet);
                            fleetsGrid.setHTML(fleetRow, 2, this.renderRacesToHTml(leaderboard.getName(), raceColumnsOfSeries, fleet));
                            ++fleetRow;
                        }
                        seriesGrid.setWidget(seriesRow, 1, (Widget)fleetsGrid);
                    } else {
                        FleetDTO fleet = (FleetDTO)series.getFleets().get(0);
                        List raceColumnsOfSeries = this.getRacesOfFleet(leaderboard, series, fleet);
                        String displayName = fleet.getName();
                        if (!"Default".equals(fleet.getName())) {
                            Grid fleetsGrid = new Grid(1, 2);
                            HTMLTable.CellFormatter fleetGridsFormatter = fleetsGrid.getCellFormatter();
                            fleetsGrid.setHTML(0, 0, TEXTTEMPLATE.textWithClass(displayName, 50, STYLE_TABLE_TEXT));
                            fleetGridsFormatter.setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
                            fleetsGrid.setHTML(0, 1, this.renderRacesToHTml(leaderboard.getName(), raceColumnsOfSeries, fleet));
                            seriesGrid.setWidget(seriesRow, 1, (Widget)fleetsGrid);
                        } else {
                            seriesGrid.setHTML(seriesRow, 1, this.renderRacesToHTml(leaderboard.getName(), raceColumnsOfSeries, fleet));
                        }
                    }
                    ++seriesRow;
                }
                b.appendHtmlConstant(seriesGrid.getElement().getString());
            }
        } else {
            List raceColumns = leaderboard.getRaceList();
            b.append(this.renderRacesToHTml(leaderboard.getName(), raceColumns, new FleetDTO("Default", 0, null)));
        }
        return b.toSafeHtml();
    }

    private SafeHtml renderRacesToHTml(String leaderboardName, List<RaceColumnDTO> raceColumns, FleetDTO fleet) {
        SafeHtmlBuilder b = new SafeHtmlBuilder();
        for (RaceColumnDTO raceColumn : raceColumns) {
            String raceColumnName = raceColumn.getRaceColumnName();
            RaceDTO race = raceColumn.getRace(fleet);
            this.renderRaceLink(leaderboardName, race, raceColumn.isLive(fleet, this.timerForClientServerOffset.getLiveTimePointInMillis()), raceColumnName, b);
        }
        return b.toSafeHtml();
    }

    private List<RaceColumnDTO> getRacesOfFleet(StrippedLeaderboardDTO leaderboard, SeriesDTO series, FleetDTO fleet) {
        ArrayList<RaceColumnDTO> racesColumnsOfFleet = new ArrayList<RaceColumnDTO>();
        for (RaceColumnDTO raceColumn : series.getRaceColumns()) {
            for (FleetDTO fleetOfRaceColumn : series.getFleets()) {
                if (!fleet.equals((Object)fleetOfRaceColumn)) continue;
                racesColumnsOfFleet.add(leaderboard.getRaceColumnByName(raceColumn.getName()));
            }
        }
        return racesColumnsOfFleet;
    }

    private void renderRaceLink(String leaderboardName, RaceDTO race, boolean isLive, String raceColumnName, SafeHtmlBuilder b) {
        if (race != null) {
            RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier();
            RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), leaderboardName, null, this.leaderboardGroup.getId(), null, this.viewMode);
            RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = RaceBoardPerspectiveOwnSettings.createDefaultWithCanReplayDuringLiveRaces((boolean)this.canReplayDuringLiveRaces);
            Map<String, RaceMapSettings> innerSettings = Collections.singletonMap("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)this.showMapControls));
            PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, innerSettings);
            String link = EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
            if (isLive) {
                b.append(this.getAnchor(link, raceColumnName, STYLE_LIVE_RACE));
            } else if (race.trackedRace.hasGPSData) {
                b.append(this.getAnchor(link, raceColumnName, STYLE_ACTIVE_RACE));
            } else {
                b.append(TEXTTEMPLATE.textWithClass(raceColumnName, STYLE_INACTIVE_RACE));
            }
        } else {
            b.append(TEXTTEMPLATE.textWithClass(raceColumnName, STYLE_INACTIVE_RACE));
        }
    }

    private SafeHtml getAnchor(String link, String linkText, String style) {
        if (this.isEmbedded) {
            return ANCHORTEMPLATE.anchorWithTarget(UriUtils.fromString((String)link), linkText, style, "_blank");
        }
        return ANCHORTEMPLATE.anchor(UriUtils.fromString((String)link), linkText, style);
    }

    public void setWelcomeWidgetVisible(boolean isVisible) {
        if (this.welcomeWidget != null) {
            this.welcomeWidget.setVisible(isVisible);
        }
    }

    public void setWelcomeWidget(WelcomeWidget welcome) {
        boolean needsToBeInserted = this.welcomeWidget == null;
        this.welcomeWidget = welcome;
        if (needsToBeInserted) {
            this.mainPanel.insert(this.welcomeWidget, 0);
        }
    }

    static /* synthetic */ void access$0(LeaderboardGroupPanel leaderboardGroupPanel, LeaderboardGroupDTO leaderboardGroupDTO) {
        leaderboardGroupPanel.leaderboardGroup = leaderboardGroupDTO;
    }

    static /* synthetic */ Timer access$1(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.timerForClientServerOffset;
    }

    static /* synthetic */ LeaderboardGroupDTO access$2(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.leaderboardGroup;
    }

    static /* synthetic */ SailingServiceAsync access$3(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.sailingService;
    }

    static /* synthetic */ Map access$4(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.regattasByName;
    }

    static /* synthetic */ void access$5(LeaderboardGroupPanel leaderboardGroupPanel) {
        leaderboardGroupPanel.createPageContent();
    }

    static /* synthetic */ ErrorReporter access$6(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$7(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.stringMessages;
    }

    static /* synthetic */ TextWithClassTemplate access$8() {
        return TEXTTEMPLATE;
    }

    static /* synthetic */ boolean access$9(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.showRaceDetails;
    }

    static /* synthetic */ boolean access$10(LeaderboardGroupPanel leaderboardGroupPanel) {
        return leaderboardGroupPanel.isEmbedded;
    }

    static /* synthetic */ SafeHtml access$11(LeaderboardGroupPanel leaderboardGroupPanel, String string, String string2, String string3) {
        return leaderboardGroupPanel.getAnchor(string, string2, string3);
    }

    static /* synthetic */ SafeHtml access$12(LeaderboardGroupPanel leaderboardGroupPanel, StrippedLeaderboardDTO strippedLeaderboardDTO) {
        return leaderboardGroupPanel.leaderboardStrutureToHtml(strippedLeaderboardDTO);
    }
}

