/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.streamlets;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.core.client.Duration;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.LatLngBounds;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.events.bounds.BoundsChangeMapHandler;
import com.google.gwt.maps.client.overlays.MapCanvasProjection;
import com.google.gwt.user.client.Timer;
import com.sap.sailing.gwt.ui.simulator.StreamletParameters;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.streamlets.Particle;
import com.sap.sailing.gwt.ui.simulator.streamlets.Swarm;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;
import com.sap.sailing.gwt.ui.simulator.streamlets.VectorField;
import com.sap.sse.common.ColorMapper;
import com.sap.sse.common.ValueRangeFlexibleBoundaries;
import com.sap.sse.gwt.client.player.TimeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Swarm
implements TimeListener {
    private final FullCanvasOverlay fullcanvas;
    private final Canvas canvas;
    private final MapWidget map;
    private StreamletParameters parameters;
    private Timer loopTimer;
    private final VectorField field;
    private boolean zoomChanged = false;
    private Vector diffPx;
    private int nParticles;
    private Particle[] particles;
    private boolean swarmOffScreen = false;
    private int swarmPauseInTicks = 0;
    private Date timePoint;
    private double cosineOfAverageLatitude;
    private final Map<BoundsChangeMapHandler, HandlerRegistration> boundsChangeHandlers = new HashMap();
    private boolean colored = false;
    private final ValueRangeFlexibleBoundaries valueRange;
    private final ColorMapper colorMapper;
    private boolean clearNextFrame = false;
    private Point upperLeftCornerDivPx;
    private Point lowerRightCornerDivPx;
    private static double WINDSPEED_DEFAULT_SPREAD_IN_KNOTS = 0.1;

    public Swarm(FullCanvasOverlay fullcanvas, MapWidget map, com.sap.sse.gwt.client.player.Timer timer, VectorField vectorField, StreamletParameters streamletPars) {
        this.field = vectorField;
        this.fullcanvas = fullcanvas;
        this.canvas = fullcanvas.getCanvas();
        this.map = map;
        timer.addTimeListener((TimeListener)this);
        this.parameters = streamletPars;
        this.timePoint = timer.getTime();
        this.cosineOfAverageLatitude = 1.0;
        this.diffPx = new Vector(0.0, 0.0);
        this.valueRange = new ValueRangeFlexibleBoundaries(0.0, 60.0, 0.15, 0.35);
        this.colorMapper = new ColorMapper(this.valueRange, !this.colored, ColorMapper.ValueSpreader.LINEAR);
    }

    private MapCanvasProjection getMapProjection() {
        return this.fullcanvas.getMapProjection();
    }

    public void start(int animationIntervalMillis) {
        this.removeBoundsChangeHandler();
        this.fullcanvas.setCanvasSettings();
        if (this.loopTimer == null) {
            this.loopTimer = new /* Unavailable Anonymous Inner Class!! */;
        }
        if (this.map.getBounds() != null) {
            this.startSwarmIfNecessaryAndUpdateProjection();
            this.loopTimer.schedule(0);
        }
        2 handler = new /* Unavailable Anonymous Inner Class!! */;
        this.boundsChangeHandlers.put(handler, this.map.addBoundsChangeHandler((BoundsChangeMapHandler)handler));
    }

    private void startSwarmIfNecessaryAndUpdateProjection() {
        this.updateBounds();
        if (this.particles == null) {
            this.createParticles();
        } else {
            this.clearNextFrame = true;
        }
    }

    private void updateSwarmOneTick(int animationIntervalMillis) {
        double time0 = Duration.currentTimeMillis();
        if (this.swarmPauseInTicks > 1) {
            --this.swarmPauseInTicks;
        } else if (this.swarmPauseInTicks == 1) {
            this.startSwarmIfNecessaryAndUpdateProjection();
            if (this.zoomChanged) {
                this.diffPx = new Vector(0.0, 0.0);
                this.recycleParticles();
                this.zoomChanged = false;
            } else {
                this.diffPx = this.fullcanvas.getDiffPx();
            }
            this.swarmPauseInTicks = 0;
        }
        if (!this.swarmOffScreen && this.swarmPauseInTicks == 0) {
            this.execute(this.diffPx);
            this.diffPx = new Vector(0.0, 0.0);
        }
        double time1 = Duration.currentTimeMillis();
        double timeDelta = time1 - time0;
        this.loopTimer.schedule((int)Math.max(10.0, (double)animationIntervalMillis - timeDelta));
    }

    private void removeBoundsChangeHandler() {
        for (HandlerRegistration reg : this.boundsChangeHandlers.values()) {
            reg.removeHandler();
        }
        this.boundsChangeHandlers.clear();
    }

    public void stop() {
        this.removeBoundsChangeHandler();
        this.clearCanvas();
        this.loopTimer.cancel();
    }

    private Particle recycleOrCreateParticle(Particle particle) {
        boolean done = false;
        int attempts = 10;
        while (!done && attempts-- > 0) {
            LatLng newRandomPosition = this.getRandomPosition();
            if (this.field.inBounds(newRandomPosition)) {
                Vector v = this.field.getVector(newRandomPosition, this.timePoint);
                double weight = this.field.getParticleWeight(newRandomPosition, v);
                if (weight >= Math.random()) {
                    if (particle == null) {
                        particle = new Particle();
                    }
                    particle.currentPosition = newRandomPosition;
                    particle.stepsToLive = v == null || v.length() == 0.0 ? 0 : 1 + (int)Math.round(Math.random() * 40.0);
                    particle.previousPixelCoordinate = particle.currentPixelCoordinate = new Vector(this.getMapProjection().fromLatLngToContainerPixel(particle.currentPosition));
                    particle.v = v;
                    done = true;
                    continue;
                }
                particle = null;
                continue;
            }
            particle = null;
        }
        return particle;
    }

    private LatLng getRandomPosition() {
        double rndY = Math.random();
        double rndX = Math.random();
        double yPx = rndY * this.lowerRightCornerDivPx.getY() + (1.0 - rndY) * this.upperLeftCornerDivPx.getY();
        double xPx = rndX * this.upperLeftCornerDivPx.getX() + (1.0 - rndX) * this.lowerRightCornerDivPx.getX();
        LatLng result = this.getMapProjection().fromDivPixelToLatLng(Point.newInstance((double)xPx, (double)yPx));
        return result;
    }

    private void recycleParticles() {
        int idx = 0;
        while (idx < this.particles.length) {
            this.particles[idx] = this.recycleOrCreateParticle(this.particles[idx]);
            ++idx;
        }
    }

    private void createParticles() {
        this.particles = new Particle[this.nParticles];
        this.recycleParticles();
    }

    public void onBoundsChanged(boolean zoomChanged, int swarmPause) {
        this.zoomChanged |= zoomChanged;
        if (this.zoomChanged) {
            this.clearCanvas();
        } else {
            this.fullcanvas.setCanvasSettings();
        }
        this.swarmPauseInTicks = swarmPause;
    }

    private void clearCanvas() {
        double w = this.canvas.getOffsetWidth();
        double h = this.canvas.getOffsetHeight();
        Context2d g = this.canvas.getContext2d();
        g.clearRect(0.0, 0.0, w, h);
    }

    private void updateBounds() {
        if (this.getMapProjection() != null) {
            LatLngBounds mapBounds;
            int canvasWidth = this.fullcanvas.getMap().getDiv().getClientWidth();
            int canvasHeight = this.fullcanvas.getMap().getDiv().getClientHeight();
            LatLng upperLeftCornerLatLng = this.getMapProjection().fromContainerPixelToLatLng(Point.newInstance((double)0.0, (double)0.0));
            this.upperLeftCornerDivPx = this.getMapProjection().fromLatLngToDivPixel(upperLeftCornerLatLng);
            LatLng lowerRightCornerLatLng = this.getMapProjection().fromContainerPixelToLatLng(Point.newInstance((double)canvasWidth, (double)canvasHeight));
            this.lowerRightCornerDivPx = this.getMapProjection().fromLatLngToDivPixel(lowerRightCornerLatLng);
            LatLngBounds fieldBounds = this.field.getFieldCorners();
            this.swarmOffScreen = !fieldBounds.intersects(mapBounds = this.map.getBounds());
            int newNParticles = (int)Math.round(Math.sqrt(canvasWidth * canvasHeight) * this.field.getParticleFactor() * this.parameters.swarmScale);
            if (newNParticles > this.nParticles) {
                this.nParticles = newNParticles;
                this.createParticles();
            }
            this.nParticles = newNParticles;
            this.cosineOfAverageLatitude = Math.cos((lowerRightCornerLatLng.getLatitude() / 180.0 * Math.PI + upperLeftCornerLatLng.getLatitude() / 180.0 * Math.PI) / 2.0);
        }
    }

    private void drawSwarm() {
        Context2d ctxt = this.canvas.getContext2d();
        ctxt.setGlobalAlpha(0.06);
        if (this.clearNextFrame) {
            this.clearNextFrame = false;
        } else {
            ctxt.setGlobalCompositeOperation("destination-out");
            ctxt.setFillStyle("black");
            ctxt.fillRect(0.0, 0.0, (double)this.canvas.getOffsetWidth(), (double)this.canvas.getOffsetHeight());
            ctxt.setGlobalAlpha(1.0);
            ctxt.setGlobalCompositeOperation("source-over");
            ctxt.setFillStyle("white");
            int idx = 0;
            while (idx < this.nParticles && idx < this.particles.length) {
                Particle particle = this.particles[idx];
                if (particle != null && particle.stepsToLive != 0) {
                    double particleSpeed = particle.v == null ? 0.0 : particle.v.length();
                    ctxt.setLineWidth(this.field.getLineWidth(particleSpeed));
                    ctxt.setStrokeStyle(this.colorMapper.getColor(particleSpeed));
                    ctxt.beginPath();
                    ctxt.moveTo(particle.previousPixelCoordinate.x, particle.previousPixelCoordinate.y);
                    ctxt.lineTo(particle.currentPixelCoordinate.x, particle.currentPixelCoordinate.y);
                    ctxt.stroke();
                }
                ++idx;
            }
        }
    }

    public void setColors(boolean isColored) {
        this.colored = isColored;
        this.colorMapper.setGrey(!isColored);
    }

    public boolean isColored() {
        return this.colored;
    }

    private boolean execute(Vector diffPx) {
        double minSpeedInKnots = 120.0;
        double maxSpeedInKnots = 0.0;
        double speed = this.field.getMotionScale(this.map.getZoom());
        int idx = 0;
        while (idx < this.particles.length && idx < this.nParticles) {
            Particle particle = this.particles[idx];
            if (particle != null && particle.stepsToLive > 0 && particle.v != null) {
                particle.previousPixelCoordinate = particle.currentPixelCoordinate;
                if (diffPx.x != 0.0) {
                    particle.previousPixelCoordinate.x += diffPx.x;
                }
                if (diffPx.y != 0.0) {
                    particle.previousPixelCoordinate.y += diffPx.y;
                }
                double latDeg = particle.currentPosition.getLatitude() + speed * particle.v.y;
                double lngDeg = particle.currentPosition.getLongitude() + speed * particle.v.x / this.cosineOfAverageLatitude;
                particle.currentPosition = LatLng.newInstance((double)latDeg, (double)lngDeg);
                particle.currentPixelCoordinate = new Vector(this.getMapProjection().fromLatLngToContainerPixel(particle.currentPosition));
                --particle.stepsToLive;
                particle.v = particle.stepsToLive > 0 && this.field.inBounds(particle.currentPosition) ? this.field.getVector(particle.currentPosition, this.timePoint) : null;
            } else {
                this.particles[idx] = this.recycleOrCreateParticle(this.particles[idx]);
            }
            if (this.particles[idx] != null && this.particles[idx].v != null) {
                double length = this.particles[idx].v.length();
                if (length > maxSpeedInKnots) {
                    maxSpeedInKnots = length;
                }
                if (length < minSpeedInKnots) {
                    minSpeedInKnots = length;
                }
            }
            ++idx;
        }
        if (minSpeedInKnots <= maxSpeedInKnots) {
            if (Math.abs(maxSpeedInKnots - minSpeedInKnots) <= WINDSPEED_DEFAULT_SPREAD_IN_KNOTS) {
                this.valueRange.setMinMax(minSpeedInKnots - WINDSPEED_DEFAULT_SPREAD_IN_KNOTS, maxSpeedInKnots + WINDSPEED_DEFAULT_SPREAD_IN_KNOTS);
            } else {
                this.valueRange.setMinMax(minSpeedInKnots, maxSpeedInKnots);
            }
        }
        this.drawSwarm();
        return true;
    }

    public ValueRangeFlexibleBoundaries getValueRange() {
        return this.valueRange;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public void timeChanged(Date newTime, Date oldTime) {
        this.timePoint = newTime;
    }

    public void pause(int swarmPauseInTicks) {
        this.swarmPauseInTicks = swarmPauseInTicks;
    }

    static /* synthetic */ void access$0(Swarm swarm, int n) {
        swarm.updateSwarmOneTick(n);
    }

    static /* synthetic */ void access$1(Swarm swarm) {
        swarm.startSwarmIfNecessaryAndUpdateProjection();
    }

    static /* synthetic */ Timer access$2(Swarm swarm) {
        return swarm.loopTimer;
    }
}

