/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButtonPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagModificationPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sse.security.ui.client.UserService;

public class TagFooterPanel
extends FlowPanel {
    private final TaggingComponent taggingComponent;
    private final TagModificationPanel tagModificationPanel;
    private final TagButtonPanel tagButtonPanel;

    protected TagFooterPanel(TaggingComponent taggingComponent, SailingServiceAsync sailingService, StringMessages stringMessages, UserService userService, RaceIdentifier raceIdentifier) {
        this.taggingComponent = taggingComponent;
        this.tagModificationPanel = new TagModificationPanel(taggingComponent, this, sailingService, stringMessages, userService, raceIdentifier);
        this.tagButtonPanel = new TagButtonPanel(taggingComponent, this, stringMessages, userService);
        this.setTagButtonsVisibility(true);
        this.setInputFieldsVisibility(false);
        this.tagButtonPanel.loadAllTagButtons();
    }

    protected void setInputFieldsVisibility(boolean visible) {
        if (visible) {
            this.add((Widget)this.tagModificationPanel);
        } else {
            this.remove((Widget)this.tagModificationPanel);
        }
    }

    protected void setTagButtonsVisibility(boolean visible) {
        if (visible && this.taggingComponent.getTagButtons().size() > 0) {
            this.add((Widget)this.tagButtonPanel);
        } else {
            this.remove((Widget)this.tagButtonPanel);
        }
    }

    protected void setCurrentState(TaggingComponent.State state) {
        if (state == TaggingComponent.State.CREATE_TAG) {
            this.setInputFieldsVisibility(true);
            this.setTagButtonsVisibility(true);
            this.tagModificationPanel.setCurrentStatus(state);
        } else if (state == TaggingComponent.State.EDIT_TAG) {
            this.setInputFieldsVisibility(true);
            this.setTagButtonsVisibility(false);
            this.tagModificationPanel.setCurrentStatus(state);
        } else {
            this.setInputFieldsVisibility(false);
            this.setTagButtonsVisibility(true);
            this.tagModificationPanel.setCurrentStatus(state);
        }
    }

    protected void recalculateHeight() {
        this.tagButtonPanel.recalculateHeight();
    }

    protected void loadAllTagButtons() {
        this.tagButtonPanel.loadAllTagButtons();
    }

    protected void storeAllTagButtons() {
        this.tagButtonPanel.storeAllTagButtons();
    }
}

