/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.authentication.SailingAuthenticationEntryPointLinkFactory;
import com.sap.sailing.gwt.common.client.NavigatorUtil;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.client.CompetitorColorProvider;
import com.sap.sailing.gwt.ui.client.CompetitorColorProviderImpl;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.EntryPointLinkFactory;
import com.sap.sailing.gwt.ui.client.FlagImageResolverImpl;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.RaceCompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.RaceTimePanel;
import com.sap.sailing.gwt.ui.client.RaceTimePanelLifecycle;
import com.sap.sailing.gwt.ui.client.RaceTimePanelSettings;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerLifecycle;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManager;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerManagerComponent;
import com.sap.sailing.gwt.ui.client.media.MediaPlayerSettings;
import com.sap.sailing.gwt.ui.client.media.PopupPositionProvider;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPassingsPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.EditMarkPositionPanel;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChart;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorRaceChartSettings;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChart;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartLifecycle;
import com.sap.sailing.gwt.ui.client.shared.charts.WindChartSettings;
import com.sap.sailing.gwt.ui.client.shared.filter.CompetitorsFilterSets;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardFetcher;
import com.sap.sailing.gwt.ui.client.shared.filter.LeaderboardWithSecurityFetcher;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceCompetitorSet;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapLifecycle;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableLifecycle;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTablePanel;
import com.sap.sailing.gwt.ui.client.shared.racemap.maneuver.ManeuverTableSettings;
import com.sap.sailing.gwt.ui.leaderboard.ClassicLeaderboardStyle;
import com.sap.sailing.gwt.ui.leaderboard.CompetitorFilterPanel;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.QuickFlagDataFromLeaderboardDTOProvider;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardAuthenticationView;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardLoginHintPopup;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPanel;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPerspectiveLifecycle;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPerspectiveSettingsDialogComponent;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardResources;
import com.sap.sailing.gwt.ui.raceboard.RaceboardDropdownResources;
import com.sap.sailing.gwt.ui.raceboard.ShareLinkDialog;
import com.sap.sailing.gwt.ui.raceboard.SideBySideComponentViewer;
import com.sap.sailing.gwt.ui.raceboard.SingleRaceLeaderboardPanelLifecycle;
import com.sap.sailing.gwt.ui.raceboard.SliceRaceHandler;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sailing.gwt.ui.shared.TrackingConnectorInfoDTO;
import com.sap.sailing.gwt.ui.shared.databylogo.DataByLogo;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.FilterSet;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.AbstractSettings;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.controls.dropdown.Dropdown;
import com.sap.sse.gwt.client.controls.dropdown.DropdownResources;
import com.sap.sse.gwt.client.controls.slider.TimeSlider;
import com.sap.sse.gwt.client.formfactor.DeviceDetector;
import com.sap.sse.gwt.client.panels.ResizableFlowPanel;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomModel;
import com.sap.sse.gwt.client.player.TimeRangeWithZoomProvider;
import com.sap.sse.gwt.client.player.TimeZoomChangeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.LinkWithSettingsGenerator;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.AbstractPerspectiveComposite;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveLifecycle;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.gwt.client.useragent.UserAgentDetails;
import com.sap.sse.gwt.common.CommonSharedResources;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.authentication.generic.GenericAuthentication;
import com.sap.sse.security.ui.authentication.view.AuthenticationMenuView;
import com.sap.sse.security.ui.authentication.view.AuthenticationMenuViewImpl;
import com.sap.sse.security.ui.authentication.view.FlyoutAuthenticationView;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class RaceBoardPanel
extends AbstractPerspectiveComposite<RaceBoardPerspectiveLifecycle, RaceBoardPerspectiveOwnSettings>
implements LeaderboardUpdateListener,
PopupPositionProvider,
RequiresResize {
    public static final String RACEBOARD_PATH = "/gwt/RaceBoard.html";
    private final SailingServiceAsync sailingService;
    private SailingServiceWriteAsync sailingServiceWrite;
    private final MediaServiceAsync mediaService;
    private final MediaServiceWriteAsync mediaServiceWrite;
    private final UUID eventId;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private String raceBoardName;
    private final RaceTimePanel racetimePanel;
    private final Timer timer;
    private final UserAgentDetails userAgent;
    private final RaceCompetitorSelectionProvider competitorSelectionProvider;
    private final TimeRangeWithZoomModel timeRangeWithZoomModel;
    private final RegattaAndRaceIdentifier selectedRaceIdentifier;
    private final String leaderboardName;
    private final SingleRaceLeaderboardPanel leaderboardPanel;
    private WindChart windChart;
    private MultiCompetitorRaceChart competitorChart;
    private MediaPlayerManagerComponent mediaPlayerManagerComponent;
    private EditMarkPassingsPanel editMarkPassingPanel;
    private EditMarkPositionPanel editMarkPositionPanel;
    private final TaggingComponent taggingComponent;
    private final DockLayoutPanel dockPanel;
    private final ResizableFlowPanel timePanelWrapper;
    private static final int TIMEPANEL_COLLAPSED_HEIGHT = 67;
    private static final int TIMEPANEL_EXPANDED_HEIGHT = 96;
    private SideBySideComponentViewer mapViewer;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final RaceTimesInfoProvider raceTimesInfoProvider;
    private final RaceMap raceMap;
    private final FlowPanel racePicker;
    private final FlowPanel regattaAndRaceTimeInformationHeader;
    private final AuthenticationMenuView userManagementMenuView;
    private boolean currentRaceHasBeenSelectedOnce;
    private final RaceBoardResources raceBoardResources = RaceBoardResources.INSTANCE;
    private final RaceBoardResources.RaceBoardMainCss mainCss = this.raceBoardResources.mainCss();
    private final QuickFlagDataFromLeaderboardDTOProvider quickFlagDataProvider;
    private ManeuverTablePanel maneuverTablePanel;
    private static final RaceMapResources raceMapResources = (RaceMapResources)GWT.create(RaceMapResources.class);
    private TrackingConnectorInfoDTO trackingConnectorInfo;
    private CompetitorFilterPanel competitorSearchTextBox;
    private final RaceboardContextDefinition raceboardContextDefinition;

    public RaceBoardPanel(Component<?> parent, ComponentContext<PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings>> componentContext, RaceBoardPerspectiveLifecycle lifecycle, PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> settings, SailingServiceAsync sailingService, MediaServiceAsync mediaService, MediaServiceWriteAsync mediaServiceWrite, AsyncActionsExecutor asyncActionsExecutor, Map<CompetitorDTO, BoatDTO> competitorsAndTheirBoats, Timer timer, RegattaAndRaceIdentifier selectedRaceIdentifier, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, UUID eventId, ErrorReporter errorReporter, StringMessages stringMessages, UserAgentDetails userAgent, RaceTimesInfoProvider raceTimesInfoProvider, boolean showChartMarkEditMediaButtonsAndVideo, boolean showHeaderPanel, Iterable<DetailType> availableDetailTypes, StrippedLeaderboardDTO leaderboardDTO, RaceWithCompetitorsAndBoatsDTO raceDTO, TrackingConnectorInfoDTO trackingConnectorInfo, SailingServiceWriteAsync sailingServiceWrite, RaceboardContextDefinition raceboardContextDefinition, WithSecurity withSecurity) {
        super(parent, componentContext, (PerspectiveLifecycle)lifecycle, settings);
        this.sailingService = sailingService;
        this.sailingServiceWrite = sailingServiceWrite;
        this.mediaService = mediaService;
        this.mediaServiceWrite = mediaServiceWrite;
        this.stringMessages = stringMessages;
        this.raceTimesInfoProvider = raceTimesInfoProvider;
        this.errorReporter = errorReporter;
        this.userAgent = userAgent;
        this.timer = timer;
        this.eventId = eventId;
        this.trackingConnectorInfo = trackingConnectorInfo;
        this.currentRaceHasBeenSelectedOnce = false;
        this.leaderboardName = leaderboardName;
        this.selectedRaceIdentifier = selectedRaceIdentifier;
        this.setRaceBoardName(selectedRaceIdentifier.getRaceName());
        this.asyncActionsExecutor = asyncActionsExecutor;
        RaceBoardPerspectiveOwnSettings parsedPerspectiveOwnSettings = (RaceBoardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings();
        this.raceboardContextDefinition = raceboardContextDefinition;
        ResizableFlowPanel mainPanel = new ResizableFlowPanel();
        mainPanel.setSize("100%", "100%");
        this.racePicker = new FlowPanel();
        this.racePicker.setStyleName("RegattaRaceInformation-Header");
        this.regattaAndRaceTimeInformationHeader = new FlowPanel();
        this.regattaAndRaceTimeInformationHeader.setStyleName("RegattaAndRaceTime-Header");
        this.regattaAndRaceTimeInformationHeader.getElement().getStyle().setProperty("pointerEvents", "auto");
        Runnable shareLinkAction = null;
        if (raceboardContextDefinition != null) {
            RaceboardContextDefinition strippedRaceBoardContextDefinition = new RaceboardContextDefinition(raceboardContextDefinition.getRegattaName(), raceboardContextDefinition.getRaceName(), raceboardContextDefinition.getLeaderboardName(), raceboardContextDefinition.getLeaderboardGroupName(), raceboardContextDefinition.getLeaderboardGroupId(), raceboardContextDefinition.getEventId(), null);
            LinkWithSettingsGenerator linkWithSettingsGenerator = new LinkWithSettingsGenerator(RACEBOARD_PATH, new GenericSerializableSettings[]{strippedRaceBoardContextDefinition});
            if (showChartMarkEditMediaButtonsAndVideo) {
                shareLinkAction = () -> {
                    ShareLinkDialog shareLinkDialog = new ShareLinkDialog(RACEBOARD_PATH, (PerspectiveLifecycle)lifecycle, this.getSettings(), sailingService, stringMessages, linkWithSettingsGenerator);
                    shareLinkDialog.initLinkAndShow();
                };
            } else if (NavigatorUtil.clientHasNavigatorShareSupport()) {
                shareLinkAction = () -> NavigatorUtil.shareUrl((String)linkWithSettingsGenerator.createUrl((Settings)this.getSettings()), null);
            } else if (NavigatorUtil.clientHasNavigatorCopyToClipboardSupport()) {
                shareLinkAction = () -> NavigatorUtil.copyToClipboard((String)linkWithSettingsGenerator.createUrl((Settings)this.getSettings()));
            }
        }
        this.userManagementMenuView = new AuthenticationMenuViewImpl(new Anchor(), this.mainCss.usermanagement_loggedin(), this.mainCss.usermanagement_open(), this.mainCss.user_menu_premium());
        this.userManagementMenuView.asWidget().setStyleName(this.mainCss.usermanagement_icon());
        this.userManagementMenuView.asWidget().getElement().getStyle().setProperty("pointerEvents", "auto");
        this.userManagementMenuView.asWidget().getElement().getStyle().setProperty("display", "inline-block");
        this.userManagementMenuView.asWidget().getElement().getStyle().setProperty("position", "relative");
        this.userManagementMenuView.asWidget().getElement().getStyle().setProperty("top", "0px");
        this.userManagementMenuView.asWidget().getElement().getStyle().setProperty("right", "0px");
        this.timeRangeWithZoomModel = new TimeRangeWithZoomModel();
        CompetitorColorProviderImpl colorProvider = new CompetitorColorProviderImpl(selectedRaceIdentifier, competitorsAndTheirBoats);
        this.competitorSelectionProvider = new RaceCompetitorSelectionModel(true, (CompetitorColorProvider)colorProvider, competitorsAndTheirBoats);
        raceMapResources.raceMapStyle().ensureInjected();
        PaywallResolverImpl paywallResolverRace = new PaywallResolverImpl(withSecurity.getUserService(), withSecurity.getSubscriptionServiceFactory());
        RaceMapLifecycle raceMapLifecycle = new RaceMapLifecycle(stringMessages, (PaywallResolver)paywallResolverRace, (SecuredDTO)raceDTO);
        RaceMapSettings defaultRaceMapSettings = (RaceMapSettings)settings.findSettingsByComponentId(raceMapLifecycle.getComponentId());
        RaceTimePanelLifecycle raceTimePanelLifecycle = lifecycle.getRaceTimePanelLifecycle();
        RaceTimePanelSettings raceTimePanelSettings = (RaceTimePanelSettings)settings.findSettingsByComponentId(raceTimePanelLifecycle.getComponentId());
        RaceCompetitorSet raceCompetitorSet = new RaceCompetitorSet(this.competitorSelectionProvider);
        this.quickFlagDataProvider = new QuickFlagDataFromLeaderboardDTOProvider(raceCompetitorSet, (RaceIdentifier)selectedRaceIdentifier);
        this.raceMap = new /* Unavailable Anonymous Inner Class!! */;
        if (defaultRaceMapSettings.isBuoyZoneRadiusDefaultValue()) {
            sailingService.getRegattaByName(selectedRaceIdentifier.getRegattaName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.competitorSearchTextBox = new CompetitorFilterPanel((CompetitorSelectionProvider)this.competitorSelectionProvider, stringMessages, this.raceMap, (LeaderboardFetcher)new /* Unavailable Anonymous Inner Class!! */, (RaceIdentifier)selectedRaceIdentifier, withSecurity.getUserService().getStorage());
        this.raceMap.getHeaderPanel().add((Widget)this.racePicker);
        FlowPanel filler = new FlowPanel();
        filler.setStyleName("RaceMap-Header-Filler");
        this.raceMap.getHeaderPanel().add((Widget)filler);
        this.raceMap.getHeaderPanel().add((Widget)this.regattaAndRaceTimeInformationHeader);
        FlowPanel userManagementMenuPanel = new FlowPanel();
        userManagementMenuPanel.addStyleName("AuthenticationButton");
        userManagementMenuPanel.add((IsWidget)this.userManagementMenuView);
        this.raceMap.getHeaderPanel().add((Widget)userManagementMenuPanel);
        this.addChildComponent((Component)this.raceMap);
        String sharedTagURLParameter = parsedPerspectiveOwnSettings.getJumpToTag();
        String sharedTagTitle = null;
        MillisecondsTimePoint sharedTagTimePoint = null;
        boolean showTaggingComponent = false;
        if (sharedTagURLParameter != null) {
            showTaggingComponent = true;
            int indexOfSeperator = sharedTagURLParameter.indexOf(",");
            if (indexOfSeperator != -1) {
                try {
                    sharedTagTimePoint = new MillisecondsTimePoint(Long.parseLong(sharedTagURLParameter.substring(0, indexOfSeperator)));
                    sharedTagTitle = sharedTagURLParameter.substring(indexOfSeperator + 1, sharedTagURLParameter.length());
                }
                catch (NumberFormatException nfe) {
                    GWT.log((String)"Problem extracting tag time point from URL parameter tag", (Throwable)nfe);
                }
            }
        }
        this.taggingComponent = new TaggingComponent(parent, componentContext, stringMessages, sailingService, withSecurity.getUserService(), timer, raceTimesInfoProvider, sharedTagTimePoint, sharedTagTitle, leaderboardDTO, sailingServiceWrite, (RaceIdentifier)selectedRaceIdentifier);
        this.addChildComponent((Component)this.taggingComponent);
        this.taggingComponent.setVisible(showTaggingComponent);
        boolean isScreenLargeEnoughToInitiallyDisplayLeaderboard = Document.get().getClientWidth() >= 1024;
        this.leaderboardPanel = this.createLeaderboardPanel(lifecycle, settings, leaderboardName, leaderboardGroupName, this.competitorSearchTextBox, availableDetailTypes, withSecurity);
        this.addChildComponent((Component)this.leaderboardPanel);
        this.leaderboardPanel.addVisibilityListener(visible -> this.quickFlagDataProvider.setLeaderboardNotCurrentlyUpdating(!visible));
        this.leaderboardPanel.setTitle(stringMessages.leaderboard());
        this.leaderboardPanel.getElement().getStyle().setMarginLeft(6.0, Style.Unit.PX);
        this.leaderboardPanel.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.createOneScreenView(lifecycle, settings, leaderboardName, leaderboardGroupName, leaderboardGroupId, eventId, (FlowPanel)mainPanel, isScreenLargeEnoughToInitiallyDisplayLeaderboard, this.raceMap, withSecurity.getUserService(), showChartMarkEditMediaButtonsAndVideo, leaderboardDTO, raceDTO, (PaywallResolver)paywallResolverRace);
        this.leaderboardPanel.addLeaderboardUpdateListener((LeaderboardUpdateListener)this);
        this.raceMap.addMediaPlayerManagerComponent(this.mediaPlayerManagerComponent);
        if (parsedPerspectiveOwnSettings.getActiveCompetitorsFilterSetName() != null) {
            for (FilterSet filterSet : this.competitorSearchTextBox.getCompetitorsFilterSets().getFilterSets()) {
                if (!filterSet.getName().equals(parsedPerspectiveOwnSettings.getActiveCompetitorsFilterSetName())) continue;
                this.competitorSearchTextBox.updateCompetitorFilterSetAndView(filterSet);
                break;
            }
        }
        this.racetimePanel = new RaceTimePanel((Component)this, componentContext, raceTimePanelLifecycle, withSecurity.getUserService(), timer, (TimeRangeWithZoomProvider)this.timeRangeWithZoomModel, stringMessages, raceTimesInfoProvider, parsedPerspectiveOwnSettings.isCanReplayDuringLiveRaces(), showChartMarkEditMediaButtonsAndVideo, selectedRaceIdentifier, parsedPerspectiveOwnSettings.getInitialDurationAfterRaceStartInReplay(), raceDTO);
        this.racetimePanel.updateSettings(raceTimePanelSettings);
        this.timeRangeWithZoomModel.addTimeZoomChangeListener((TimeZoomChangeListener)this.racetimePanel);
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)this.racetimePanel);
        this.timePanelWrapper = this.createTimePanelLayoutWrapper();
        boolean advanceTimePanelEnabled = true;
        if (advanceTimePanelEnabled) {
            this.manageTimePanelToggleButton(advanceTimePanelEnabled);
        }
        this.addChildComponent((Component)this.racetimePanel);
        Long zoomStartMillis = parsedPerspectiveOwnSettings.getZoomStart();
        Long zoomEndMillis = parsedPerspectiveOwnSettings.getZoomEnd();
        if (isScreenLargeEnoughToInitiallyDisplayLeaderboard && zoomStartMillis != null && zoomEndMillis != null) {
            Date zoomStart = new Date(zoomStartMillis);
            Date zoomEnd = new Date(zoomEndMillis);
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.dockPanel = new DockLayoutPanel(Style.Unit.PX);
        this.dockPanel.addSouth((Widget)this.timePanelWrapper, 67.0);
        this.dockPanel.add((Widget)mainPanel);
        this.dockPanel.addStyleName("dockLayoutPanel");
        this.initWidget((Widget)this.dockPanel);
    }

    private void createOneScreenView(RaceBoardPerspectiveLifecycle lifecycle, PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> settings, String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, UUID event, FlowPanel mainPanel, boolean isScreenLargeEnoughToInitiallyDisplayLeaderboard, RaceMap raceMap, UserService userService, boolean showChartMarkEditMediaButtonsAndVideo, StrippedLeaderboardDTO leaderboard, RaceWithCompetitorsAndBoatsDTO raceDTO, PaywallResolver paywallResolver) {
        MediaPlayerLifecycle mediaPlayerLifecycle = ((RaceBoardPerspectiveLifecycle)this.getPerspectiveLifecycle()).getMediaPlayerLifecycle();
        MediaPlayerSettings mediaPlayerSettings = (MediaPlayerSettings)settings.findSettingsByComponentId(mediaPlayerLifecycle.getComponentId());
        WindChartLifecycle windChartLifecycle = ((RaceBoardPerspectiveLifecycle)this.getPerspectiveLifecycle()).getWindChartLifecycle();
        WindChartSettings windChartSettings = (WindChartSettings)settings.findSettingsByComponentId(windChartLifecycle.getComponentId());
        ManeuverTableLifecycle maneuverTableLifecycle = ((RaceBoardPerspectiveLifecycle)this.getPerspectiveLifecycle()).getManeuverTable();
        ManeuverTableSettings maneuverTableSettings = (ManeuverTableSettings)settings.findSettingsByComponentId(maneuverTableLifecycle.getComponentId());
        MultiCompetitorRaceChartLifecycle multiCompetitorRaceChartLifecycle = ((RaceBoardPerspectiveLifecycle)this.getPerspectiveLifecycle()).getMultiCompetitorRaceChartLifecycle();
        MultiCompetitorRaceChartSettings multiCompetitorRaceChartSettings = (MultiCompetitorRaceChartSettings)settings.findSettingsByComponentId(multiCompetitorRaceChartLifecycle.getComponentId());
        RaceBoardPerspectiveOwnSettings initialPerspectiveOwnSettings = (RaceBoardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings();
        this.raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)raceMap);
        ArrayList<Util.Pair> componentsForSideBySideViewer = new ArrayList<Util.Pair>();
        if (showChartMarkEditMediaButtonsAndVideo) {
            this.competitorChart = new MultiCompetitorRaceChart((Component)this, this.getComponentContext(), multiCompetitorRaceChartLifecycle, this.sailingService, this.asyncActionsExecutor, this.competitorSelectionProvider, this.selectedRaceIdentifier, this.timer, (TimeRangeWithZoomProvider)this.timeRangeWithZoomModel, this.stringMessages, this.errorReporter, true, true, leaderboardGroupName, leaderboardGroupId, leaderboardName);
            this.competitorChart.setVisible(false);
            this.competitorChart.updateSettings(multiCompetitorRaceChartSettings);
            new SliceRaceHandler(this.sailingServiceWrite, this.sailingService, userService, this.errorReporter, this.competitorChart, this.selectedRaceIdentifier, leaderboardGroupName, leaderboardGroupId, leaderboardName, event, leaderboard, raceDTO, this.stringMessages);
            componentsForSideBySideViewer.add(new Util.Pair((Object)this.competitorChart, (Object)SecuredDomainType.TrackedRaceActions.VIEWANALYSISCHARTS));
            this.windChart = new WindChart((Component)this, this.getComponentContext(), windChartLifecycle, this.sailingService, this.selectedRaceIdentifier, this.timer, (TimeRangeWithZoomProvider)this.timeRangeWithZoomModel, windChartSettings, this.stringMessages, this.asyncActionsExecutor, this.errorReporter, true);
            this.windChart.setVisible(false);
            componentsForSideBySideViewer.add(new Util.Pair((Object)this.windChart, (Object)SecuredDomainType.TrackedRaceActions.VIEWANALYSISCHARTS));
        }
        this.maneuverTablePanel = new ManeuverTablePanel((Component)this, this.getComponentContext(), this.sailingService, this.asyncActionsExecutor, this.selectedRaceIdentifier, this.stringMessages, this.competitorSelectionProvider, this.errorReporter, this.timer, maneuverTableSettings, this.timeRangeWithZoomModel, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), userService, raceDTO);
        this.maneuverTablePanel.getEntryWidget().setTitle(this.stringMessages.maneuverTable());
        if (showChartMarkEditMediaButtonsAndVideo) {
            componentsForSideBySideViewer.add(new Util.Pair((Object)this.maneuverTablePanel, (Object)SecuredDomainType.TrackedRaceActions.VIEWANALYSISCHARTS));
        }
        this.editMarkPassingPanel = new EditMarkPassingsPanel((Component)this, this.getComponentContext(), this.sailingService, this.sailingServiceWrite, this.selectedRaceIdentifier, this.stringMessages, (CompetitorSelectionProvider)this.competitorSelectionProvider, this.errorReporter, this.timer);
        if (showChartMarkEditMediaButtonsAndVideo) {
            this.editMarkPassingPanel.setLeaderboard(this.leaderboardPanel.getLeaderboard());
            this.editMarkPassingPanel.getEntryWidget().setTitle(this.stringMessages.editMarkPassings());
            componentsForSideBySideViewer.add(new Util.Pair((Object)this.editMarkPassingPanel, null));
        }
        this.editMarkPositionPanel = new EditMarkPositionPanel((Component)this, this.getComponentContext(), raceMap, this.leaderboardPanel, this.selectedRaceIdentifier, leaderboardName, this.stringMessages, this.sailingService, this.timer, (TimeRangeWithZoomProvider)this.timeRangeWithZoomModel, this.asyncActionsExecutor, this.errorReporter, this.sailingServiceWrite);
        if (showChartMarkEditMediaButtonsAndVideo) {
            this.editMarkPositionPanel.setLeaderboard(this.leaderboardPanel.getLeaderboard());
            componentsForSideBySideViewer.add(new Util.Pair((Object)this.editMarkPositionPanel, null));
        }
        this.mediaPlayerManagerComponent = new MediaPlayerManagerComponent((Component)this, this.getComponentContext(), mediaPlayerLifecycle, this.sailingServiceWrite, this.selectedRaceIdentifier, this.raceTimesInfoProvider, this.timer, this.mediaService, this.mediaServiceWrite, userService, this.stringMessages, this.errorReporter, this.userAgent, (PopupPositionProvider)this, mediaPlayerSettings, (RaceDTO)raceDTO, leaderboardGroupName, event);
        5 asyncFetcher = new /* Unavailable Anonymous Inner Class!! */;
        this.mapViewer = new SideBySideComponentViewer((Component)this.leaderboardPanel, raceMap, (Component)this.taggingComponent, this.mediaPlayerManagerComponent, componentsForSideBySideViewer, this.stringMessages, userService, this.editMarkPassingPanel, this.editMarkPositionPanel, this.maneuverTablePanel, (LeaderboardWithSecurityFetcher)asyncFetcher, paywallResolver, (SecuredDTO)raceDTO);
        this.mediaPlayerManagerComponent.addPlayerChangeListener((MediaPlayerManager.PlayerChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addChildComponent((Component)this.mediaPlayerManagerComponent);
        for (Util.Pair componentAndAction : componentsForSideBySideViewer) {
            this.addChildComponent((Component)componentAndAction.getA());
        }
        this.setupUserManagementControlPanel(userService, paywallResolver);
        mainPanel.add((Widget)this.mapViewer.getViewerWidget());
        boolean showLeaderboard = initialPerspectiveOwnSettings.isShowLeaderboard() && isScreenLargeEnoughToInitiallyDisplayLeaderboard;
        this.setLeaderboardVisible(showLeaderboard);
        this.leaderboardPanel.setAutoExpandPreSelected(initialPerspectiveOwnSettings.isAutoExpandPreSelectedRace().booleanValue());
        if (showChartMarkEditMediaButtonsAndVideo) {
            boolean hasAnalasysChartPermission = paywallResolver.hasPermission((HasPermissions.Action)SecuredDomainType.TrackedRaceActions.VIEWANALYSISCHARTS, (SecuredDTO)raceDTO);
            this.setWindChartVisible(hasAnalasysChartPermission && initialPerspectiveOwnSettings.isShowWindChart());
            this.setCompetitorChartVisible(hasAnalasysChartPermission && initialPerspectiveOwnSettings.isShowCompetitorsChart());
            this.setManeuverTableVisible(hasAnalasysChartPermission && initialPerspectiveOwnSettings.isShowManeuver());
            this.setTagPanelVisible(initialPerspectiveOwnSettings.isShowTags());
        }
        if (!showLeaderboard) {
            this.leaderboardPanel.setVisible(true);
            this.leaderboardPanel.setVisible(false);
        }
    }

    protected void updateRaceTimePanelOverlay() {
        ArrayList<TimeSlider.BarOverlay> overlays = new ArrayList<TimeSlider.BarOverlay>();
        Set videoPlaying = this.mediaPlayerManagerComponent.getPlayingVideoTracks();
        Set audioPlaying = this.mediaPlayerManagerComponent.getPlayingAudioTrack();
        for (MediaTrack track : this.mediaPlayerManagerComponent.getAssignedMediaTracks()) {
            double start = track.startTime.asMillis();
            TimePoint endTp = track.deriveEndTime();
            double end = endTp == null ? Double.MAX_VALUE : (double)endTp.asMillis();
            boolean isPlaying = videoPlaying.contains(track) || audioPlaying.contains(track);
            overlays.add(new TimeSlider.BarOverlay(Double.valueOf(start), Double.valueOf(end), isPlaying, track.title));
        }
        this.racetimePanel.setBarOverlays(overlays);
    }

    private void setupUserManagementControlPanel(UserService userService, PaywallResolver paywallResolver) {
        this.mainCss.ensureInjected();
        RaceBoardAuthenticationView display = new RaceBoardAuthenticationView();
        GenericAuthentication genericAuthentication = new GenericAuthentication(userService, paywallResolver, this.userManagementMenuView, (FlyoutAuthenticationView)display, SailingAuthenticationEntryPointLinkFactory.INSTANCE, (CommonSharedResources)this.raceBoardResources);
        new RaceBoardLoginHintPopup(genericAuthentication.getAuthenticationManager());
    }

    private <SettingsType extends AbstractSettings> void addSettingsMenuItem(MenuBar settingsMenu, Component<SettingsType> component) {
        if (component.hasSettings()) {
            MenuItem menuItem = settingsMenu.addItem(component.getLocalizedShortName(), (Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private SingleRaceLeaderboardPanel createLeaderboardPanel(RaceBoardPerspectiveLifecycle lifecycle, PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> settings, String leaderboardName, String leaderboardGroupName, CompetitorFilterPanel competitorSearchTextBox, Iterable<DetailType> availableDetailTypes, WithSecurity withSecurity) {
        SingleRaceLeaderboardPanelLifecycle leaderboardPanelLifecycle = ((RaceBoardPerspectiveLifecycle)this.getPerspectiveLifecycle()).getLeaderboardPanelLifecycle();
        SingleRaceLeaderboardSettings leaderboardSettings = (SingleRaceLeaderboardSettings)settings.findSettingsByComponentId(leaderboardPanelLifecycle.getComponentId());
        return new SingleRaceLeaderboardPanel((Component)this, this.getComponentContext(), this.sailingService, this.asyncActionsExecutor, leaderboardSettings, this.selectedRaceIdentifier != null, this.selectedRaceIdentifier, this.competitorSelectionProvider, this.timer, leaderboardGroupName, leaderboardName, this.errorReporter, this.stringMessages, true, competitorSearchTextBox, true, this.raceTimesInfoProvider, false, false, false, false, false, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), FlagImageResolverImpl.get(), availableDetailTypes, withSecurity);
    }

    private void setComponentVisible(SideBySideComponentViewer componentViewer, Component<?> component, boolean visible) {
        component.setVisible(visible);
        componentViewer.forceLayout();
    }

    SingleRaceLeaderboardPanel getLeaderboardPanel() {
        return this.leaderboardPanel;
    }

    MultiCompetitorRaceChart getCompetitorChart() {
        return this.competitorChart;
    }

    WindChart getWindChart() {
        return this.windChart;
    }

    RaceTimePanel getRaceTimePanel() {
        return this.racetimePanel;
    }

    Timer getTimer() {
        return this.timer;
    }

    RaceMap getMap() {
        return this.raceMap;
    }

    RegattaAndRaceIdentifier getSelectedRaceIdentifier() {
        return this.selectedRaceIdentifier;
    }

    CompetitorSelectionProvider getCompetitorSelectionProvider() {
        return this.competitorSelectionProvider;
    }

    public void setLeaderboardVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.leaderboardPanel, visible);
    }

    public void setTaggingPanelVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.taggingComponent, visible);
    }

    public void setWindChartVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.windChart, visible);
    }

    public void showInWindChart(WindSource windprovider) {
        this.setComponentVisible(this.mapViewer, (Component)this.windChart, true);
        this.windChart.showProvider(windprovider);
    }

    public void setCompetitorChartVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.competitorChart, visible);
    }

    public void setTagPanelVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.taggingComponent, visible);
    }

    public void setManeuverTableVisible(boolean visible) {
        this.setComponentVisible(this.mapViewer, (Component)this.maneuverTablePanel, visible);
    }

    protected SailingServiceAsync getSailingService() {
        return this.sailingService;
    }

    protected String getRaceBoardName() {
        return this.raceBoardName;
    }

    protected void setRaceBoardName(String raceBoardName) {
        this.raceBoardName = raceBoardName;
    }

    protected ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void updatedLeaderboard(LeaderboardDTO leaderboard) {
        if (this.editMarkPassingPanel != null) {
            this.editMarkPassingPanel.setLeaderboard(leaderboard);
        }
        if (this.editMarkPositionPanel != null) {
            this.editMarkPositionPanel.setLeaderboard(leaderboard);
        }
        this.quickFlagDataProvider.updateFlagData(leaderboard);
    }

    private Dropdown createRaceDropDown(RaceColumnDTO raceColumnOfSelectedRace, FleetDTO fleetOfSelectedRace) {
        Dropdown result = new Dropdown((DropdownResources)RaceboardDropdownResources.INSTANCE);
        for (RaceColumnDTO raceColumn : this.getLeaderboardPanel().getLeaderboard().getRaceList()) {
            for (FleetDTO fleet : raceColumn.getFleets()) {
                RegattaAndRaceIdentifier raceIdentifier = raceColumn.getRaceIdentifier(fleet);
                if (raceIdentifier == null) continue;
                String displayName = String.valueOf("Default".equals(raceColumn.getSeriesName()) ? "" : String.valueOf(raceColumn.getSeriesName()) + "/\u200b") + raceColumn.getName() + ("Default".equals(fleet.getName()) ? "" : "/\u200b" + fleet.getName());
                boolean selected = raceColumn.equals((Object)raceColumnOfSelectedRace) && fleet.equals((Object)fleetOfSelectedRace);
                result.addItem(displayName, null, selected, () -> this.lambda$5((RaceIdentifier)raceIdentifier, result));
                if (!selected) continue;
                result.setDisplayedText(displayName);
            }
        }
        return result;
    }

    public void currentRaceSelected(RaceIdentifier raceIdentifier, RaceColumnDTO raceColumn) {
        if (!this.currentRaceHasBeenSelectedOnce) {
            FleetDTO fleet = raceColumn.getFleet(raceIdentifier);
            Dropdown raceDropDown = this.createRaceDropDown(raceColumn, fleet);
            Label raceNameLabel = new Label(String.valueOf(this.stringMessages.race()) + " " + raceColumn.getRaceColumnName());
            raceNameLabel.setStyleName("RaceName-Label");
            this.racePicker.clear();
            this.racePicker.add((Widget)raceDropDown);
            Anchor regattaNameAnchor = new Anchor(raceIdentifier.getRegattaName());
            regattaNameAnchor.setTitle(raceIdentifier.getRegattaName());
            if (this.eventId != null) {
                String link = EntryPointLinkFactory.createRacesTabLink((String)this.eventId.toString(), (String)this.leaderboardName);
                regattaNameAnchor.setHref(link);
            } else {
                String leaderboardGroupNameParam = this.getLeaderboardGroupName();
                if (leaderboardGroupNameParam != null) {
                    HashMap<String, String> leaderboardGroupLinkParameters = new HashMap<String, String>();
                    leaderboardGroupLinkParameters.put("showRaceDetails", "true");
                    leaderboardGroupLinkParameters.put("leaderboardGroupName", leaderboardGroupNameParam);
                    String leaderBoardGroupLink = EntryPointLinkFactory.createLeaderboardGroupLink(leaderboardGroupLinkParameters);
                    regattaNameAnchor.setHref(leaderBoardGroupLink);
                } else {
                    regattaNameAnchor.setHref("javascript:window.history.back();");
                }
            }
            regattaNameAnchor.setStyleName("RegattaName-Anchor");
            Label raceTimeLabel = this.computeRaceInformation(raceColumn, fleet);
            raceTimeLabel.setStyleName("RaceTime-Label");
            this.regattaAndRaceTimeInformationHeader.clear();
            FlowPanel helpButtonAndRaceTimePanel = new FlowPanel();
            helpButtonAndRaceTimePanel.setStyleName("Help-And-RaceTime");
            HelpButton helpButton = new HelpButton(HelpButtonResources.INSTANCE, this.stringMessages.videoGuide(), "https://wiki.sapsailing.com/wiki/howto/tutorials/sailinganalytics/tracking-race-player.md");
            if (!DeviceDetector.isMobile()) {
                helpButtonAndRaceTimePanel.add((Widget)helpButton);
            }
            helpButtonAndRaceTimePanel.add((Widget)raceTimeLabel);
            this.regattaAndRaceTimeInformationHeader.add((Widget)regattaNameAnchor);
            this.regattaAndRaceTimeInformationHeader.add((Widget)helpButtonAndRaceTimePanel);
            DataByLogo dataByLogo = new DataByLogo();
            dataByLogo.setUp(this.trackingConnectorInfo == null ? Collections.emptySet() : Collections.singleton(this.trackingConnectorInfo), false, true);
            if (dataByLogo.isVisible()) {
                this.regattaAndRaceTimeInformationHeader.addStyleName("RegattaAndRaceTime-Header_with_databy");
            }
            this.regattaAndRaceTimeInformationHeader.add((Widget)dataByLogo);
            this.currentRaceHasBeenSelectedOnce = true;
            this.taggingComponent.updateRace(this.leaderboardName, raceColumn, fleet);
        }
    }

    private String getLeaderboardGroupName() {
        return this.raceboardContextDefinition == null ? null : this.raceboardContextDefinition.getLeaderboardGroupName();
    }

    public UIObject getXPositionUiObject() {
        return this.racetimePanel;
    }

    public UIObject getYPositionUiObject() {
        return this.racetimePanel;
    }

    private Label computeRaceInformation(RaceColumnDTO raceColumn, FleetDTO fleet) {
        Date startDate = raceColumn.getStartDate(fleet);
        Label raceInformationLabel = new Label();
        raceInformationLabel.setStyleName("Race-Time-Label");
        if (startDate != null) {
            DateTimeFormat formatter = DateTimeFormat.getFormat((String)"E d/M/y");
            raceInformationLabel.setText(formatter.format(startDate));
        }
        return raceInformationLabel;
    }

    public Widget getEntryWidget() {
        return this;
    }

    public String getDependentCssClassName() {
        return "";
    }

    private void manageTimePanelToggleButton(boolean advanceTimePanelEnabled) {
        Button toggleButton = this.getRaceTimePanel().getAdvancedToggleButton();
        if (advanceTimePanelEnabled) {
            toggleButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            toggleButton.setVisible(false);
        }
    }

    private ResizableFlowPanel createTimePanelLayoutWrapper() {
        ResizableFlowPanel timeLineInnerBgPanel = new ResizableFlowPanel();
        timeLineInnerBgPanel.addStyleName("timeLineInnerBgPanel");
        timeLineInnerBgPanel.add((Widget)this.getRaceTimePanel());
        ResizableFlowPanel timeLineInnerPanel = new ResizableFlowPanel();
        timeLineInnerPanel.add((Widget)timeLineInnerBgPanel);
        timeLineInnerPanel.addStyleName("timeLineInnerPanel");
        ResizableFlowPanel timelinePanel = new ResizableFlowPanel();
        timelinePanel.add((Widget)timeLineInnerPanel);
        timelinePanel.addStyleName("timeLinePanel");
        return timelinePanel;
    }

    public SettingsDialogComponent<RaceBoardPerspectiveOwnSettings> getPerspectiveOwnSettingsDialogComponent() {
        return new RaceBoardPerspectiveSettingsDialogComponent(this.getPerspectiveSettings(), this.stringMessages);
    }

    protected RaceBoardPerspectiveOwnSettings getPerspectiveSettings() {
        Duration newInitialDurationAfterRaceStartInReplay;
        RaceBoardPerspectiveOwnSettings initialSettings = (RaceBoardPerspectiveOwnSettings)super.getPerspectiveSettings();
        CompetitorsFilterSets leaderboardFiterPanelFilterSets = this.competitorSearchTextBox.getCompetitorsFilterSets();
        FilterSet activeFilterSet = leaderboardFiterPanelFilterSets.getActiveFilterSet();
        String activeCompetitorsFilterSetName = activeFilterSet == null ? null : activeFilterSet.getName();
        HashSet<String> selectedCompetitorIds = new HashSet<String>();
        if (this.timer != null && this.racetimePanel != null) {
            Date currentTimerDate = this.timer.getTime();
            Date startOfRace = this.racetimePanel.getLastRaceTimesInfo().startOfRace;
            newInitialDurationAfterRaceStartInReplay = startOfRace == null ? null : new MillisecondsDurationImpl(currentTimerDate.getTime() - startOfRace.getTime());
        } else {
            newInitialDurationAfterRaceStartInReplay = initialSettings.getInitialDurationAfterRaceStartInReplay();
        }
        for (CompetitorDTO competitorDTO : this.getCompetitorSelectionProvider().getSelectedCompetitors()) {
            selectedCompetitorIds.add(competitorDTO.getIdAsString());
        }
        Util.Pair timeZoom = this.timeRangeWithZoomModel.getTimeZoom();
        Long zoomStartInMillis = null;
        Long zoomEndInMillis = null;
        if (timeZoom.getA() != null && timeZoom.getB() != null) {
            zoomStartInMillis = ((Date)timeZoom.getA()).getTime();
            zoomEndInMillis = ((Date)timeZoom.getB()).getTime();
        }
        boolean isCompetitorChartVisible = this.competitorChart == null ? false : this.competitorChart.isVisible();
        boolean isWindChartVisible = this.windChart == null ? false : this.windChart.isVisible();
        boolean isManeuverTableVisible = this.maneuverTablePanel == null ? false : this.maneuverTablePanel.isVisible();
        boolean autoExpandPreSelectedRace = this.leaderboardPanel.isAutoExpandPreSelectedRace();
        RaceBoardPerspectiveOwnSettings raceBoardPerspectiveOwnSettings = new RaceBoardPerspectiveOwnSettings(activeCompetitorsFilterSetName, Boolean.valueOf(this.leaderboardPanel.isVisible()), Boolean.valueOf(isWindChartVisible), Boolean.valueOf(isCompetitorChartVisible), Boolean.valueOf(initialSettings.isCanReplayDuringLiveRaces()), newInitialDurationAfterRaceStartInReplay, null, selectedCompetitorIds, Boolean.valueOf(this.taggingComponent.isVisible()), Boolean.valueOf(isManeuverTableVisible), initialSettings.getJumpToTag(), zoomStartInMillis, zoomEndInMillis, Boolean.valueOf(autoExpandPreSelectedRace));
        return raceBoardPerspectiveOwnSettings;
    }

    public RaceBoardPerspectiveOwnSettings getOriginalPerspectiveSettings() {
        return (RaceBoardPerspectiveOwnSettings)super.getPerspectiveSettings();
    }

    public boolean hasPerspectiveOwnSettings() {
        return true;
    }

    public void onResize() {
        this.dockPanel.onResize();
    }

    public String getId() {
        return "rb";
    }

    static /* synthetic */ SideBySideComponentViewer access$1(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.mapViewer;
    }

    static /* synthetic */ RaceMap access$2(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.raceMap;
    }

    static /* synthetic */ SingleRaceLeaderboardPanel access$3(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.leaderboardPanel;
    }

    static /* synthetic */ TimeRangeWithZoomModel access$4(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.timeRangeWithZoomModel;
    }

    static /* synthetic */ SailingServiceAsync access$5(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.sailingService;
    }

    static /* synthetic */ ErrorReporter access$6(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$7(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.stringMessages;
    }

    static /* synthetic */ DockLayoutPanel access$8(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.dockPanel;
    }

    static /* synthetic */ ResizableFlowPanel access$9(RaceBoardPanel raceBoardPanel) {
        return raceBoardPanel.timePanelWrapper;
    }

    private /* synthetic */ void lambda$5(RaceIdentifier raceIdentifier, Dropdown dropdown) {
        RaceboardContextDefinition strippedRaceBoardContextDefinition = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), this.getLeaderboardPanel().getLeaderboard().getName(), this.raceboardContextDefinition.getLeaderboardGroupName(), this.raceboardContextDefinition.getLeaderboardGroupId(), this.raceboardContextDefinition.getEventId(), null);
        LinkWithSettingsGenerator linkWithSettingsGenerator = new LinkWithSettingsGenerator(RACEBOARD_PATH, new GenericSerializableSettings[]{strippedRaceBoardContextDefinition});
        String url = linkWithSettingsGenerator.createUrl((Settings)this.getSettings());
        Window.open((String)url, (String)raceIdentifier.toString(), (String)"");
        dropdown.hide();
    }
}

