/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceCompetitorSet;
import com.sap.sailing.gwt.ui.raceboard.AbstractQuickFlagDataProvider;
import com.sap.sailing.gwt.ui.raceboard.QuickFlagDataFromLeaderboardDTOProvider;
import com.sap.sailing.gwt.ui.shared.QuickRankDTO;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuickFlagDataFromLeaderboardDTOProvider
extends AbstractQuickFlagDataProvider {
    private final Map<String, QuickRankDTO> quickRanks = new HashMap();
    private final Map<String, Double> quickSpeedsInKnots = new HashMap();
    private final Map<String, Double> speedsFromLeaderboardInKnots = new HashMap();
    private final RaceCompetitorSet raceCompetitorSet;
    private final RaceIdentifier selectedRace;
    private boolean lastLeaderboardProvidedLegNumbers;
    private String raceColumnName;
    private boolean leaderboardNotCurrentlyUpdating;

    public QuickFlagDataFromLeaderboardDTOProvider(RaceCompetitorSet raceCompetitorSet, RaceIdentifier selectedRace) {
        this.raceCompetitorSet = raceCompetitorSet;
        this.selectedRace = selectedRace;
    }

    public void setLeaderboardNotCurrentlyUpdating(boolean leaderboardNotCurrentlyUpdating) {
        this.leaderboardNotCurrentlyUpdating = leaderboardNotCurrentlyUpdating;
        if (leaderboardNotCurrentlyUpdating) {
            this.speedsFromLeaderboardInKnots.clear();
        }
    }

    public void quickRanksReceivedFromServer(Map<String, QuickRankDTO> quickRanksFromServer) {
        block3: {
            block2: {
                if (!this.quickRanks.isEmpty() && !this.leaderboardNotCurrentlyUpdating) break block2;
                for (Map.Entry<String, QuickRankDTO> e : quickRanksFromServer.entrySet()) {
                    QuickRankDTO oldQuickRank = this.quickRanks.put(e.getKey(), e.getValue());
                    this.notifyListenersRankChanged(e.getKey(), oldQuickRank, e.getValue());
                }
                break block3;
            }
            if (this.lastLeaderboardProvidedLegNumbers) break block3;
            for (Map.Entry e : this.quickRanks.entrySet()) {
                QuickRankDTO quickRankFromServer = quickRanksFromServer.get(e.getKey());
                if (quickRankFromServer == null) continue;
                ((QuickRankDTO)e.getValue()).legNumberOneBased = quickRankFromServer.legNumberOneBased;
            }
        }
    }

    public void updateFlagData(LeaderboardDTO leaderboard) {
        block11: {
            this.determineRaceColumnName(leaderboard);
            if (this.raceColumnName == null) break block11;
            List competitorsFromBestToWorst = leaderboard.getCompetitorsFromBestToWorst(this.raceColumnName);
            if (competitorsFromBestToWorst.isEmpty()) {
                for (CompetitorDTO c : leaderboard.competitors) {
                    QuickRankDTO quickRank = new QuickRankDTO(c, 0, 0);
                    QuickRankDTO oldQuickRank = this.quickRanks.put(c.getIdAsString(), quickRank);
                    if (Util.equalsWithNull((Object)oldQuickRank, (Object)quickRank)) continue;
                    this.notifyListenersRankChanged(c.getIdAsString(), oldQuickRank, quickRank);
                }
            } else {
                int oneBasedRank = 1;
                1 sogProvider = new /* Unavailable Anonymous Inner Class!! */;
                for (CompetitorDTO c : competitorsFromBestToWorst) {
                    int oneBasedLegNumber;
                    if (!Util.contains((Iterable)this.raceCompetitorSet.getIdsOfCompetitorsParticipatingInRaceAsStrings(), (Object)c.getIdAsString())) continue;
                    LeaderboardRowDTO row = (LeaderboardRowDTO)leaderboard.rows.get(c);
                    Double speedInKnots = null;
                    if (row != null && row.fieldsByRaceColumnName.get(this.raceColumnName) != null) {
                        LeaderboardEntryDTO raceEntryForCompetitor = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.raceColumnName);
                        List legDetailsList = raceEntryForCompetitor.legDetails;
                        if (raceEntryForCompetitor != null && legDetailsList != null) {
                            int oneBasedLegNumberCandidate = raceEntryForCompetitor.getOneBasedCurrentLegNumber();
                            oneBasedLegNumber = oneBasedLegNumberCandidate == legDetailsList.size() && ((LegEntryDTO)legDetailsList.get((int)(oneBasedLegNumberCandidate - 1))).finished ? 0 : oneBasedLegNumberCandidate;
                            this.lastLeaderboardProvidedLegNumbers = true;
                            speedInKnots = (Double)sogProvider.get(row);
                        } else {
                            oneBasedLegNumber = 0;
                            this.lastLeaderboardProvidedLegNumbers = false;
                        }
                    } else {
                        oneBasedLegNumber = 0;
                    }
                    QuickRankDTO quickRankToUpdate = (QuickRankDTO)this.quickRanks.get(c.getIdAsString());
                    if (quickRankToUpdate == null) {
                        QuickRankDTO quickRankDTO = new QuickRankDTO(c, oneBasedRank, oneBasedLegNumber);
                        this.quickRanks.put(c.getIdAsString(), quickRankDTO);
                        this.notifyListenersRankChanged(c.getIdAsString(), null, quickRankDTO);
                    } else {
                        QuickRankDTO oldQuickRank = new QuickRankDTO(quickRankToUpdate.competitor, quickRankToUpdate.oneBasedRank, quickRankToUpdate.legNumberOneBased);
                        quickRankToUpdate.oneBasedRank = oneBasedRank;
                        if (this.lastLeaderboardProvidedLegNumbers) {
                            quickRankToUpdate.legNumberOneBased = oneBasedLegNumber;
                        }
                        this.notifyListenersRankChanged(c.getIdAsString(), oldQuickRank, quickRankToUpdate);
                    }
                    ++oneBasedRank;
                    this.speedsFromLeaderboardInKnots.put(c.getIdAsString(), speedInKnots);
                    if (speedInKnots == null) continue;
                    this.notifyListenersSpeedInKnotsChanged(c, speedInKnots);
                }
            }
        }
    }

    public Map<String, QuickRankDTO> getQuickRanks() {
        return this.quickRanks;
    }

    private void determineRaceColumnName(LeaderboardDTO leaderboard) {
        RaceColumnDTO raceColumn = leaderboard.getRaceColumnByName(this.raceColumnName);
        if (raceColumn == null || !raceColumn.containsRace(this.selectedRace)) {
            this.raceColumnName = this.getRaceColumnName(leaderboard, this.selectedRace);
        }
    }

    public void quickSpeedsInKnotsReceivedFromServer(Map<String, Double> quickSpeedsFromServerInKnotsByCompetitorIdAsString, Map<String, CompetitorDTO> competitorsByIdAsString) {
        for (Map.Entry<String, Double> e : quickSpeedsFromServerInKnotsByCompetitorIdAsString.entrySet()) {
            this.quickSpeedsInKnots.put(e.getKey(), e.getValue());
            if (this.speedsFromLeaderboardInKnots.get(e.getKey()) != null && !this.leaderboardNotCurrentlyUpdating) continue;
            this.notifyListenersSpeedInKnotsChanged(competitorsByIdAsString.get(e.getKey()), e.getValue());
        }
    }

    public Double getQuickSpeedsInKnots(CompetitorDTO competitor) {
        Double result = this.speedsFromLeaderboardInKnots.containsKey(competitor.getIdAsString()) && !this.leaderboardNotCurrentlyUpdating ? (Double)this.speedsFromLeaderboardInKnots.get(competitor.getIdAsString()) : (Double)this.quickSpeedsInKnots.get(competitor.getIdAsString());
        return result;
    }

    private String getRaceColumnName(LeaderboardDTO leaderboard, RaceIdentifier selectedRace) {
        for (RaceColumnDTO raceColumn : leaderboard.getRaceList()) {
            if (!raceColumn.containsRace(selectedRace)) continue;
            return raceColumn.getName();
        }
        return null;
    }

    static /* synthetic */ String access$0(QuickFlagDataFromLeaderboardDTOProvider quickFlagDataFromLeaderboardDTOProvider) {
        return quickFlagDataFromLeaderboardDTOProvider.raceColumnName;
    }
}

