/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.datamining.StoredDataMiningQueryDataProvider;
import com.sap.sailing.gwt.ui.datamining.StoredDataMiningQueryPanel;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.gwt.client.Notification;
import java.util.Collection;

public class StoredDataMiningQueryPanel
extends Composite {
    private static PersistDataMiningQueryPanelUiBinder uiBinder = (PersistDataMiningQueryPanelUiBinder)GWT.create(PersistDataMiningQueryPanelUiBinder.class);
    @UiField
    Button saveQueryButtonUi;
    @UiField
    Button loadQueryButtonUi;
    @UiField
    Button removeQueryButtonUi;
    @UiField(provided=true)
    SuggestBox suggestBoxUi;
    private final MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
    private StoredDataMiningQueryDataProvider dataProvider;

    public StoredDataMiningQueryPanel() {
        this.suggestBoxUi = new SuggestBox((SuggestOracle)this.oracle, (ValueBoxBase)new TextBox(), (SuggestBox.SuggestionDisplay)new /* Unavailable Anonymous Inner Class!! */);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.saveQueryButtonUi.setText(StringMessages.INSTANCE.save());
        this.loadQueryButtonUi.setText(StringMessages.INSTANCE.load());
        this.removeQueryButtonUi.setText(StringMessages.INSTANCE.remove());
        this.suggestBoxUi.getValueBox().getElement().setPropertyString("placeholder", StringMessages.INSTANCE.dataMiningStoredQueryPlaceholder());
        this.suggestBoxUi.getValueBox().addClickHandler(e -> this.suggestBoxUi.showSuggestionList());
        this.suggestBoxUi.getValueBox().addKeyUpHandler(e -> this.updateSaveLoadButtons());
        this.suggestBoxUi.getValueBox().addBlurHandler(e -> this.updateSaveLoadButtons());
    }

    private void updateSaveLoadButtons() {
        String text = this.suggestBoxUi.getValueBox().getText();
        this.saveQueryButtonUi.setEnabled(text != null && !"".equals(text.trim()));
        this.loadQueryButtonUi.setEnabled(this.dataProvider.containsQueryName(text));
        this.removeQueryButtonUi.setEnabled(this.dataProvider.containsQueryName(text));
    }

    public StoredDataMiningQueryPanel(StoredDataMiningQueryDataProvider dataProvider) {
        this();
        this.dataProvider = dataProvider;
        dataProvider.setUiPanel(this);
    }

    @UiHandler(value={"saveQueryButtonUi"})
    void onSaveClick(ClickEvent e) {
        String value = this.suggestBoxUi.getValue().trim();
        this.dataProvider.addOrUpdateQuery(value, this.dataProvider.getCurrentQuery(), isUpdate -> {
            if (isUpdate.booleanValue()) {
                Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryUpdateSuccessful(value), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
            } else {
                Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryCreationSuccessful(value), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
            }
        });
    }

    @UiHandler(value={"loadQueryButtonUi"})
    void onLoadClick(ClickEvent e) {
        if (this.dataProvider.applyQuery(this.suggestBoxUi.getValue())) {
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryLoadedSuccessful(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
        } else {
            Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryLoadedFailed(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.ERROR);
        }
    }

    @UiHandler(value={"removeQueryButtonUi"})
    void onRemoveClick(ClickEvent e) {
        this.dataProvider.removeQuery(this.suggestBoxUi.getValue(), isQueryPresent -> {
            if (isQueryPresent.booleanValue()) {
                this.suggestBoxUi.setValue("");
                Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryRemovedSuccessful(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
            } else {
                Notification.notify((String)StringMessages.INSTANCE.dataMiningStoredQueryRemovedFailed(this.suggestBoxUi.getValue()), (Notification.NotificationType)Notification.NotificationType.ERROR);
            }
        });
    }

    public void updateOracle(Collection<String> collection) {
        this.oracle.clear();
        this.oracle.addAll(collection);
        this.oracle.setDefaultSuggestionsFromText(collection);
        this.loadQueryButtonUi.setEnabled(!collection.isEmpty());
        this.removeQueryButtonUi.setEnabled(!collection.isEmpty());
        this.updateSaveLoadButtons();
    }

    static /* synthetic */ void access$0(StoredDataMiningQueryPanel storedDataMiningQueryPanel) {
        storedDataMiningQueryPanel.updateSaveLoadButtons();
    }
}

